/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.agents.acp.AcpAgentIcons;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.registry.AcpAgentInstallationState;
import com.intellij.ml.llm.agents.acp.registry.AcpExternalRegistry;
import com.intellij.ml.llm.agents.acp.registry.AcpIconCacheManagerKt;
import com.intellij.ml.llm.agents.acp.registry.AcpPaths;
import com.intellij.ml.llm.agents.acp.registry.AcpRegistryFetcher;
import com.intellij.ml.llm.agents.acp.registry.ExternalAgent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.ui.BadgeDotProvider;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.BadgeShapeProvider;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Paint;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\bJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpIconCacheManager;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "iconCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "Ljavax/swing/Icon;", "badgedIconCache", "badgeDotProvider", "Lcom/intellij/ui/BadgeDotProvider;", "getIcon", "agentId", "findVersionForIcon", "", "getBadgedIcon", "baseIcon", "downloadAndCacheIcon", "", "version", "iconUrl", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadIconInBackground", "", "downloadAllIcons", "registry", "Lcom/intellij/ml/llm/agents/acp/registry/AcpExternalRegistry;", "invalidateIconCache", "id", "deleteIcon", "(Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpIconCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpIconCacheManager.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpIconCacheManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,269:1\n1#2:270\n42#3,3:271\n42#3,3:274\n42#3,3:277\n42#3,3:280\n42#3,3:283\n42#3,3:286\n*S KotlinDebug\n*F\n+ 1 AcpIconCacheManager.kt\ncom/intellij/ml/llm/agents/acp/registry/AcpIconCacheManager\n*L\n65#1:271,3\n74#1:274,3\n93#1:277,3\n99#1:280,3\n135#1:283,3\n136#1:286,3\n*E\n"})
public final class AcpIconCacheManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ConcurrentHashMap<AcpAgentId, Icon> iconCache;
    @NotNull
    private final ConcurrentHashMap<Icon, Icon> badgedIconCache;
    @NotNull
    private final BadgeDotProvider badgeDotProvider;
    @NotNull
    private static final String LIGHT_COLOR = "#6C707E";
    @NotNull
    private static final String DARK_COLOR = "#CED0D6";

    public AcpIconCacheManager(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.iconCache = new ConcurrentHashMap();
        this.badgedIconCache = new ConcurrentHashMap();
        this.badgeDotProvider = new BadgeDotProvider(0.0, 0.0, 0.0, 0.0, 15, null);
    }

    @NotNull
    public final Icon getIcon(@NotNull AcpAgentId agentId) {
        Class<AcpPaths> serviceClass$iv;
        boolean $i$f$service;
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Icon icon2 = this.iconCache.get(agentId);
        if (icon2 != null) {
            Icon it = icon2;
            boolean bl = false;
            return it;
        }
        String version = this.findVersionForIcon(agentId);
        if (version != null) {
            $i$f$service = false;
            serviceClass$iv = AcpPaths.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            Path versionedPath = AcpPaths.getVersionedIconPath$default((AcpPaths)object, agentId, version, false, null, 8, null);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(versionedPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                URL uRL = versionedPath.toUri().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                CachedImageIcon icon3 = new CachedImageIcon(uRL, null, 2, null);
                ((Map)this.iconCache).put(agentId, icon3);
                return (Icon)icon3;
            }
        }
        $i$f$service = false;
        serviceClass$iv = AcpPaths.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Path legacyPath = AcpPaths.getIconPath$default((AcpPaths)object, agentId, false, null, 4, null);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(legacyPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            URL uRL = legacyPath.toUri().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            CachedImageIcon icon4 = new CachedImageIcon(uRL, null, 2, null);
            ((Map)this.iconCache).put(agentId, icon4);
            return (Icon)icon4;
        }
        Icon icon5 = AcpAgentIcons.AgentModel;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"AgentModel");
        return icon5;
    }

    private final String findVersionForIcon(AcpAgentId agentId) {
        ExternalAgent registryAgent;
        boolean $i$f$service = false;
        Class<AcpAgentInstallationState> serviceClass$iv = AcpAgentInstallationState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        String installedVersion = ((AcpAgentInstallationState)object).getInstalledVersion(agentId);
        if (installedVersion != null) {
            return installedVersion;
        }
        boolean $i$f$service2 = false;
        Class<AcpRegistryFetcher> serviceClass$iv2 = AcpRegistryFetcher.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        AcpExternalRegistry registry = ((AcpRegistryFetcher)object2).getRegistry();
        Object object3 = registry;
        if (object3 != null && (object3 = ((AcpExternalRegistry)object3).getAgents()) != null) {
            Object v3;
            block7: {
                Iterable iterable = (Iterable)object3;
                for (Object t : iterable) {
                    ExternalAgent it = (ExternalAgent)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)agentId)) continue;
                    v3 = t;
                    break block7;
                }
                v3 = null;
            }
            v4 = v3;
        } else {
            v4 = registryAgent = null;
        }
        if (registryAgent != null) {
            return registryAgent.getVersion();
        }
        return null;
    }

    @NotNull
    public final Icon getBadgedIcon(@NotNull Icon baseIcon) {
        Intrinsics.checkNotNullParameter((Object)baseIcon, (String)"baseIcon");
        Icon icon2 = this.badgedIconCache.computeIfAbsent(baseIcon, arg_0 -> AcpIconCacheManager.getBadgedIcon$lambda$1(arg_0 -> AcpIconCacheManager.getBadgedIcon$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"computeIfAbsent(...)");
        return icon2;
    }

    @NotNull
    public final Icon getBadgedIcon(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        return this.getBadgedIcon(this.getIcon(agentId));
    }

    @Nullable
    public final Object downloadAndCacheIcon(@NotNull AcpAgentId agentId, @NotNull String version, @Nullable String iconUrl, @NotNull Continuation<? super Boolean> $completion) {
        CharSequence charSequence = iconUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return Boxing.boxBoolean((boolean)false);
        }
        boolean $i$f$service = false;
        Class<AcpPaths> serviceClass$iv = AcpPaths.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Path lightPath = AcpPaths.getVersionedIconPath$default((AcpPaths)object, agentId, version, false, null, 8, null);
        boolean $i$f$service2 = false;
        Class<AcpPaths> serviceClass$iv2 = AcpPaths.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Path darkPath = AcpPaths.getVersionedIconPath$default((AcpPaths)object2, agentId, version, true, null, 8, null);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(lightPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(darkPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                AcpIconCacheManagerKt.access$getLogger$p().debug("Icon already cached for " + agentId + " v" + version);
                return Boxing.boxBoolean((boolean)true);
            }
        }
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(agentId, version, iconUrl, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AcpAgentId $agentId;
            final /* synthetic */ String $version;
            final /* synthetic */ String $iconUrl;
            final /* synthetic */ AcpIconCacheManager this$0;
            {
                this.$agentId = $agentId;
                this.$version = $version;
                this.$iconUrl = $iconUrl;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        void $this$withContext;
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScopeKt.ensureActive((CoroutineScope)$this$withContext);
                        try {
                            AcpIconCacheManagerKt.access$getLogger$p().info("Downloading icon for " + this.$agentId + " v" + this.$version + " from " + this.$iconUrl);
                            String string = HttpRequests.request((String)this.$iconUrl).userAgent("JetBrains-ACP-Agent-Manager/1.0").readString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                            String content2 = string;
                            String extension = StringsKt.endsWith((String)this.$iconUrl, (String)".svg", (boolean)true) ? "svg" : (StringsKt.endsWith((String)this.$iconUrl, (String)".png", (boolean)true) ? "png" : (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)content2)).toString(), (String)"<svg", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)content2)).toString(), (String)"<?xml", (boolean)false, (int)2, null) ? "svg" : "svg"));
                            boolean $i$f$service = false;
                            Class<AcpPaths> serviceClass$iv = AcpPaths.class;
                            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                            if (object == null) {
                                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                            }
                            Path iconDir = ((AcpPaths)object).getVersionedIconDir(this.$agentId, this.$version);
                            Files.createDirectories(iconDir, new FileAttribute[0]);
                            boolean $i$f$service2 = false;
                            Class<AcpPaths> serviceClass$iv2 = AcpPaths.class;
                            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
                            if (object2 == null) {
                                throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                            }
                            Path lightIconPath = ((AcpPaths)object2).getVersionedIconPath(this.$agentId, this.$version, false, extension);
                            boolean $i$f$service3 = false;
                            Class<AcpPaths> serviceClass$iv3 = AcpPaths.class;
                            Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv3);
                            if (object3 == null) {
                                throw new RuntimeException("Cannot find service " + serviceClass$iv3.getName() + " (classloader=" + serviceClass$iv3.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                            }
                            Path darkIconPath = ((AcpPaths)object3).getVersionedIconPath(this.$agentId, this.$version, true, extension);
                            if (Intrinsics.areEqual((Object)extension, (Object)"svg")) {
                                PathsKt.writeText$default((Path)lightIconPath, (CharSequence)StringsKt.replace$default((String)content2, (String)"currentColor", (String)"#6C707E", (boolean)false, (int)4, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
                                PathsKt.writeText$default((Path)darkIconPath, (CharSequence)StringsKt.replace$default((String)content2, (String)"currentColor", (String)"#CED0D6", (boolean)false, (int)4, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
                            } else {
                                PathsKt.writeText$default((Path)lightIconPath, (CharSequence)content2, null, (OpenOption[])new OpenOption[0], (int)2, null);
                                PathsKt.writeText$default((Path)darkIconPath, (CharSequence)content2, null, (OpenOption[])new OpenOption[0], (int)2, null);
                            }
                            AcpIconCacheManager.access$invalidateIconCache(this.this$0, this.$agentId);
                            AcpIconCacheManagerKt.access$getLogger$p().info("Cached icons for " + this.$agentId + " v" + this.$version + " at " + iconDir);
                            bl = true;
                        }
                        catch (Exception e) {
                            AcpIconCacheManagerKt.access$getLogger$p().warn("Failed to download icon for " + this.$agentId + " v" + this.$version + " from " + this.$iconUrl + ": " + e.getMessage());
                            bl = false;
                        }
                        return Boxing.boxBoolean((bl ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public final void downloadIconInBackground(@NotNull AcpAgentId agentId, @NotNull String version, @Nullable String iconUrl) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        CharSequence charSequence = iconUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, agentId, version, iconUrl, null){
            int label;
            final /* synthetic */ AcpIconCacheManager this$0;
            final /* synthetic */ AcpAgentId $agentId;
            final /* synthetic */ String $version;
            final /* synthetic */ String $iconUrl;
            {
                this.this$0 = $receiver;
                this.$agentId = $agentId;
                this.$version = $version;
                this.$iconUrl = $iconUrl;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.downloadAndCacheIcon(this.$agentId, this.$version, this.$iconUrl, (Continuation<? super Boolean>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void downloadAllIcons(@NotNull AcpExternalRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(registry, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AcpExternalRegistry $registry;
            final /* synthetic */ AcpIconCacheManager this$0;
            {
                this.$registry = $registry;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var21_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$filter$iv = this.$registry.getAgents();
                        $i$f$filter = false;
                        var6_7 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (ExternalAgent)element$iv$iv;
                            $i$a$-filter-AcpIconCacheManager$downloadAllIcons$1$agentsWithIcons$1 = false;
                            if (!(it.getIcon() != null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        agentsWithIcons = (List)destination$iv$iv;
                        AcpIconCacheManagerKt.access$getLogger$p().info("Downloading icons for " + agentsWithIcons.size() + " agents");
                        $this$filter$iv = CollectionsKt.chunked((Iterable)agentsWithIcons, (int)5);
                        var5_6 = this.this$0;
                        $i$f$forEach = 0;
                        var7_9 = $this$forEach$iv.iterator();
lbl24:
                        // 3 sources

                        while (var7_9.hasNext()) {
                            element$iv = var7_9.next();
                            chunk = (List)element$iv;
                            $i$a$-forEach-AcpIconCacheManager$downloadAllIcons$1$1 = 0;
                            $this$map$iv = chunk;
                            $i$f$map = false;
                            var13_18 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                var18_23 = (ExternalAgent)item$iv$iv;
                                var19_24 = destination$iv$iv;
                                $i$a$-map-AcpIconCacheManager$downloadAllIcons$1$1$1 = false;
                                var19_24.add(BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(var5_6, (ExternalAgent)agent, null){
                                    int label;
                                    final /* synthetic */ AcpIconCacheManager this$0;
                                    final /* synthetic */ ExternalAgent $agent;
                                    {
                                        this.this$0 = $receiver;
                                        this.$agent = $agent;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = this.this$0.downloadAndCacheIcon(this.$agent.getId(), this.$agent.getVersion(), this.$agent.getIcon(), (Continuation<? super Boolean>)((Continuation)this));
                                                Object object3 = object2;
                                                if (object2 != object) return object3;
                                                return object;
                                            }
                                            case 1: {
                                                Object object3;
                                                try {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    object3 = $result;
                                                    return object3;
                                                }
                                                catch (Exception e) {
                                                    AcpIconCacheManagerKt.access$getLogger$p().debug("Failed to download icon for " + this.$agent.getId() + ": " + e.getMessage());
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null));
                            }
                            this.L$0 = $this$launch;
                            this.L$1 = agentsWithIcons;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                            this.L$3 = var5_6;
                            this.L$4 = var7_9;
                            this.L$5 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                            this.L$6 = SpillingKt.nullOutSpilledVariable((Object)chunk);
                            this.I$0 = $i$f$forEach;
                            this.I$1 = $i$a$-forEach-AcpIconCacheManager$downloadAllIcons$1$1;
                            this.label = 1;
                            v0 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)this);
                            if (v0 != var21_3) continue;
                            return var21_3;
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-forEach-AcpIconCacheManager$downloadAllIcons$1$1 = this.I$1;
                        $i$f$forEach = this.I$0;
                        chunk = (List)this.L$6;
                        element$iv = this.L$5;
                        var7_9 = (Iterator<T>)this.L$4;
                        var5_6 = (AcpIconCacheManager)this.L$3;
                        $this$forEach$iv = (Iterable)this.L$2;
                        agentsWithIcons = (List)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl24
                    }
                }
                AcpIconCacheManagerKt.access$getLogger$p().info("Icon download complete for " + agentsWithIcons.size() + " agents");
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void invalidateIconCache(AcpAgentId id) {
        Icon oldIcon = this.iconCache.remove(id);
        if (oldIcon != null) {
            this.badgedIconCache.remove(oldIcon);
        }
    }

    @Nullable
    public final Object deleteIcon(@NotNull AcpAgentId agentId, @NotNull Continuation<? super Unit> $completion) {
        this.invalidateIconCache(agentId);
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(agentId, null){
            int label;
            final /* synthetic */ AcpAgentId $agentId;
            {
                this.$agentId = $agentId;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object[] objectArray = new Boolean[]{Boxing.boxBoolean((boolean)false), Boxing.boxBoolean((boolean)true)};
                        Iterator<E> iterator = CollectionsKt.listOf((Object[])objectArray).iterator();
                        while (iterator.hasNext()) {
                            boolean isDark = (Boolean)iterator.next();
                            Object[] objectArray2 = new String[]{"svg", "png"};
                            for (String extension : CollectionsKt.listOf((Object[])objectArray2)) {
                                boolean $i$f$service = false;
                                Class<AcpPaths> serviceClass$iv = AcpPaths.class;
                                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                                if (object == null) {
                                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                                }
                                Path iconPath = ((AcpPaths)object).getIconPath(this.$agentId, isDark, extension);
                                try {
                                    Files.deleteIfExists(iconPath);
                                }
                                catch (Exception e) {
                                    AcpIconCacheManagerKt.access$getLogger$p().debug("Failed to delete legacy icon " + iconPath + ": " + e.getMessage());
                                }
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Icon getBadgedIcon$lambda$0(AcpIconCacheManager this$0, Icon it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Color color = JBUI.CurrentTheme.IconBadge.INFORMATION;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"INFORMATION");
        return (Icon)new BadgeIcon(it, (Paint)color, (BadgeShapeProvider)this$0.badgeDotProvider);
    }

    private static final Icon getBadgedIcon$lambda$1(Function1 $tmp0, Object p0) {
        return (Icon)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$invalidateIconCache(AcpIconCacheManager $this, AcpAgentId id) {
        $this.invalidateIconCache(id);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpIconCacheManager$Companion;", "", "<init>", "()V", "LIGHT_COLOR", "", "DARK_COLOR", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

