/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ml.llm.agents.acp.AcpBundle;
import com.intellij.ml.llm.agents.acp.registry.AcpIconCacheManager;
import com.intellij.ml.llm.agents.acp.settings.AgentListItem;
import com.intellij.ml.llm.agents.acp.settings.SelectionType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u000fJ\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000f2\b\b\u0002\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/ml/llm/agents/acp/settings/AgentCard;", "Ljavax/swing/JPanel;", "item", "Lcom/intellij/ml/llm/agents/acp/settings/AgentListItem;", "onInstall", "Lkotlin/Function1;", "", "onUninstall", "onUpdate", "onOpenUrl", "<init>", "(Lcom/intellij/ml/llm/agents/acp/settings/AgentListItem;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getItem", "()Lcom/intellij/ml/llm/agents/acp/settings/AgentListItem;", "selectionType", "Lcom/intellij/ml/llm/agents/acp/settings/SelectionType;", "nameLabel", "Lcom/intellij/ui/components/JBLabel;", "versionLabel", "descriptionLabel", "authorsLabel", "actionButton", "Ljavax/swing/JButton;", "createLinkButton", "text", "", "action", "Lkotlin/Function0;", "getSelection", "setSelection", "type", "scrollAndFocus", "", "updateColors", "createBadge", "Ljavax/swing/JLabel;", "getPreferredSize", "Ljava/awt/Dimension;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "Companion", "AccessibleAgentCard", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAgentCard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentCard.kt\ncom/intellij/ml/llm/agents/acp/settings/AgentCard\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n42#2,3:351\n42#2,3:354\n1#3:357\n*S KotlinDebug\n*F\n+ 1 AgentCard.kt\ncom/intellij/ml/llm/agents/acp/settings/AgentCard\n*L\n71#1:351,3\n74#1:354,3\n*E\n"})
public final class AgentCard
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AgentListItem item;
    @NotNull
    private final Function1<AgentListItem, Unit> onInstall;
    @NotNull
    private final Function1<AgentListItem, Unit> onUninstall;
    @NotNull
    private final Function1<AgentListItem, Unit> onUpdate;
    @NotNull
    private final Function1<AgentListItem, Unit> onOpenUrl;
    @NotNull
    private SelectionType selectionType;
    @NotNull
    private final JBLabel nameLabel;
    @Nullable
    private final JBLabel versionLabel;
    @Nullable
    private final JBLabel descriptionLabel;
    @Nullable
    private final JBLabel authorsLabel;
    @Nullable
    private final JButton actionButton;
    private static final int ICON_SIZE = 32;
    @NotNull
    private static final JBColor GRAY_COLOR;

    public AgentCard(@NotNull AgentListItem item, @NotNull Function1<? super AgentListItem, Unit> onInstall, @NotNull Function1<? super AgentListItem, Unit> onUninstall, @NotNull Function1<? super AgentListItem, Unit> onUpdate, @NotNull Function1<? super AgentListItem, Unit> onOpenUrl) {
        CharSequence $this$_init__u24lambda_u241;
        CharSequence charSequence;
        Object row22;
        String versionText;
        Object[] objectArray;
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(onInstall, (String)"onInstall");
        Intrinsics.checkNotNullParameter(onUninstall, (String)"onUninstall");
        Intrinsics.checkNotNullParameter(onUpdate, (String)"onUpdate");
        Intrinsics.checkNotNullParameter(onOpenUrl, (String)"onOpenUrl");
        super(new BorderLayout(JBUI.scale((int)12), 0));
        this.item = item;
        this.onInstall = onInstall;
        this.onUninstall = onUninstall;
        this.onUpdate = onUpdate;
        this.onOpenUrl = onOpenUrl;
        this.selectionType = SelectionType.NONE;
        this.setFocusable(true);
        this.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, JBUI.scale((int)80)));
        this.setOpaque(true);
        boolean $i$f$service = false;
        Class<AcpIconCacheManager> serviceClass$iv = AcpIconCacheManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Icon rawIcon = ((AcpIconCacheManager)object).getIcon(this.item.getId());
        Icon scaledIcon = IconUtil.scale((Icon)rawIcon, null, (float)((float)JBUI.scale((int)32) / (float)rawIcon.getIconWidth()));
        if (this.item.getHasUpdate()) {
            boolean $i$f$service2 = false;
            Class<AcpIconCacheManager> serviceClass$iv2 = AcpIconCacheManager.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            icon2 = ((AcpIconCacheManager)object2).getBadgedIcon(scaledIcon);
        } else {
            icon2 = scaledIcon;
        }
        Icon icon3 = icon2;
        JLabel iconLabel2 = new JLabel(icon3);
        iconLabel2.setVerticalAlignment(1);
        this.add((Component)iconLabel2, "West");
        JPanel infoPanel2 = new JPanel(){
            {
                this.setLayout(new BoxLayout(this, 1));
                this.setOpaque(false);
            }

            public Dimension getMinimumSize() {
                return new Dimension(0, super.getMinimumSize().height);
            }
        };
        BorderLayout borderLayout = new BorderLayout();
        JPanel row12 = new JPanel(borderLayout){
            {
                this.setOpaque(false);
                this.setAlignmentX(0.0f);
            }

            public Dimension getMinimumSize() {
                return new Dimension(0, super.getMinimumSize().height);
            }
        };
        Object[] $this$_init__u24lambda_u240 = objectArray = new JPanel(new FlowLayout(0, 0, 0));
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setOpaque(false);
        Object[] row1Left = objectArray;
        row12.add((Component)row1Left, "Center");
        this.nameLabel = new JBLabel(this.item.getName());
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
        row1Left.add((Component)this.nameLabel);
        if (this.item.getHasUpdate() && this.item.getInstalledVersion() != null && this.item.getRegistryVersion() != null) {
            $this$_init__u24lambda_u240 = new Object[2];
            Object[] bl2 = new Object[]{this.item.getInstalledVersion()};
            $this$_init__u24lambda_u240[0] = AcpBundle.INSTANCE.message("settings.acp.agents.version", bl2);
            bl2 = new Object[]{this.item.getRegistryVersion()};
            $this$_init__u24lambda_u240[1] = AcpBundle.INSTANCE.message("settings.acp.agents.version", bl2);
            v3 = AcpBundle.INSTANCE.message("settings.acp.agents.version.update", $this$_init__u24lambda_u240);
        } else if (this.item.getInstalledVersion() != null) {
            $this$_init__u24lambda_u240 = new Object[]{this.item.getInstalledVersion()};
            v3 = AcpBundle.INSTANCE.message("settings.acp.agents.version", $this$_init__u24lambda_u240);
        } else if (this.item.getRegistryVersion() != null) {
            $this$_init__u24lambda_u240 = new Object[]{this.item.getRegistryVersion()};
            v3 = AcpBundle.INSTANCE.message("settings.acp.agents.version", $this$_init__u24lambda_u240);
        } else {
            v3 = versionText = null;
        }
        if (versionText != null) {
            row1Left.add(Box.createHorizontalStrut(JBUI.scale((int)4)));
            this.versionLabel = new JBLabel(versionText);
            this.versionLabel.setForeground((Color)GRAY_COLOR);
            this.versionLabel.setFont(this.versionLabel.getFont().deriveFont(this.versionLabel.getFont().getSize2D() - 1.0f));
            row1Left.add((Component)this.versionLabel);
        } else {
            this.versionLabel = null;
        }
        if (this.item.isLocal()) {
            row1Left.add(Box.createHorizontalStrut(JBUI.scale((int)4)));
            row1Left.add(this.createBadge(AcpBundle.INSTANCE.message("settings.acp.agents.local.badge", new Object[0])));
        }
        infoPanel2.add(row12);
        infoPanel2.add(Box.createVerticalStrut(JBUI.scale((int)2)));
        $this$_init__u24lambda_u240 = this.item.getDescription();
        if (!($this$_init__u24lambda_u240 == null || StringsKt.isBlank((CharSequence)$this$_init__u24lambda_u240))) {
            BorderLayout bl2 = new BorderLayout();
            row22 = new JPanel(bl2){
                {
                    this.setOpaque(false);
                    this.setAlignmentX(0.0f);
                }

                public Dimension getMinimumSize() {
                    return new Dimension(0, super.getMinimumSize().height);
                }
            };
            String desc = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)this.item.getDescription(), (String)"\n", (String)" ", (boolean)false, (int)4, null))).toString();
            this.descriptionLabel = new JBLabel(desc);
            this.descriptionLabel.setForeground((Color)GRAY_COLOR);
            this.descriptionLabel.setFont(this.descriptionLabel.getFont().deriveFont(this.descriptionLabel.getFont().getSize2D() - 1.0f));
            ((Container)row22).add((Component)this.descriptionLabel, "Center");
            infoPanel2.add((Component)row22);
            infoPanel2.add(Box.createVerticalStrut(JBUI.scale((int)2)));
        } else {
            this.descriptionLabel = null;
        }
        if (!((Collection)this.item.getAuthors()).isEmpty() || !((row22 = (CharSequence)this.item.getRepository()) == null || StringsKt.isBlank((CharSequence)row22))) {
            JPanel row3 = new JPanel(new FlowLayout(0, 0, 0));
            row3.setOpaque(false);
            row3.setAlignmentX(0.0f);
            if (!((Collection)this.item.getAuthors()).isEmpty()) {
                charSequence = new StringBuilder();
                $this$_init__u24lambda_u241 = charSequence;
                boolean bl3 = false;
                $this$_init__u24lambda_u241.append((String)CollectionsKt.first(this.item.getAuthors()));
                if (this.item.getAuthors().size() > 1) {
                    $this$_init__u24lambda_u241.append(" +" + (this.item.getAuthors().size() - 1));
                }
                String authorsText = ((StringBuilder)charSequence).toString();
                this.authorsLabel = new JBLabel(authorsText);
                this.authorsLabel.setForeground((Color)GRAY_COLOR);
                this.authorsLabel.setFont(this.authorsLabel.getFont().deriveFont(this.authorsLabel.getFont().getSize2D() - 1.0f));
                row3.add((Component)this.authorsLabel);
            } else {
                this.authorsLabel = null;
            }
            CharSequence authorsText = this.item.getRepository();
            if (!(authorsText == null || StringsKt.isBlank((CharSequence)authorsText))) {
                row3.add(Box.createHorizontalStrut(JBUI.scale((int)4)));
                JBLabel link2 = new JBLabel(AllIcons.Ide.External_link_arrow);
                link2.setCursor(Cursor.getPredefinedCursor(12));
                link2.setToolTipText(AcpBundle.INSTANCE.message("settings.acp.agents.open.repository", new Object[0]));
                link2.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        onOpenUrl.invoke((Object)this.getItem());
                    }
                });
                row3.add((Component)link2);
            }
            infoPanel2.add(row3);
        } else {
            this.authorsLabel = null;
        }
        this.add((Component)infoPanel2, "Center");
        if (!this.item.isLocal()) {
            FlowLayout link2 = new FlowLayout(2, JBUI.scale((int)4), 0);
            JPanel buttonPanel2 = new JPanel(link2){
                {
                    this.setOpaque(false);
                }

                public Dimension getMinimumSize() {
                    Dimension dimension = this.getPreferredSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                    return dimension;
                }
            };
            if (this.item.getHasUpdate()) {
                charSequence = AcpBundle.INSTANCE.message("settings.acp.agents.update", new Object[0]);
                AbstractAction updateAction2 = new AbstractAction(this, (String)charSequence){
                    final /* synthetic */ AgentCard this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(ActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        AgentCard.access$getOnUpdate$p(this.this$0).invoke((Object)this.this$0.getItem());
                    }
                };
                $this$_init__u24lambda_u241 = AcpBundle.INSTANCE.message("settings.acp.agents.uninstall", new Object[0]);
                AbstractAction uninstallAction2 = new AbstractAction(this, (String)$this$_init__u24lambda_u241){
                    final /* synthetic */ AgentCard this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(ActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        AgentCard.access$getOnUninstall$p(this.this$0).invoke((Object)this.this$0.getItem());
                    }
                };
                Action[] bl3 = new Action[]{uninstallAction2};
                Action[] $this$_init__u24lambda_u242 = bl3 = new JBOptionButton((Action)updateAction2, bl3);
                boolean bl4 = false;
                $this$_init__u24lambda_u242.putClientProperty((Object)DarculaButtonUI.DEFAULT_STYLE_KEY, (Object)true);
                Action[] optionButton = bl3;
                buttonPanel2.add((Component)optionButton);
                this.actionButton = (JButton)optionButton;
            } else if (this.item.isInstalled()) {
                JButton uninstallButton = this.createLinkButton(AcpBundle.INSTANCE.message("settings.acp.agents.uninstall", new Object[0]), (Function0<Unit>)((Function0)() -> AgentCard._init_$lambda$3(this)));
                buttonPanel2.add(uninstallButton);
                this.actionButton = uninstallButton;
            } else {
                CharSequence $this$_init__u24lambda_u244 = charSequence = new InstallButton(AcpBundle.INSTANCE.message("settings.acp.agents.install", new Object[0]), false);
                boolean bl5 = false;
                $this$_init__u24lambda_u244.addActionListener(arg_0 -> AgentCard.lambda$4$0(this, arg_0));
                CharSequence installButton = charSequence;
                buttonPanel2.add((Component)((Object)installButton));
                this.actionButton = (JButton)((Object)installButton);
            }
            this.add((Component)buttonPanel2, "East");
        } else {
            this.actionButton = null;
        }
        this.updateColors();
        this.putClientProperty("AccessibleName", this.item.getName());
    }

    @NotNull
    public final AgentListItem getItem() {
        return this.item;
    }

    private final JButton createLinkButton(String text2, Function0<Unit> action2) {
        JButton jButton;
        JButton $this$createLinkButton_u24lambda_u240 = jButton = new JButton(text2);
        boolean bl = false;
        $this$createLinkButton_u24lambda_u240.putClientProperty("JButton.buttonType", "borderless");
        $this$createLinkButton_u24lambda_u240.setOpaque(false);
        $this$createLinkButton_u24lambda_u240.setForeground(JBUI.CurrentTheme.Link.Foreground.ENABLED);
        $this$createLinkButton_u24lambda_u240.addActionListener(arg_0 -> AgentCard.createLinkButton$lambda$0$0(action2, arg_0));
        return jButton;
    }

    @NotNull
    public final SelectionType getSelection() {
        return this.selectionType;
    }

    public final void setSelection(@NotNull SelectionType type2, boolean scrollAndFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.selectionType = type2;
        if (scrollAndFocus && type2 == SelectionType.SELECTION) {
            JComponent parent;
            Container container2 = this.getParent();
            JComponent jComponent = parent = container2 instanceof JComponent ? (JComponent)container2 : null;
            if (parent != null) {
                if (!parent.getVisibleRect().contains(this.getBounds())) {
                    this.scrollRectToVisible(this.getBounds());
                }
                this.requestFocusInWindow();
            }
        }
        this.updateColors();
        this.repaint();
    }

    public static /* synthetic */ void setSelection$default(AgentCard agentCard, SelectionType selectionType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        agentCard.setSelection(selectionType, bl);
    }

    private final void updateColors() {
        block2: {
            this.setBackground(UIUtil.getListBackground());
            this.nameLabel.setForeground(null);
            JBLabel jBLabel = this.versionLabel;
            if (jBLabel != null) {
                jBLabel.setForeground((Color)GRAY_COLOR);
            }
            JBLabel jBLabel2 = this.descriptionLabel;
            if (jBLabel2 != null) {
                jBLabel2.setForeground((Color)GRAY_COLOR);
            }
            JBLabel jBLabel3 = this.authorsLabel;
            if (jBLabel3 == null) break block2;
            jBLabel3.setForeground((Color)GRAY_COLOR);
        }
    }

    private final JLabel createBadge(String text2) {
        JBLabel jBLabel;
        JBLabel $this$createBadge_u24lambda_u240 = jBLabel = new JBLabel(text2);
        boolean bl = false;
        $this$createBadge_u24lambda_u240.setForeground(UIUtil.getContextHelpForeground());
        $this$createBadge_u24lambda_u240.setFont($this$createBadge_u24lambda_u240.getFont().deriveFont($this$createBadge_u24lambda_u240.getFont().getSize2D() - 2.0f));
        $this$createBadge_u24lambda_u240.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(JBUI.CurrentTheme.ActionButton.hoverBorder(), 1, true), (Border)JBUI.Borders.empty((int)1, (int)6)));
        return (JLabel)jBLabel;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        return new Dimension(0, ps.height);
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAgentCard();
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    private static final Unit _init_$lambda$3(AgentCard this$0) {
        this$0.onUninstall.invoke((Object)this$0.item);
        return Unit.INSTANCE;
    }

    private static final void lambda$4$0(AgentCard this$0, ActionEvent it) {
        this$0.onInstall.invoke((Object)this$0.item);
    }

    private static final void createLinkButton$lambda$0$0(Function0 $action, ActionEvent it) {
        $action.invoke();
    }

    public static final /* synthetic */ Function1 access$getOnUpdate$p(AgentCard $this) {
        return $this.onUpdate;
    }

    public static final /* synthetic */ Function1 access$getOnUninstall$p(AgentCard $this) {
        return $this.onUninstall;
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"Label.infoForeground", (Color)((Color)new JBColor(0x787878, 0x999999)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        GRAY_COLOR = jBColor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/agents/acp/settings/AgentCard$AccessibleAgentCard;", "Ljavax/swing/JPanel$AccessibleJPanel;", "Ljavax/swing/JPanel;", "<init>", "(Lcom/intellij/ml/llm/agents/acp/settings/AgentCard;)V", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleName", "", "getAccessibleDescription", "intellij.ml.llm.agents.acp"})
    @SourceDebugExtension(value={"SMAP\nAgentCard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentCard.kt\ncom/intellij/ml/llm/agents/acp/settings/AgentCard$AccessibleAgentCard\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
    private final class AccessibleAgentCard
    extends JPanel.AccessibleJPanel {
        public AccessibleAgentCard() {
            super(AgentCard.this);
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.LIST_ITEM;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"LIST_ITEM");
            return accessibleRole;
        }

        @Override
        @NotNull
        public String getAccessibleName() {
            return AgentCard.this.getItem().getName();
        }

        @Override
        @NotNull
        public String getAccessibleDescription() {
            StringBuilder stringBuilder;
            block3: {
                String it;
                AgentCard agentCard = AgentCard.this;
                StringBuilder $this$getAccessibleDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$getAccessibleDescription_u24lambda_u240.append(agentCard.getItem().getName());
                String string = agentCard.getItem().getInstalledVersion();
                if (string != null) {
                    it = string;
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{it};
                    $this$getAccessibleDescription_u24lambda_u240.append(AcpBundle.INSTANCE.message("settings.acp.agents.accessibility.version", objectArray));
                }
                if (agentCard.getItem().isLocal()) {
                    $this$getAccessibleDescription_u24lambda_u240.append(AcpBundle.INSTANCE.message("settings.acp.agents.accessibility.local", new Object[0]));
                }
                StringBuilder stringBuilder2 = agentCard.getItem().isInstalled() ? $this$getAccessibleDescription_u24lambda_u240.append(AcpBundle.INSTANCE.message("settings.acp.agents.accessibility.installed", new Object[0])) : $this$getAccessibleDescription_u24lambda_u240.append(AcpBundle.INSTANCE.message("settings.acp.agents.accessibility.not.installed", new Object[0]));
                if (agentCard.getItem().getHasUpdate() && agentCard.getItem().getRegistryVersion() != null) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = new Object[]{agentCard.getItem().getRegistryVersion()};
                    objectArray[0] = AcpBundle.INSTANCE.message("settings.acp.agents.version", objectArray2);
                    $this$getAccessibleDescription_u24lambda_u240.append(AcpBundle.INSTANCE.message("settings.acp.agents.accessibility.update.available", objectArray));
                }
                String string2 = agentCard.getItem().getDescription();
                if (string2 == null) break block3;
                it = string2;
                boolean bl3 = false;
                $this$getAccessibleDescription_u24lambda_u240.append(". " + it);
            }
            return stringBuilder.toString();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/acp/settings/AgentCard$Companion;", "", "<init>", "()V", "ICON_SIZE", "", "GRAY_COLOR", "Lcom/intellij/ui/JBColor;", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

