/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.settings;

import com.intellij.ml.llm.agents.acp.settings.AgentCard;
import com.intellij.ml.llm.agents.acp.settings.AgentEventHandler;
import com.intellij.ml.llm.agents.acp.settings.SelectionType;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000O\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0003\r\u0010\u0013\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0005J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aJ\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000b2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00010'H\u0002R\u001c\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/intellij/ml/llm/agents/acp/settings/AgentEventHandler;", "", "onSelectionChanged", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/agents/acp/settings/AgentCard;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "cards", "", "selectedIndex", "", "mouseHandler", "com/intellij/ml/llm/agents/acp/settings/AgentEventHandler$mouseHandler$1", "Lcom/intellij/ml/llm/agents/acp/settings/AgentEventHandler$mouseHandler$1;", "keyHandler", "com/intellij/ml/llm/agents/acp/settings/AgentEventHandler$keyHandler$1", "Lcom/intellij/ml/llm/agents/acp/settings/AgentEventHandler$keyHandler$1;", "focusHandler", "com/intellij/ml/llm/agents/acp/settings/AgentEventHandler$focusHandler$1", "Lcom/intellij/ml/llm/agents/acp/settings/AgentEventHandler$focusHandler$1;", "addCard", "card", "removeCard", "clear", "getCards", "", "getSelectedCard", "selectCard", "scrollAndFocus", "", "selectIndex", "index", "initialSelection", "moveSelection", "delta", "registerListeners", "registerChildListeners", "component", "Ljava/awt/Component;", "findCard", "intellij.ml.llm.agents.acp"})
public final class AgentEventHandler {
    @NotNull
    private final Function1<AgentCard, Unit> onSelectionChanged;
    @NotNull
    private final List<AgentCard> cards;
    private int selectedIndex;
    @NotNull
    private final mouseHandler.1 mouseHandler;
    @NotNull
    private final keyHandler.1 keyHandler;
    @NotNull
    private final focusHandler.1 focusHandler;

    public AgentEventHandler(@NotNull Function1<? super AgentCard, Unit> onSelectionChanged) {
        Intrinsics.checkNotNullParameter(onSelectionChanged, (String)"onSelectionChanged");
        this.onSelectionChanged = onSelectionChanged;
        this.cards = new ArrayList();
        this.selectedIndex = -1;
        this.mouseHandler = new MouseAdapter(this){
            final /* synthetic */ AgentEventHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent event2) {
                AgentCard card2;
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (SwingUtilities.isLeftMouseButton(event2) && (card2 = AgentEventHandler.access$findCard(this.this$0, event2.getComponent())) != null) {
                    AgentEventHandler.selectCard$default(this.this$0, card2, false, 2, null);
                }
            }
        };
        this.keyHandler = new KeyAdapter(this){
            final /* synthetic */ AgentEventHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                switch (event2.getKeyCode()) {
                    case 38: {
                        event2.consume();
                        AgentEventHandler.access$moveSelection(this.this$0, -1);
                        break;
                    }
                    case 40: {
                        event2.consume();
                        AgentEventHandler.access$moveSelection(this.this$0, 1);
                        break;
                    }
                    case 36: {
                        event2.consume();
                        AgentEventHandler.selectIndex$default(this.this$0, 0, false, 2, null);
                        break;
                    }
                    case 35: {
                        event2.consume();
                        AgentEventHandler.selectIndex$default(this.this$0, CollectionsKt.getLastIndex((List)AgentEventHandler.access$getCards$p(this.this$0)), false, 2, null);
                        break;
                    }
                    case 33: {
                        event2.consume();
                        AgentEventHandler.access$moveSelection(this.this$0, -5);
                        break;
                    }
                    case 34: {
                        event2.consume();
                        AgentEventHandler.access$moveSelection(this.this$0, 5);
                        break;
                    }
                    case 10: 
                    case 32: {
                        Component focusOwner = event2.getComponent();
                        if (!(focusOwner instanceof AgentCard)) break;
                    }
                }
            }
        };
        this.focusHandler = new FocusAdapter(this){
            final /* synthetic */ AgentEventHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(FocusEvent event2) {
                int index;
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                AgentCard card2 = AgentEventHandler.access$findCard(this.this$0, event2.getComponent());
                if (card2 != null && (index = AgentEventHandler.access$getCards$p(this.this$0).indexOf(card2)) != AgentEventHandler.access$getSelectedIndex$p(this.this$0)) {
                    this.this$0.selectCard(card2, false);
                }
            }
        };
    }

    public /* synthetic */ AgentEventHandler(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = AgentEventHandler::_init_$lambda$0;
        }
        this((Function1<? super AgentCard, Unit>)function1);
    }

    public final void addCard(@NotNull AgentCard card2) {
        Intrinsics.checkNotNullParameter((Object)card2, (String)"card");
        this.cards.add(card2);
        this.registerListeners(card2);
    }

    public final void removeCard(@NotNull AgentCard card2) {
        Intrinsics.checkNotNullParameter((Object)card2, (String)"card");
        this.cards.remove(card2);
    }

    public final void clear() {
        this.cards.clear();
        this.selectedIndex = -1;
    }

    @NotNull
    public final List<AgentCard> getCards() {
        return CollectionsKt.toList((Iterable)this.cards);
    }

    @Nullable
    public final AgentCard getSelectedCard() {
        return this.selectedIndex >= 0 && this.selectedIndex < this.cards.size() ? this.cards.get(this.selectedIndex) : null;
    }

    public final void selectCard(@NotNull AgentCard card2, boolean scrollAndFocus) {
        Intrinsics.checkNotNullParameter((Object)card2, (String)"card");
        int index = this.cards.indexOf(card2);
        if (index >= 0) {
            this.selectIndex(index, scrollAndFocus);
        }
    }

    public static /* synthetic */ void selectCard$default(AgentEventHandler agentEventHandler, AgentCard agentCard, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        agentEventHandler.selectCard(agentCard, bl);
    }

    public final void selectIndex(int index, boolean scrollAndFocus) {
        if (this.cards.isEmpty()) {
            return;
        }
        int newIndex = RangesKt.coerceIn((int)index, (int)0, (int)CollectionsKt.getLastIndex(this.cards));
        if (this.selectedIndex >= 0 && this.selectedIndex < this.cards.size() && this.selectedIndex != newIndex) {
            this.cards.get(this.selectedIndex).setSelection(SelectionType.NONE, false);
        }
        this.selectedIndex = newIndex;
        AgentCard card2 = this.cards.get(newIndex);
        card2.setSelection(SelectionType.SELECTION, scrollAndFocus);
        if (scrollAndFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> AgentEventHandler.selectIndex$lambda$0(card2));
        }
        this.onSelectionChanged.invoke((Object)card2);
    }

    public static /* synthetic */ void selectIndex$default(AgentEventHandler agentEventHandler, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        agentEventHandler.selectIndex(n, bl);
    }

    public final void initialSelection(boolean scrollAndFocus) {
        if (!((Collection)this.cards).isEmpty() && this.selectedIndex < 0) {
            this.selectIndex(0, scrollAndFocus);
        }
    }

    public static /* synthetic */ void initialSelection$default(AgentEventHandler agentEventHandler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        agentEventHandler.initialSelection(bl);
    }

    private final void moveSelection(int delta) {
        if (this.cards.isEmpty()) {
            return;
        }
        int newIndex = this.selectedIndex < 0 ? (delta > 0 ? 0 : CollectionsKt.getLastIndex(this.cards)) : RangesKt.coerceIn((int)(this.selectedIndex + delta), (int)0, (int)CollectionsKt.getLastIndex(this.cards));
        AgentEventHandler.selectIndex$default(this, newIndex, false, 2, null);
    }

    private final void registerListeners(AgentCard card2) {
        card2.addMouseListener(this.mouseHandler);
        card2.addKeyListener(this.keyHandler);
        card2.addFocusListener(this.focusHandler);
        this.registerChildListeners(card2);
    }

    private final void registerChildListeners(Component component2) {
        Component[] componentArray = component2 instanceof Container ? (Component[])component2 : null;
        if (componentArray == null || (componentArray = componentArray.getComponents()) == null) {
            componentArray = new Component[]{};
        }
        for (Component child : componentArray) {
            child.addMouseListener(this.mouseHandler);
            Intrinsics.checkNotNull((Object)child);
            this.registerChildListeners(child);
        }
    }

    private final AgentCard findCard(Component component2) {
        for (Component current = component2; current != null; current = (Component)current.getParent()) {
            if (!(current instanceof AgentCard)) continue;
            return (AgentCard)current;
        }
        return null;
    }

    private static final Unit _init_$lambda$0(AgentCard it) {
        return Unit.INSTANCE;
    }

    private static final void selectIndex$lambda$0(AgentCard $card) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)$card, true);
    }

    public AgentEventHandler() {
        this(null, 1, null);
    }

    public static final /* synthetic */ AgentCard access$findCard(AgentEventHandler $this, Component component2) {
        return $this.findCard(component2);
    }

    public static final /* synthetic */ void access$moveSelection(AgentEventHandler $this, int delta) {
        $this.moveSelection(delta);
    }

    public static final /* synthetic */ List access$getCards$p(AgentEventHandler $this) {
        return $this.cards;
    }

    public static final /* synthetic */ int access$getSelectedIndex$p(AgentEventHandler $this) {
        return $this.selectedIndex;
    }
}

