/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.settings;

import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.ml.llm.agents.acp.settings.InstallationChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\"\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\"\u0010\u0010\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\"\u0010\u0012\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/agents/acp/settings/AgentInstallationChangeTracker;", "", "<init>", "()V", "initiallyInstalledIds", "", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "initiallyPendingUpdateIds", "resetInitialState", "", "installedIds", "pendingUpdateIds", "isModified", "", "currentlyInstalledIds", "currentlyPendingUpdateIds", "computeChanges", "Lcom/intellij/ml/llm/agents/acp/settings/InstallationChanges;", "markChangesApplied", "getInitiallyInstalledIds", "getInitiallyPendingUpdateIds", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAgentInstallationChangeTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentInstallationChangeTracker.kt\ncom/intellij/ml/llm/agents/acp/settings/AgentInstallationChangeTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n774#2:114\n865#2,2:115\n*S KotlinDebug\n*F\n+ 1 AgentInstallationChangeTracker.kt\ncom/intellij/ml/llm/agents/acp/settings/AgentInstallationChangeTracker\n*L\n57#1:114\n57#1:115,2\n*E\n"})
public final class AgentInstallationChangeTracker {
    @NotNull
    private Set<? extends AcpAgentId> initiallyInstalledIds = SetsKt.emptySet();
    @NotNull
    private Set<? extends AcpAgentId> initiallyPendingUpdateIds = SetsKt.emptySet();

    public final void resetInitialState(@NotNull Set<? extends AcpAgentId> installedIds, @NotNull Set<? extends AcpAgentId> pendingUpdateIds) {
        Intrinsics.checkNotNullParameter(installedIds, (String)"installedIds");
        Intrinsics.checkNotNullParameter(pendingUpdateIds, (String)"pendingUpdateIds");
        this.initiallyInstalledIds = installedIds;
        this.initiallyPendingUpdateIds = pendingUpdateIds;
    }

    public final boolean isModified(@NotNull Set<? extends AcpAgentId> currentlyInstalledIds, @NotNull Set<? extends AcpAgentId> currentlyPendingUpdateIds) {
        Intrinsics.checkNotNullParameter(currentlyInstalledIds, (String)"currentlyInstalledIds");
        Intrinsics.checkNotNullParameter(currentlyPendingUpdateIds, (String)"currentlyPendingUpdateIds");
        boolean installsChanged = !Intrinsics.areEqual(currentlyInstalledIds, this.initiallyInstalledIds);
        boolean updatesAccepted = !Intrinsics.areEqual(currentlyPendingUpdateIds, this.initiallyPendingUpdateIds);
        return installsChanged || updatesAccepted;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final InstallationChanges computeChanges(@NotNull Set<? extends AcpAgentId> currentlyInstalledIds, @NotNull Set<? extends AcpAgentId> currentlyPendingUpdateIds) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(currentlyInstalledIds, (String)"currentlyInstalledIds");
        Intrinsics.checkNotNullParameter(currentlyPendingUpdateIds, (String)"currentlyPendingUpdateIds");
        Iterable iterable = SetsKt.minus(this.initiallyPendingUpdateIds, (Iterable)currentlyPendingUpdateIds);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AcpAgentId it = (AcpAgentId)element$iv$iv;
            boolean bl = false;
            if (!currentlyInstalledIds.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set toUpdate = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set toInstall = SetsKt.minus((Set)SetsKt.minus(currentlyInstalledIds, (Iterable)this.initiallyInstalledIds), (Iterable)toUpdate);
        Set toUninstall = SetsKt.minus(this.initiallyInstalledIds, (Iterable)currentlyInstalledIds);
        return new InstallationChanges(toInstall, toUninstall, toUpdate);
    }

    public final void markChangesApplied(@NotNull Set<? extends AcpAgentId> currentlyInstalledIds, @NotNull Set<? extends AcpAgentId> currentlyPendingUpdateIds) {
        Intrinsics.checkNotNullParameter(currentlyInstalledIds, (String)"currentlyInstalledIds");
        Intrinsics.checkNotNullParameter(currentlyPendingUpdateIds, (String)"currentlyPendingUpdateIds");
        this.initiallyInstalledIds = currentlyInstalledIds;
        this.initiallyPendingUpdateIds = currentlyPendingUpdateIds;
    }

    @NotNull
    public final Set<AcpAgentId> getInitiallyInstalledIds() {
        return this.initiallyInstalledIds;
    }

    @NotNull
    public final Set<AcpAgentId> getInitiallyPendingUpdateIds() {
        return this.initiallyPendingUpdateIds;
    }
}

