/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.support;

import com.intellij.ml.llm.agents.acp.support.PowerShellProvider;
import com.intellij.ml.llm.agents.acp.support.ShellProviderKt;
import com.intellij.ml.llm.agents.acp.support.UnixShellProvider;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\bf\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bJ\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\u0003H&J\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/agents/acp/support/ShellProvider;", "", "shellPath", "", "getShellPath", "()Ljava/lang/String;", "buildCommandArgs", "", "command", "buildCommand", "args", "Companion", "intellij.ml.llm.agents.acp"})
public interface ShellProvider {
    @NotNull
    public static final Companion Companion = com.intellij.ml.llm.agents.acp.support.ShellProvider$Companion.$$INSTANCE;

    @NotNull
    public String getShellPath();

    @NotNull
    public List<String> buildCommandArgs(@NotNull String var1);

    @NotNull
    public String buildCommand(@NotNull String var1, @NotNull List<String> var2);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/acp/support/ShellProvider$Companion;", "", "<init>", "()V", "detect", "Lcom/intellij/ml/llm/agents/acp/support/ShellProvider;", "findPowerShell", "", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @Nullable
        public final ShellProvider detect() {
            if (OS.CURRENT != OS.Windows) {
                return UnixShellProvider.INSTANCE;
            }
            String powershellPath = this.findPowerShell();
            if (powershellPath != null) {
                return new PowerShellProvider(powershellPath);
            }
            ShellProviderKt.access$getLogger$p().warn("PowerShell not found on Windows, terminal support disabled");
            return null;
        }

        private final String findPowerShell() {
            String string = System.getenv("SystemRoot");
            if (string == null) {
                return null;
            }
            String systemRoot = string;
            String[] stringArray = new String[]{"System32", "WindowsPowerShell", "v1.0", "powershell.exe"};
            Path standardPath = Path.of(systemRoot, stringArray);
            if (Files.isExecutable(standardPath)) {
                return ((Object)standardPath).toString();
            }
            return null;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

