/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.claude.code;

import com.intellij.mcpserver.McpCallInfo;
import com.intellij.mcpserver.McpToolDescriptor;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.agents.claude.code.ClaudeCodeChatAgent;
import com.intellij.ml.llm.agents.claude.code.ClaudeLLMBundle;
import com.intellij.ml.llm.agents.claude.code.process.ClaudeCodeProcessHandlerKt;
import com.intellij.ml.llm.agents.impl.chat.processing.MessageLogOperation;
import com.intellij.ml.llm.grazie.AIAssistantChatException;
import com.intellij.ml.llm.grazie.ErrorStateAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\r\u0010\n\u001a\u00070\u0003\u00a2\u0006\u0002\b\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000f\u001a\u00020\u0003*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u0003*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0015"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "claudeToolUseIdTag", "", "AgreementDeclinedException", "Lcom/intellij/ml/llm/grazie/AIAssistantChatException;", "getOperation", "Lcom/intellij/ml/llm/agents/impl/chat/processing/MessageLogOperation;", "mcpToolDescriptor", "Lcom/intellij/mcpserver/McpToolDescriptor;", "getRandomFictionalStatus", "Lorg/jetbrains/annotations/Nls;", "toLocalFilePath", "Lcom/intellij/openapi/vcs/LocalFilePath;", "Lcom/intellij/openapi/vfs/VirtualFile;", "toolUseId", "Lcom/intellij/mcpserver/McpCallInfo;", "getToolUseId", "(Lcom/intellij/mcpserver/McpCallInfo;)Ljava/lang/String;", "chatId", "getChatId", "intellij.ml.llm.agents.claude.code"})
@SourceDebugExtension(value={"SMAP\nClaudeCodeChatAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaudeCodeChatAgent.kt\ncom/intellij/ml/llm/agents/claude/code/ClaudeCodeChatAgentKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,385:1\n13#2:386\n*S KotlinDebug\n*F\n+ 1 ClaudeCodeChatAgent.kt\ncom/intellij/ml/llm/agents/claude/code/ClaudeCodeChatAgentKt\n*L\n63#1:386\n*E\n"})
public final class ClaudeCodeChatAgentKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String claudeToolUseIdTag = "claudecode/toolUseId";
    @NotNull
    private static final AIAssistantChatException AgreementDeclinedException;

    private static final MessageLogOperation getOperation(McpToolDescriptor mcpToolDescriptor) {
        MessageLogOperation operation = switch (mcpToolDescriptor.getName()) {
            case "get_file_text_by_path" -> MessageLogOperation.READ;
            case "replace_text_in_file" -> MessageLogOperation.WRITE;
            case "search_in_files_by_text" -> MessageLogOperation.SEARCH;
            case "search_in_files_by_regex" -> MessageLogOperation.SEARCH;
            case "rename_refactoring" -> MessageLogOperation.REFACTOR;
            case "reformat_file" -> MessageLogOperation.WRITE;
            case "create_new_file" -> MessageLogOperation.WRITE;
            case "find_files_by_glob" -> MessageLogOperation.SEARCH;
            case "find_files_by_name_keyword" -> MessageLogOperation.SEARCH;
            case "get_all_open_file_paths" -> MessageLogOperation.READ;
            case "list_directory_tree" -> MessageLogOperation.READ;
            case "open_file_in_editor" -> MessageLogOperation.READ;
            case "get_run_configurations" -> MessageLogOperation.READ;
            case "execute_run_configuration" -> MessageLogOperation.RUN;
            case "get_symbol_info" -> MessageLogOperation.READ;
            case "get_file_problems" -> MessageLogOperation.READ;
            case "get_project_modules" -> MessageLogOperation.READ;
            case "get_project_dependencies" -> MessageLogOperation.READ;
            case "build_project" -> MessageLogOperation.BUILD;
            default -> null;
        };
        return operation;
    }

    private static final String getRandomFictionalStatus() {
        int index = RangesKt.random((IntRange)new IntRange(0, 19), (Random)((Random)Random.Default));
        String key = "fictional.status." + index;
        if (ClaudeLLMBundle.contains(key)) {
            return ClaudeLLMBundle.message(key, new Object[0]);
        }
        return ClaudeLLMBundle.message("progress.thinking", new Object[0]);
    }

    @NotNull
    public static final LocalFilePath toLocalFilePath(@NotNull VirtualFile $this$toLocalFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalFilePath, (String)"<this>");
        return new LocalFilePath($this$toLocalFilePath.getPath(), $this$toLocalFilePath.isDirectory());
    }

    @NotNull
    public static final String getToolUseId(@NotNull McpCallInfo $this$toolUseId) {
        Intrinsics.checkNotNullParameter((Object)$this$toolUseId, (String)"<this>");
        Object object = $this$toolUseId.getMeta().get((Object)claudeToolUseIdTag);
        Object object2 = object instanceof JsonPrimitive ? (JsonPrimitive)object : null;
        if (object2 == null || (object2 = object2.getContent()) == null) {
            JsonElement jsonElement = (JsonElement)$this$toolUseId.getRawArguments().get((Object)"tool_use_id");
            if (jsonElement != null) {
                object2 = jsonElement.toString();
            } else {
                String string;
                String it = string = $this$toolUseId.getMcpToolDescriptor().getName() + "_" + $this$toolUseId.getRawArguments().hashCode();
                boolean bl = false;
                logger.warn("Tool activity reported without claudecode/toolUseId: " + $this$toolUseId.getMcpToolDescriptor().getName());
                object2 = string;
            }
        }
        return object2;
    }

    @Nullable
    public static final String getChatId(@NotNull McpCallInfo $this$chatId) {
        Intrinsics.checkNotNullParameter((Object)$this$chatId, (String)"<this>");
        List list = (List)$this$chatId.getHeaders().get(ClaudeCodeProcessHandlerKt.getIJ_MCP_AIA_CHAT_ID());
        return list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ MessageLogOperation access$getOperation(McpToolDescriptor mcpToolDescriptor) {
        return ClaudeCodeChatAgentKt.getOperation(mcpToolDescriptor);
    }

    public static final /* synthetic */ String access$getRandomFictionalStatus() {
        return ClaudeCodeChatAgentKt.getRandomFictionalStatus();
    }

    public static final /* synthetic */ AIAssistantChatException access$getAgreementDeclinedException$p() {
        return AgreementDeclinedException;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClaudeCodeChatAgent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ClaudeCodeChatAgentKt.logger = logger;
        AgreementDeclinedException = new AIAssistantChatException(ClaudeLLMBundle.message("error.agreement.declined", new Object[0]), LLMBundle.message((String)"llm.link.try.again", (Object[])new Object[0]), (ErrorStateAction)ErrorStateAction.DefaultRetry.INSTANCE);
    }
}

