/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.lightAgent.patchListener;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.codeGeneration.lightAgent.patchListener.PatchEventsListener;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.EditCodeStep;
import com.intellij.ml.llm.codeGeneration.lightAgent.utils.ApplyPatchResult;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/codeGeneration/lightAgent/patchListener/PatchEventLogger;", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/patchListener/PatchEventsListener;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "onBatchStarted", "", "total", "", "onPatchApplied", "patch", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/EditCodeStep$EditResult$AppliedPatch;", "onBatchFinished", "notApplied", "onCorrectionsStarted", "failedCount", "onCorrectionResult", "onCorrectionsFinished", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
public final class PatchEventLogger
implements PatchEventsListener {
    @NotNull
    private final Logger log;
    public static final int $stable = 8;

    public PatchEventLogger() {
        Logger logger = Logger.getInstance(PatchEventLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    @Override
    public void onBatchStarted(int total) {
        this.log.info("Patch batch started [total=" + total + "]");
    }

    @Override
    public void onPatchApplied(@NotNull EditCodeStep.EditResult.AppliedPatch patch) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        if (patch.getState() == ApplyPatchResult.Success) {
            this.log.info("Patch applied [file=" + patch.getPatch().getFile() + ", description=" + patch.getPatch().getDescription() + "]");
        } else {
            this.log.warn("Patch NOT applied [file=" + patch.getPatch().getFile() + ", description=" + patch.getPatch().getDescription() + "], reason: " + patch.getState() + ", match: " + patch.getPatch().getMatch() + ", replacement: " + patch.getPatch().getReplacement());
        }
    }

    @Override
    public void onBatchFinished(int total, int notApplied) {
        this.log.info("Patch batch finished [total=" + total + ", notApplied=" + notApplied + "]");
    }

    @Override
    public void onCorrectionsStarted(int failedCount) {
        this.log.info("Patch corrections started [failedCount=" + failedCount + "]");
    }

    @Override
    public void onCorrectionResult(@NotNull EditCodeStep.EditResult.AppliedPatch patch) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        if (patch.getState() == ApplyPatchResult.Success) {
            this.log.info("Patch corrected [file=" + patch.getPatch().getFile() + ", description=" + patch.getPatch().getDescription() + "]");
        } else {
            this.log.warn("Patch NOT corrected [file=" + patch.getPatch().getFile() + ", description=" + patch.getPatch().getDescription() + "], reason: " + patch.getState() + ", match: " + patch.getPatch().getMatch() + ", replacement: " + patch.getPatch().getReplacement());
        }
    }

    @Override
    public void onCorrectionsFinished(int total, int notApplied) {
        this.log.info("Patch corrections finished [total=" + total + ", notApplied=" + notApplied + "]");
    }
}

