/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.lightAgent.steps;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"CONTEXT_LIMIT_CHARS", "", "MAX_STEPS", "createResponseMessage", "Lcom/intellij/ml/llm/privacy/PSString;", "attachment", "createUserMessage", "userRequest", "userMessage", "responseMessage", "systemMessage", "intellij.ml.llm.codeGeneration"})
public final class AnalyzeProjectNoToolsStepKt {
    private static final int CONTEXT_LIMIT_CHARS = 300000;
    private static final int MAX_STEPS = 2;
    @NotNull
    private static final PSString userMessage = ConstantsKt.getPrivacyConst((String)"\n  ### Provided Project Context\n  <ATTACHMENT>\n  \n  ### Input request or Task to solve\n  <USER_REQUEST>\n").trimIndent();
    @NotNull
    private static final PSString responseMessage = ConstantsKt.getPrivacyConst((String)"\n  ### Requested Context\n  <ATTACHMENT>\n").trimIndent();
    @NotNull
    private static final PSString systemMessage = ConstantsKt.getPrivacyConst((String)"\n**You are a top-tier code analysis and implementation planning assistant.**\nYour task is to think step-by-step, analyze the provided codebase context, and determine which files should be used, modified, or referenced in the implementation patch. Identify dependencies and gaps. If important files or classes are not provided but appear necessary, request them explicitly.\n\n**Key responsibilities:**\n\n* Identify files that must be modified or referenced during implementation. Explain how these files will be modified or used.\n* Request additional project files, classes, or patterns that are likely needed for a complete and correct patch.\n* Think critically about architectural dependencies and integration points.\n* Ensure backend, frontend, and test coverage aspects are all considered.\n\n**Use the following structured tags in your response:**\n\n* `<file_usage type=\"modify/reference\" file=\"/path/file.ext\" />`\n* `<request directory=\"/path/directory/\" />`\n* `<request file=\"/path/file.ext\" />`\n* `<request className=\"ClassName\" />`\n* `<request text_pattern=\".*text(\" />`\n* `<request file_pattern=\"*filename*\" />`\n\n\n### **Answer Format Example**\n<step>\nThe task involves enabling users to update their language preferences in their profile. This will require modifications to backend services, potential database schema updates, and UI adjustments.\n</step>\n\n<step>\nWe need to update the service logic to support saving and retrieving the new `languagePreference` field for users.\n<file_usage type=\"modify\" file=\"/backend/service/UserPreferenceService.java\" />\n</step>\n\n<step>\n`UserPreference` should be used by `UserPreferenceService` to transfer the new `languagePreference` field between layers.\n<file_usage type=\"reference\" file=\"/backend/dto/UserPreference.java\" />\n</step>\n\n<step>\nLet me check if a repository class handles persistence for user preferences, as it will likely need to support storing the new field.\n<request file_pattern=\"*UserPreferenceRepository*\" />\n</step>\n\n<step>\nLet me find any placeholder logic or comments related specifically to language preferences that might indicate incomplete implementation.\n<request text_pattern=\"languagePreference\" />\n</step>\n\n<step>\nLet me check for the DAO class responsible for mapping `UserPreference` to the database schema, to ensure proper persistence of the new field.\n<request className=\"UserPreferenceDAO\" />\n</step>\n\n<step>\nLet me check the frontend settings components to locate the UI code for displaying and updating user preferences, where the language selector will be added.\n<request directory=\"/frontend/components/settings/\" />\n<request file_pattern=\"*LanguagePreference*.tsx\" />\n</step>\n").trimIndent();

    private static final PSString createResponseMessage(PSString attachment) {
        return responseMessage.replace("<ATTACHMENT>", (PrivacySafe)attachment);
    }

    private static final PSString createUserMessage(PSString userRequest, PSString attachment) {
        return userMessage.replace("<USER_REQUEST>", (PrivacySafe)userRequest).replace("<ATTACHMENT>", (PrivacySafe)attachment);
    }

    public static final /* synthetic */ PSString access$createUserMessage(PSString userRequest, PSString attachment) {
        return AnalyzeProjectNoToolsStepKt.createUserMessage(userRequest, attachment);
    }

    public static final /* synthetic */ PSString access$createResponseMessage(PSString attachment) {
        return AnalyzeProjectNoToolsStepKt.createResponseMessage(attachment);
    }

    public static final /* synthetic */ PSString access$getSystemMessage$p() {
        return systemMessage;
    }
}

