/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.lightAgent.steps.events;

import androidx.compose.runtime.internal.StabilityInferred;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/StepEntry;", "", "sessionId", "", "title", "content", "timestamp", "Ljava/time/Instant;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;)V", "getSessionId", "()Ljava/lang/String;", "getTitle", "getContent", "getTimestamp", "()Ljava/time/Instant;", "timeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "toMessage", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
public final class StepEntry {
    @NotNull
    private final String sessionId;
    @NotNull
    private final String title;
    @NotNull
    private final String content;
    @NotNull
    private final Instant timestamp;
    private final DateTimeFormatter timeFormatter;
    public static final int $stable = 8;

    public StepEntry(@NotNull String sessionId, @NotNull String title, @NotNull String content2, @NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        this.sessionId = sessionId;
        this.title = title;
        this.content = content2;
        this.timestamp = timestamp;
        this.timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    }

    public /* synthetic */ StepEntry(String string, String string2, String string3, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        this(string, string2, string3, instant);
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final String toMessage() {
        StringBuilder stringBuilder;
        String header = "### " + this.timeFormatter.format(this.timestamp) + "   |   [" + this.title + "]\n";
        StringBuilder $this$toMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toMessage_u24lambda_u240.append(header);
        $this$toMessage_u24lambda_u240.append(this.content);
        if (!StringsKt.endsWith$default((String)this.content, (String)"\n", (boolean)false, (int)2, null)) {
            $this$toMessage_u24lambda_u240.append("\n");
        }
        $this$toMessage_u24lambda_u240.append("\n");
        return stringBuilder.toString();
    }
}

