/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.logging.file;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.LightAgentStepEventHandler;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.LightAgentStepEventListener;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.StepEntry;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.logging.file.LogDirectoryManager;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.logging.file.SessionWriterManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Disposer;
import java.nio.file.Path;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/LightAgentSessionFileLogger;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/LightAgentStepEventListener;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "logDir", "Ljava/nio/file/Path;", "sessionWriterManager", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/SessionWriterManager;", "directoryManager", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/LogDirectoryManager;", "cleanupJob", "Lkotlinx/coroutines/Job;", "onAppend", "", "stepEntry", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/StepEntry;", "dispose", "Companion", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
public final class LightAgentSessionFileLogger
implements Disposable,
LightAgentStepEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path logDir;
    @NotNull
    private final SessionWriterManager sessionWriterManager;
    @NotNull
    private final LogDirectoryManager directoryManager;
    @NotNull
    private final Job cleanupJob;
    public static final int $stable = 8;

    public LightAgentSessionFileLogger(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Path path = PathManager.getLogDir().resolve("light_agent_session_dumps");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.logDir = path;
        this.sessionWriterManager = new SessionWriterManager(scope, this.logDir);
        Duration duration2 = Duration.ofDays(4L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofDays(...)");
        this.directoryManager = new LogDirectoryManager(this.logDir, duration2, scope);
        this.directoryManager.initializeDirectory();
        this.cleanupJob = this.directoryManager.scheduleCleanup();
        LightAgentStepEventHandler.Companion.getInstance().addListener(this);
    }

    @Override
    public void onAppend(@NotNull StepEntry stepEntry) {
        Intrinsics.checkNotNullParameter((Object)stepEntry, (String)"stepEntry");
        this.sessionWriterManager.writeEntry(stepEntry);
    }

    public void dispose() {
        LightAgentStepEventHandler.Companion.getInstance().removeListener(this);
        Job.DefaultImpls.cancel$default((Job)this.cleanupJob, null, (int)1, null);
        Disposer.dispose((Disposable)this.sessionWriterManager);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/LightAgentSessionFileLogger$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/LightAgentSessionFileLogger;", "intellij.ml.llm.codeGeneration"})
    @SourceDebugExtension(value={"SMAP\nLightAgentSessionFileLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightAgentSessionFileLogger.kt\ncom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/LightAgentSessionFileLogger$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,49:1\n42#2,3:50\n*S KotlinDebug\n*F\n+ 1 LightAgentSessionFileLogger.kt\ncom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/LightAgentSessionFileLogger$Companion\n*L\n47#1:50,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LightAgentSessionFileLogger getInstance() {
            boolean $i$f$service = false;
            Class<LightAgentSessionFileLogger> serviceClass$iv = LightAgentSessionFileLogger.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LightAgentSessionFileLogger)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

