/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.airules.settings;

import com.intellij.ml.llm.context.airules.AiRulesLLMBundle;
import com.intellij.ml.llm.context.airules.AiRulesService;
import com.intellij.ml.llm.context.airules.metadata.AiRuleType;
import com.intellij.ml.llm.context.airules.settings.AiRulesSettingsManager;
import com.intellij.ml.llm.context.airules.statistics.AIAssistantAiRulesEventLogger;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0004\u001d\u001e\u001f B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\b0\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/context/airules/settings/AiRulesConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tableModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/ml/llm/context/airules/settings/AiRulesConfigurable$RuleItem;", "table", "Lcom/intellij/ui/table/TableView;", "kotlin.jvm.PlatformType", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "setEmptyText", "createNewRule", "source", "Lcom/intellij/ml/llm/context/airules/statistics/AIAssistantAiRulesEventLogger$AiRuleCreateSource;", "hideTableToolbar", "panel", "Ljavax/swing/JPanel;", "deleteSelectedRule", "updateRulesTable", "createNameColumn", "Lcom/intellij/util/ui/ColumnInfo;", "", "createTypeColumn", "Companion", "RuleItem", "PaddedCellRenderer", "AddRuleDialog", "intellij.ml.llm.context.airules"})
@SourceDebugExtension(value={"SMAP\nAiRulesConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiRulesConfigurable.kt\ncom/intellij/ml/llm/context/airules/settings/AiRulesConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1869#2,2:270\n*S KotlinDebug\n*F\n+ 1 AiRulesConfigurable.kt\ncom/intellij/ml/llm/context/airules/settings/AiRulesConfigurable\n*L\n183#1:270,2\n*E\n"})
public final class AiRulesConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ListTableModel<RuleItem> tableModel;
    @NotNull
    private final TableView<RuleItem> table;

    /*
     * WARNING - void declaration
     */
    public AiRulesConfigurable(@NotNull Project project2) {
        void $this$table_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(AiRulesLLMBundle.message("settings.configurable.ai.rules.display.name", new Object[0]), "ai.assistant.settings.rules", null, 4, null);
        this.project = project2;
        TableView tableView = new TableView[]{this.createNameColumn(), this.createTypeColumn()};
        this.tableModel = new ListTableModel((ColumnInfo[])tableView);
        TableView tableView2 = tableView = new TableView(this.tableModel);
        AiRulesConfigurable aiRulesConfigurable = this;
        boolean bl = false;
        $this$table_u24lambda_u240.setShowGrid(true);
        $this$table_u24lambda_u240.setStriped(true);
        $this$table_u24lambda_u240.setRowHeight(JBUI.scale((int)28));
        $this$table_u24lambda_u240.setSelectionForeground(UIUtil.getTableSelectionForeground((boolean)true));
        $this$table_u24lambda_u240.setSelectionBackground(UIUtil.getTableSelectionBackground((boolean)true));
        $this$table_u24lambda_u240.setFillsViewportHeight(true);
        $this$table_u24lambda_u240.setDefaultRenderer(String.class, (TableCellRenderer)new PaddedCellRenderer());
        $this$table_u24lambda_u240.addMouseListener((MouseListener)new MouseAdapter((TableView<RuleItem>)$this$table_u24lambda_u240, this){
            final /* synthetic */ TableView<RuleItem> $this_apply;
            final /* synthetic */ AiRulesConfigurable this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2) {
                    RuleItem ruleItem = (RuleItem)this.$this_apply.getSelectedObject();
                    if (ruleItem == null) {
                        return;
                    }
                    RuleItem selectedItem = ruleItem;
                    FileEditorManager.getInstance((Project)AiRulesConfigurable.access$getProject$p(this.this$0)).openTextEditor(new OpenFileDescriptor(AiRulesConfigurable.access$getProject$p(this.this$0), selectedItem.getFile(), 0), true);
                }
            }
        });
        aiRulesConfigurable.table = tableView;
    }

    @NotNull
    public DialogPanel createPanel() {
        this.setEmptyText();
        this.updateRulesTable();
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).disableUpDownActions().setAddAction(arg_0 -> AiRulesConfigurable.createPanel$lambda$0(this, arg_0)).setRemoveAction(arg_0 -> AiRulesConfigurable.createPanel$lambda$1(this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel tablePanel = jPanel;
        this.hideTableToolbar(tablePanel);
        DialogPanel descriptionPanel2 = BuilderKt.panel(arg_0 -> AiRulesConfigurable.createPanel$lambda$2(this, arg_0));
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)tablePanel).addToTop((Component)descriptionPanel2);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToTop(...)");
        BorderLayoutPanel mainPanel = borderLayoutPanel;
        return BuilderKt.panel(arg_0 -> AiRulesConfigurable.createPanel$lambda$3(mainPanel, arg_0));
    }

    public void apply() {
        boolean modified = this.isModified();
        super.apply();
        if (modified) {
            AiRulesSettingsManager.Companion.fireSettingsChanged(this.project);
        }
    }

    private final void setEmptyText() {
        Shortcut shortcut;
        Object[] addAction;
        StatusText statusText2 = this.table.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"getEmptyText(...)");
        StatusText emptyText = statusText2;
        emptyText.setText(AiRulesLLMBundle.message("airules.settings.table.empty.text", new Object[0]));
        emptyText.appendSecondaryText(AiRulesLLMBundle.message("airules.settings.table.empty.secondary.text", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> AiRulesConfigurable.setEmptyText$lambda$0(this, arg_0));
        Object[] objectArray = addAction = ActionManager.getInstance().getAction("NewElement");
        Shortcut shortcut2 = addAction != null && (objectArray = objectArray.getShortcutSet()) != null && (objectArray = objectArray.getShortcuts()) != null ? (Shortcut)ArraysKt.firstOrNull((Object[])objectArray) : (shortcut = null);
        if (shortcut != null) {
            emptyText.appendSecondaryText(" " + KeymapUtil.getShortcutText((Shortcut)shortcut), StatusText.DEFAULT_ATTRIBUTES, null);
        }
    }

    private final void createNewRule(AIAssistantAiRulesEventLogger.AiRuleCreateSource source) {
        Companion.openCreateRuleDialog(this.project, source, (Function0<Unit>)((Function0)() -> AiRulesConfigurable.createNewRule$lambda$0(this)));
    }

    private final void hideTableToolbar(JPanel panel2) {
        Component[] componentArray = panel2.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component2 : componentArray) {
            if (!(component2 instanceof CommonActionsPanel)) continue;
            ((CommonActionsPanel)component2).setVisible(false);
            break;
        }
    }

    private final void deleteSelectedRule() {
        RuleItem ruleItem = (RuleItem)this.table.getSelectedObject();
        if (ruleItem == null) {
            return;
        }
        RuleItem selectedItem = ruleItem;
        Object[] objectArray = new Object[]{selectedItem.getName()};
        int result2 = MessagesEx.showOkCancelDialog((Project)this.project, (String)AiRulesLLMBundle.message("airules.settings.table.delete.message", objectArray), (String)AiRulesLLMBundle.message("airules.settings.table.delete.title", new Object[0]), (String)AiRulesLLMBundle.message("airules.settings.table.delete.button", new Object[0]), (String)AiRulesLLMBundle.message("airules.settings.table.delete.cancel.button", new Object[0]), null);
        if (result2 != 0) {
            return;
        }
        AiRulesService.Companion.getInstance(this.project).deleteFile(selectedItem.getFile(), AIAssistantAiRulesEventLogger.AiRuleDeleteSource.SETTINGS_SHORTCUT, (Function0<Unit>)((Function0)() -> AiRulesConfigurable.deleteSelectedRule$lambda$0(this)), (Function0<Unit>)((Function0)() -> AiRulesConfigurable.deleteSelectedRule$lambda$1(this)));
    }

    private final void updateRulesTable() {
        List items2 = new ArrayList();
        AiRulesService service = AiRulesService.Companion.getInstance(this.project);
        boolean bl = false;
        Iterable $this$forEach$iv = service.getAiRuleFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file2 = (VirtualFile)element$iv;
            boolean bl2 = false;
            AiRuleType ruleType2 = (AiRuleType)((Object)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AiRuleType>, Object>(service, file2, null){
                int label;
                final /* synthetic */ AiRulesService $service;
                final /* synthetic */ VirtualFile $file;
                {
                    this.$service = $service;
                    this.$file = $file;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = this.$service.getRuleType(this.$file, (Continuation<? super AiRuleType>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((v1 = (AiRuleType)v0) == null) {
                                v1 = AiRuleType.ALWAYS;
                            }
                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super AiRuleType> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })));
            String string = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            items2.add(new RuleItem(string, ruleType2.getDisplayName(), file2));
        }
        this.tableModel.setItems(items2);
    }

    private final ColumnInfo<RuleItem, String> createNameColumn() {
        String string = AiRulesLLMBundle.message("airules.settings.table.file.column.name", new Object[0]);
        return (ColumnInfo)new ColumnInfo<RuleItem, String>(string){

            public String valueOf(RuleItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getName();
            }
        };
    }

    private final ColumnInfo<RuleItem, String> createTypeColumn() {
        String string = AiRulesLLMBundle.message("airules.settings.table.apply.column.name", new Object[0]);
        return (ColumnInfo)new ColumnInfo<RuleItem, String>(string){

            public String valueOf(RuleItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getType();
            }
        };
    }

    private static final void createPanel$lambda$0(AiRulesConfigurable this$0, AnActionButton it) {
        this$0.createNewRule(AIAssistantAiRulesEventLogger.AiRuleCreateSource.SETTINGS_SHORTCUT);
    }

    private static final void createPanel$lambda$1(AiRulesConfigurable this$0, AnActionButton it) {
        this$0.deleteSelectedRule();
    }

    private static final Unit createPanel$lambda$2(AiRulesConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new IntelliJSpacingConfiguration(){
            private final int verticalSmallGap;
            private final int verticalMediumGap;
            {
                this.verticalSmallGap = 4;
                this.verticalMediumGap = 8;
            }

            public int getVerticalSmallGap() {
                return this.verticalSmallGap;
            }

            public int getVerticalMediumGap() {
                return this.verticalMediumGap;
            }
        }, arg_0 -> AiRulesConfigurable.createPanel$lambda$2$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$2$0(AiRulesConfigurable this$0, Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, AiRulesConfigurable::createPanel$lambda$2$0$0, (int)1, null).bottomGap(BottomGap.SMALL);
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> AiRulesConfigurable.createPanel$lambda$2$0$1(this$0, arg_0), (int)1, null).bottomGap(BottomGap.MEDIUM);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$2$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)AiRulesLLMBundle.message("airules.settings.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$2$0$1(AiRulesConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(AiRulesLLMBundle.message("airules.settings.create.rule.button", new Object[0]), arg_0 -> AiRulesConfigurable.createPanel$lambda$2$0$1$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$2$0$1$0(AiRulesConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.createNewRule(AIAssistantAiRulesEventLogger.AiRuleCreateSource.SETTINGS_BUTTON);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3(BorderLayoutPanel $mainPanel, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiRulesConfigurable.createPanel$lambda$3$0($mainPanel, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$3$0(BorderLayoutPanel $mainPanel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$mainPanel).resizableColumn().align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final void setEmptyText$lambda$0(AiRulesConfigurable this$0, ActionEvent it) {
        this$0.createNewRule(AIAssistantAiRulesEventLogger.AiRuleCreateSource.SETTINGS_EMPTY_STATE_LINK);
    }

    private static final Unit createNewRule$lambda$0(AiRulesConfigurable this$0) {
        this$0.updateRulesTable();
        return Unit.INSTANCE;
    }

    private static final Unit deleteSelectedRule$lambda$0(AiRulesConfigurable this$0) {
        this$0.updateRulesTable();
        return Unit.INSTANCE;
    }

    private static final Unit deleteSelectedRule$lambda$1(AiRulesConfigurable this$0) {
        MessagesEx.showErrorDialog((Project)this$0.project, (String)AiRulesLLMBundle.message("airules.settings.table.delete.error.message", new Object[0]), (String)AiRulesLLMBundle.message("airules.settings.table.delete.error.title", new Object[0]));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(AiRulesConfigurable $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/context/airules/settings/AiRulesConfigurable$AddRuleDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "nameField", "Lcom/intellij/ui/components/JBTextField;", "createCenterPanel", "Ljavax/swing/JComponent;", "continuousValidation", "", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getPreferredFocusedComponent", "getEnteredName", "", "isValidName", "name", "intellij.ml.llm.context.airules"})
    @SourceDebugExtension(value={"SMAP\nAiRulesConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiRulesConfigurable.kt\ncom/intellij/ml/llm/context/airules/settings/AiRulesConfigurable$AddRuleDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1#2:270\n*E\n"})
    private static final class AddRuleDialog
    extends DialogWrapper {
        @NotNull
        private final JBTextField nameField;

        public AddRuleDialog(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            super(project2, true);
            this.nameField = new JBTextField();
            this.setTitle(AiRulesLLMBundle.message("airules.settings.create.rule.title", new Object[0]));
            this.init();
            this.setSize(320, this.getSize().height);
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel(arg_0 -> AddRuleDialog.createCenterPanel$lambda$0(this, arg_0));
        }

        protected boolean continuousValidation() {
            return true;
        }

        @Nullable
        protected ValidationInfo doValidate() {
            String name = this.nameField.getText();
            Intrinsics.checkNotNull((Object)name);
            if (this.isValidName(name)) {
                return null;
            }
            return StringsKt.isBlank((CharSequence)name) ? new ValidationInfo(AiRulesLLMBundle.message("airules.settings.create.rule.error.empty.name", new Object[0]), (JComponent)this.nameField) : new ValidationInfo(AiRulesLLMBundle.message("airules.settings.create.rule.error.invalid.name", new Object[0]), (JComponent)this.nameField);
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            return (JComponent)this.nameField;
        }

        @Nullable
        public final String getEnteredName() {
            CharSequence charSequence;
            CharSequence charSequence2 = this.nameField.getText();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }

        private final boolean isValidName(String name) {
            return !StringsKt.contains$default((CharSequence)name, (char)'.', (boolean)false, (int)2, null) && !StringsKt.isBlank((CharSequence)name);
        }

        private static final Unit createCenterPanel$lambda$0(AddRuleDialog this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new IntelliJSpacingConfiguration(){
                private final int verticalMediumGap;
                {
                    this.verticalMediumGap = 16;
                }

                public int getVerticalMediumGap() {
                    return this.verticalMediumGap;
                }
            }, arg_0 -> AddRuleDialog.createCenterPanel$lambda$0$0(this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$0(AddRuleDialog this$0, Panel $this$customizeSpacingConfiguration) {
            Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
            $this$customizeSpacingConfiguration.row(AiRulesLLMBundle.message("airules.settings.create.rule.name", new Object[0]), arg_0 -> AddRuleDialog.createCenterPanel$lambda$0$0$0(this$0, arg_0)).bottomGap(BottomGap.MEDIUM);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$0$0(AddRuleDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.nameField), (String)AiRulesLLMBundle.message("airules.settings.create.rule.comment", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE).resizableColumn();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/context/airules/settings/AiRulesConfigurable$Companion;", "", "<init>", "()V", "openCreateRuleDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "source", "Lcom/intellij/ml/llm/context/airules/statistics/AIAssistantAiRulesEventLogger$AiRuleCreateSource;", "invokeLaterAction", "Lkotlin/Function0;", "intellij.ml.llm.context.airules"})
    public static final class Companion {
        private Companion() {
        }

        public final void openCreateRuleDialog(@NotNull Project project2, @NotNull AIAssistantAiRulesEventLogger.AiRuleCreateSource source, @Nullable Function0<Unit> invokeLaterAction) {
            String name;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            AddRuleDialog dialog2 = new AddRuleDialog(project2);
            if (dialog2.showAndGet() && (name = dialog2.getEnteredName()) != null) {
                ApplicationManager.getApplication().invokeLater(() -> Companion.openCreateRuleDialog$lambda$0(project2, name, source, invokeLaterAction));
            }
        }

        public static /* synthetic */ void openCreateRuleDialog$default(Companion companion, Project project2, AIAssistantAiRulesEventLogger.AiRuleCreateSource aiRuleCreateSource, Function0 function0, int n, Object object) {
            if ((n & 4) != 0) {
                function0 = null;
            }
            companion.openCreateRuleDialog(project2, aiRuleCreateSource, (Function0<Unit>)function0);
        }

        private static final void openCreateRuleDialog$lambda$0(Project $project, String $name, AIAssistantAiRulesEventLogger.AiRuleCreateSource $source, Function0 $invokeLaterAction) {
            block0: {
                AiRulesService.Companion.getInstance($project).createNewFile($name, $source);
                Function0 function0 = $invokeLaterAction;
                if (function0 == null) break block0;
                function0.invoke();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/context/airules/settings/AiRulesConfigurable$PaddedCellRenderer;", "Ljavax/swing/table/DefaultTableCellRenderer;", "<init>", "()V", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "intellij.ml.llm.context.airules"})
    private static final class PaddedCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Component component2 = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            this.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
            Intrinsics.checkNotNull((Object)component2);
            return component2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/context/airules/settings/AiRulesConfigurable$RuleItem;", "", "name", "", "type", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getName", "()Ljava/lang/String;", "getType", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.context.airules"})
    private static final class RuleItem {
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        @NotNull
        private final VirtualFile file;

        public RuleItem(@NotNull String name, @NotNull String type2, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.name = name;
            this.type = type2;
            this.file = file2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final VirtualFile component3() {
            return this.file;
        }

        @NotNull
        public final RuleItem copy(@NotNull String name, @NotNull String type2, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return new RuleItem(name, type2, file2);
        }

        public static /* synthetic */ RuleItem copy$default(RuleItem ruleItem, String string, String string2, VirtualFile virtualFile2, int n, Object object) {
            if ((n & 1) != 0) {
                string = ruleItem.name;
            }
            if ((n & 2) != 0) {
                string2 = ruleItem.type;
            }
            if ((n & 4) != 0) {
                virtualFile2 = ruleItem.file;
            }
            return ruleItem.copy(string, string2, virtualFile2);
        }

        @NotNull
        public String toString() {
            return "RuleItem(name=" + this.name + ", type=" + this.type + ", file=" + this.file + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + this.file.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RuleItem)) {
                return false;
            }
            RuleItem ruleItem = (RuleItem)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)ruleItem.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)ruleItem.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)ruleItem.file);
        }
    }
}

