/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.listeners;

import com.intellij.ml.llm.daemon.insight.handler.listeners.InsightMouseAdapter;
import com.intellij.ml.llm.daemon.insight.handler.listeners.InsightMouseMotionListener;
import com.intellij.ml.llm.daemon.insight.handler.listeners.InsightTypingListener;
import com.intellij.ml.llm.daemon.insight.handler.listeners.InsightVisibleAreaListener;
import com.intellij.ml.llm.daemon.insight.logs.listeners.InsightCaretListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/listeners/InsightEditorListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorTypeSupported", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightEditorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightEditorListener.kt\ncom/intellij/ml/llm/daemon/insight/handler/listeners/InsightEditorListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n13#2:45\n*S KotlinDebug\n*F\n+ 1 InsightEditorListener.kt\ncom/intellij/ml/llm/daemon/insight/handler/listeners/InsightEditorListener\n*L\n17#1:45\n*E\n"})
public final class InsightEditorListener
implements EditorFactoryListener {
    @NotNull
    private final Logger log;

    public InsightEditorListener() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InsightEditorListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    public void editorCreated(@NotNull EditorFactoryEvent event2) {
        Disposable disposable;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Editor editor2 = event2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        if (editor3.isDisposed() || !this.editorTypeSupported(editor3)) {
            return;
        }
        Project project2 = editor3.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (project3.isDisposed()) {
            return;
        }
        Disposable it = disposable = Disposer.newDisposable((String)"insight-editor-listener");
        boolean bl = false;
        EditorUtil.disposeWithEditor((Editor)editor3, (Disposable)it);
        Disposable disposable2 = disposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"also(...)");
        Disposable disposable3 = disposable2;
        editor3.getDocument().addDocumentListener((DocumentListener)new InsightTypingListener(editor3), disposable3);
        editor3.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new InsightVisibleAreaListener(), disposable3);
        editor3.addEditorMouseMotionListener((EditorMouseMotionListener)new InsightMouseMotionListener());
        editor3.getContentComponent().addMouseListener(new InsightMouseAdapter(editor3));
        editor3.getCaretModel().addCaretListener((CaretListener)new InsightCaretListener(), disposable3);
    }

    private final boolean editorTypeSupported(Editor editor2) {
        boolean isTest = editor2.getEditorKind() == EditorKind.UNTYPED && ApplicationKt.getApplication().isUnitTestMode();
        return editor2.getEditorKind() == EditorKind.MAIN_EDITOR || isTest;
    }
}

