/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.provider;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/Debounce;", "", "<init>", "()V", "nextModelExecutionTime", "Ljava/util/concurrent/atomic/AtomicLong;", "modelRequestHappened", "", "getDebounce", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "typingKey", "Lcom/intellij/openapi/util/Key;", "AFTER_MODEL_REQUEST_DELAY", "MIN_DEBOUNCE", "intellij.ml.llm.daemon"})
public final class Debounce {
    @NotNull
    public static final Debounce INSTANCE = new Debounce();
    @NotNull
    private static final AtomicLong nextModelExecutionTime = new AtomicLong(0L);
    @NotNull
    private static final Key<Long> typingKey = new Key("InsightDebounceTyping");
    private static final long AFTER_MODEL_REQUEST_DELAY = 5000L;
    private static final long MIN_DEBOUNCE = 1000L;

    private Debounce() {
    }

    public final void modelRequestHappened() {
        nextModelExecutionTime.set(System.currentTimeMillis() + 5000L);
    }

    public final long getDebounce(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        long cur = System.currentTimeMillis();
        Long l = (Long)editor2.getUserData(typingKey);
        long l2 = (l != null ? l : cur) - cur;
        long l3 = nextModelExecutionTime.get() - cur;
        long l4 = 1000L;
        return Math.max(l2, Math.max(l3, l4));
    }
}

