/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.provider.caches;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.handler.InsightRange;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightRequest;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightWorkingRange;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 '2\u00020\u0001:\u0005#$%&'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u000bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000bJ\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u001d\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\b J\u0014\u0010!\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0006\u0010\"\u001a\u00020\u001bR*\u0010\u0004\u001a\u001e\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache;", "", "<init>", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache$Key;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache$Entry;", "createAccessPoint", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache$AccessPoint;", "request", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightRequest;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "workingRange", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "getIfFullyCovered", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "accessPoint", "getPartial", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache$PartialResult;", "put", "", "models", "hashAroundFor", "", "line", "hashAroundFor$intellij_ml_llm_daemon", "keyFor", "clear", "Key", "Entry", "AccessPoint", "PartialResult", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightsCache.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1563#2:139\n1634#2,3:140\n1869#2:144\n1563#2:145\n1634#2,3:146\n1563#2:149\n1634#2,3:150\n1869#2,2:153\n1870#2:155\n1869#2:156\n295#2,2:157\n1870#2:159\n1869#2,2:160\n1#3:143\n*S KotlinDebug\n*F\n+ 1 InsightsCache.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache\n*L\n37#1:139\n37#1:140,3\n63#1:144\n70#1:145\n70#1:146,3\n72#1:149\n72#1:150,3\n85#1:153,2\n63#1:155\n94#1:156\n95#1:157,2\n94#1:159\n122#1:160,2\n*E\n"})
public final class InsightsCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<Key, Set<Entry>> cache;
    private static final int AROUND_HASH_BEFORE_LINES = 5;
    private static final int AROUND_HASH_AFTER_LINES = 15;
    private static final long CACHE_KEYS_MAX_SIZE = 1000L;
    private static final long CACHE_PER_KEY_MAX_SIZE = 100L;

    public InsightsCache() {
        Cache cache = Caffeine.newBuilder().maximumSize(1000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    @RequiresReadLock
    @NotNull
    public final AccessPoint createAccessPoint(@NotNull InsightRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return this.createAccessPoint(request2.getDocument(), request2.getFile(), request2.getWorkingRange());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public final AccessPoint createAccessPoint(@NotNull Document document2, @NotNull PsiFile file2, @NotNull InsightWorkingRange workingRange) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)workingRange, (String)"workingRange");
        int adjustedStart = workingRange.getFirstLine() - 5;
        int adjustedEnd = Math.min(document2.getLineCount() - 1, workingRange.getLastLine() + 15 + 1);
        Object object = file2.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            object = String.valueOf(document2.hashCode());
        }
        Object fileId = object;
        Iterable $this$map$iv = (Iterable)new IntRange(adjustedStart, adjustedEnd);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it < 0) {
                object2 = "fakePrefix" + (int)it;
            } else {
                String string = document2.getText(new TextRange(document2.getLineStartOffset((int)it), document2.getLineEndOffset((int)it)));
                Intrinsics.checkNotNull((Object)string);
                object2 = string;
            }
            String lineText = object2;
            String textForHash = "!" + lineText;
            collection.add(textForHash.hashCode());
        }
        List hashes = (List)destination$iv$iv;
        return new AccessPoint((String)fileId, workingRange, hashes);
    }

    @Nullable
    public final List<InsightModel> getIfFullyCovered(@NotNull AccessPoint accessPoint) {
        PartialResult partialResult;
        Intrinsics.checkNotNullParameter((Object)accessPoint, (String)"accessPoint");
        PartialResult it = partialResult = this.getPartial(accessPoint);
        boolean bl = false;
        PartialResult partialResult2 = it.getUnmatched().isEmpty() ? partialResult : null;
        return partialResult2 != null ? partialResult2.getCovered() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PartialResult getPartial(@NotNull AccessPoint accessPoint) {
        Intrinsics.checkNotNullParameter((Object)accessPoint, (String)"accessPoint");
        List covered = new ArrayList();
        Set unmatched = new LinkedHashSet();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)accessPoint.getWorkingRange().getFirstLine(), (int)accessPoint.getWorkingRange().getLastLine());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            InsightModel it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            int element$iv;
            int line = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Key key = this.keyFor(accessPoint, line);
            Set values = (Set)this.cache.getIfPresent((Object)key);
            if (values == null) {
                unmatched.add(line);
                continue;
            }
            Iterable $this$map$iv = values;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Entry entry = (Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Entry)((Object)it)).getInsight());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (InsightModel)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                InsightRange newRange = new InsightRange(line, line + it.getRange().getEndLine() - it.getRange().getStartLine());
                collection.add(Intrinsics.areEqual((Object)it.getRange(), (Object)newRange) ? it : new InsightModel(it.getText(), it.getReasoning(), new InsightRange(line, line + it.getRange().getEndLine() - it.getRange().getStartLine()), it.getType()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                InsightModel it2 = (InsightModel)element$iv2;
                boolean bl4 = false;
                covered.add(it2);
            }
        }
        return new PartialResult(covered, unmatched);
    }

    public final void put(@NotNull AccessPoint accessPoint, @NotNull List<InsightModel> models2) {
        Intrinsics.checkNotNullParameter((Object)accessPoint, (String)"accessPoint");
        Intrinsics.checkNotNullParameter(models2, (String)"models");
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)accessPoint.getWorkingRange().getFirstLine(), (int)accessPoint.getWorkingRange().getLastLine());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object v0;
            int line;
            block2: {
                int element$iv;
                line = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Iterable $this$firstOrNull$iv = models2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    InsightModel it = (InsightModel)element$iv2;
                    boolean bl2 = false;
                    if (!(it.getRange().getStartLine() == line)) continue;
                    v0 = element$iv2;
                    break block2;
                }
                v0 = null;
            }
            InsightModel correspondingModel = v0;
            Key key = this.keyFor(accessPoint, line);
            Object object = this.cache.get((Object)key, arg_0 -> InsightsCache.put$lambda$0$2(InsightsCache::put$lambda$0$1, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Set values = (Set)object;
            if (!values.isEmpty() || correspondingModel == null) continue;
            values.add(new Entry(correspondingModel));
            this.cache.put((Object)key, (Object)values);
        }
    }

    @TestOnly
    public final int hashAroundFor$intellij_ml_llm_daemon(@NotNull AccessPoint accessPoint, int line) {
        Intrinsics.checkNotNullParameter((Object)accessPoint, (String)"accessPoint");
        return this.keyFor(accessPoint, line).getHashAround();
    }

    private final Key keyFor(AccessPoint $this$keyFor, int line) {
        int originalStart = 5 + line - $this$keyFor.getWorkingRange().getFirstLine();
        int aroundStart = originalStart - 5;
        int aroundEnd = Math.min(originalStart + 15, $this$keyFor.getHashes().size() - 1);
        long aroundHash = 0L;
        Iterable $this$forEach$iv = (Iterable)new IntRange(aroundStart, aroundEnd);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int h = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            aroundHash = (31L * aroundHash + (long)((Number)$this$keyFor.getHashes().get(h)).intValue()) % (long)1000000007;
        }
        return new Key($this$keyFor.getFileId(), (int)aroundHash);
    }

    public final void clear() {
        this.cache.invalidateAll();
    }

    private static final Set put$lambda$0$1(Key it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ConcurrentMap it2 = Caffeine.newBuilder().maximumSize(100L).build().asMap();
        boolean bl = false;
        return Collections.newSetFromMap(it2);
    }

    private static final Set put$lambda$0$2(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache$AccessPoint;", "", "fileId", "", "workingRange", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "hashes", "", "", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;Ljava/util/List;)V", "getFileId", "()Ljava/lang/String;", "getWorkingRange", "()Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "getHashes", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.ml.llm.daemon"})
    public static final class AccessPoint {
        @NotNull
        private final String fileId;
        @NotNull
        private final InsightWorkingRange workingRange;
        @NotNull
        private final List<Integer> hashes;

        public AccessPoint(@NotNull String fileId, @NotNull InsightWorkingRange workingRange, @NotNull List<Integer> hashes) {
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            Intrinsics.checkNotNullParameter((Object)workingRange, (String)"workingRange");
            Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
            this.fileId = fileId;
            this.workingRange = workingRange;
            this.hashes = hashes;
        }

        @NotNull
        public final String getFileId() {
            return this.fileId;
        }

        @NotNull
        public final InsightWorkingRange getWorkingRange() {
            return this.workingRange;
        }

        @NotNull
        public final List<Integer> getHashes() {
            return this.hashes;
        }

        @NotNull
        public final String component1() {
            return this.fileId;
        }

        @NotNull
        public final InsightWorkingRange component2() {
            return this.workingRange;
        }

        @NotNull
        public final List<Integer> component3() {
            return this.hashes;
        }

        @NotNull
        public final AccessPoint copy(@NotNull String fileId, @NotNull InsightWorkingRange workingRange, @NotNull List<Integer> hashes) {
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            Intrinsics.checkNotNullParameter((Object)workingRange, (String)"workingRange");
            Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
            return new AccessPoint(fileId, workingRange, hashes);
        }

        public static /* synthetic */ AccessPoint copy$default(AccessPoint accessPoint, String string, InsightWorkingRange insightWorkingRange, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = accessPoint.fileId;
            }
            if ((n & 2) != 0) {
                insightWorkingRange = accessPoint.workingRange;
            }
            if ((n & 4) != 0) {
                list = accessPoint.hashes;
            }
            return accessPoint.copy(string, insightWorkingRange, list);
        }

        @NotNull
        public String toString() {
            return "AccessPoint(fileId=" + this.fileId + ", workingRange=" + this.workingRange + ", hashes=" + this.hashes + ")";
        }

        public int hashCode() {
            int result2 = this.fileId.hashCode();
            result2 = result2 * 31 + this.workingRange.hashCode();
            result2 = result2 * 31 + ((Object)this.hashes).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AccessPoint)) {
                return false;
            }
            AccessPoint accessPoint = (AccessPoint)other;
            if (!Intrinsics.areEqual((Object)this.fileId, (Object)accessPoint.fileId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.workingRange, (Object)accessPoint.workingRange)) {
                return false;
            }
            return Intrinsics.areEqual(this.hashes, accessPoint.hashes);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache$Companion;", "", "<init>", "()V", "AROUND_HASH_BEFORE_LINES", "", "AROUND_HASH_AFTER_LINES", "CACHE_KEYS_MAX_SIZE", "", "CACHE_PER_KEY_MAX_SIZE", "intellij.ml.llm.daemon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache$Entry;", "", "insight", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "<init>", "(Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;)V", "getInsight", "()Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.daemon"})
    private static final class Entry {
        @NotNull
        private final InsightModel insight;

        public Entry(@NotNull InsightModel insight) {
            Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
            this.insight = insight;
        }

        @NotNull
        public final InsightModel getInsight() {
            return this.insight;
        }

        @NotNull
        public final InsightModel component1() {
            return this.insight;
        }

        @NotNull
        public final Entry copy(@NotNull InsightModel insight) {
            Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
            return new Entry(insight);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, InsightModel insightModel, int n, Object object) {
            if ((n & 1) != 0) {
                insightModel = entry.insight;
            }
            return entry.copy(insightModel);
        }

        @NotNull
        public String toString() {
            return "Entry(insight=" + this.insight + ")";
        }

        public int hashCode() {
            return this.insight.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            return Intrinsics.areEqual((Object)this.insight, (Object)entry.insight);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache$Key;", "", "fileId", "", "hashAround", "", "<init>", "(Ljava/lang/String;I)V", "getFileId", "()Ljava/lang/String;", "getHashAround", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.ml.llm.daemon"})
    private static final class Key {
        @NotNull
        private final String fileId;
        private final int hashAround;

        public Key(@NotNull String fileId, int hashAround) {
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            this.fileId = fileId;
            this.hashAround = hashAround;
        }

        @NotNull
        public final String getFileId() {
            return this.fileId;
        }

        public final int getHashAround() {
            return this.hashAround;
        }

        @NotNull
        public final String component1() {
            return this.fileId;
        }

        public final int component2() {
            return this.hashAround;
        }

        @NotNull
        public final Key copy(@NotNull String fileId, int hashAround) {
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            return new Key(fileId, hashAround);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = key.fileId;
            }
            if ((n2 & 2) != 0) {
                n = key.hashAround;
            }
            return key.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "Key(fileId=" + this.fileId + ", hashAround=" + this.hashAround + ")";
        }

        public int hashCode() {
            int result2 = this.fileId.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.hashAround);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.fileId, (Object)key.fileId)) {
                return false;
            }
            return this.hashAround == key.hashAround;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/caches/InsightsCache$PartialResult;", "", "covered", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "unmatched", "", "", "<init>", "(Ljava/util/List;Ljava/util/Set;)V", "getCovered", "()Ljava/util/List;", "getUnmatched", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.daemon"})
    public static final class PartialResult {
        @NotNull
        private final List<InsightModel> covered;
        @NotNull
        private final Set<Integer> unmatched;

        public PartialResult(@NotNull List<InsightModel> covered, @NotNull Set<Integer> unmatched) {
            Intrinsics.checkNotNullParameter(covered, (String)"covered");
            Intrinsics.checkNotNullParameter(unmatched, (String)"unmatched");
            this.covered = covered;
            this.unmatched = unmatched;
        }

        @NotNull
        public final List<InsightModel> getCovered() {
            return this.covered;
        }

        @NotNull
        public final Set<Integer> getUnmatched() {
            return this.unmatched;
        }

        @NotNull
        public final List<InsightModel> component1() {
            return this.covered;
        }

        @NotNull
        public final Set<Integer> component2() {
            return this.unmatched;
        }

        @NotNull
        public final PartialResult copy(@NotNull List<InsightModel> covered, @NotNull Set<Integer> unmatched) {
            Intrinsics.checkNotNullParameter(covered, (String)"covered");
            Intrinsics.checkNotNullParameter(unmatched, (String)"unmatched");
            return new PartialResult(covered, unmatched);
        }

        public static /* synthetic */ PartialResult copy$default(PartialResult partialResult, List list, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                list = partialResult.covered;
            }
            if ((n & 2) != 0) {
                set = partialResult.unmatched;
            }
            return partialResult.copy(list, set);
        }

        @NotNull
        public String toString() {
            return "PartialResult(covered=" + this.covered + ", unmatched=" + this.unmatched + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.covered).hashCode();
            result2 = result2 * 31 + ((Object)this.unmatched).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PartialResult)) {
                return false;
            }
            PartialResult partialResult = (PartialResult)other;
            if (!Intrinsics.areEqual(this.covered, partialResult.covered)) {
                return false;
            }
            return Intrinsics.areEqual(this.unmatched, partialResult.unmatched);
        }
    }
}

