/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.kit;

import com.intellij.lang.Language;
import com.intellij.ml.llm.daemon.insight.InsightEventListener;
import com.intellij.ml.llm.daemon.insight.InsightEventReporter;
import com.intellij.ml.llm.daemon.insight.diagnostics.InsightComplexityRangesView;
import com.intellij.ml.llm.daemon.insight.handler.InsightRange;
import com.intellij.ml.llm.daemon.insight.kit.InsightLanguageKit;
import com.intellij.ml.llm.daemon.insight.kit.InsightLogBlockRangeHeuristics;
import com.intellij.ml.llm.daemon.insight.settings.InsightSettingsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0002J&\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH$\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/daemon/insight/kit/InsightLogBlockRangeHeuristicsBase;", "Lcom/intellij/ml/llm/daemon/insight/kit/InsightLogBlockRangeHeuristics;", "<init>", "()V", "calculateRanges", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightRange;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "computePoints", "", "element", "Lcom/intellij/psi/PsiElement;", "out", "", "sumChildrenPoints", "addRangeForElement", "", "isNearCommentOrDocstring", "", "pointsForCurrent", "canBeTerminal", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightLogBlockRangeHeuristicsBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightLogBlockRangeHeuristicsBase.kt\ncom/intellij/ml/llm/daemon/insight/kit/InsightLogBlockRangeHeuristicsBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 InsightEventDispatcher.kt\ncom/intellij/ml/llm/daemon/insight/InsightEventDispatcherKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n1761#2,3:82\n29#3:85\n13#4:86\n*S KotlinDebug\n*F\n+ 1 InsightLogBlockRangeHeuristicsBase.kt\ncom/intellij/ml/llm/daemon/insight/kit/InsightLogBlockRangeHeuristicsBase\n*L\n71#1:82,3\n78#1:85\n78#1:86\n*E\n"})
public abstract class InsightLogBlockRangeHeuristicsBase
implements InsightLogBlockRangeHeuristics {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final InsightEventReporter LOG;

    @Override
    @NotNull
    public List<InsightRange> calculateRanges(@NotNull PsiFile file2, @NotNull Document document2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        ArrayList result2 = new ArrayList();
        this.computePoints((PsiElement)file2, document2, result2);
        return result2;
    }

    private final int computePoints(PsiElement element2, Document document2, List<InsightRange> out) {
        int total = this.pointsForCurrent(element2) + this.sumChildrenPoints(element2, document2, out);
        Project project2 = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (InsightComplexityRangesView.Companion.getInstance(project2).isEnabled()) {
            int n = document2.hashCode();
            long l = document2.getModificationStamp();
            TextRange textRange = element2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            LOG.fire(new InsightEventListener.ComplexityForElementCalculated(n, l, textRange, total));
        }
        if (this.isNearCommentOrDocstring(document2, element2)) {
            return 0;
        }
        int frequencyThreshold = InsightSettingsManager.Companion.getInstance().getFrequency().getThreshold();
        if (this.canBeTerminal(element2) && total > frequencyThreshold) {
            this.addRangeForElement(element2, document2, out);
            return 0;
        }
        return total;
    }

    private final int sumChildrenPoints(PsiElement element2, Document document2, List<InsightRange> out) {
        int acc = 0;
        PsiElement[] psiElementArray = element2.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        for (PsiElement psiElement : psiElementArray) {
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement child = psiElement;
            acc += this.computePoints(child, document2, out);
        }
        return acc;
    }

    private final void addRangeForElement(PsiElement element2, Document document2, List<InsightRange> out) {
        InsightRange insightRange = new InsightRange(document2.getLineNumber(element2.getTextRange().getStartOffset()), document2.getLineNumber(element2.getTextRange().getEndOffset()));
        out.add(insightRange);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isNearCommentOrDocstring(Document document2, PsiElement element2) {
        boolean bl;
        block4: {
            void $this$any$iv;
            PsiFile file2 = element2.getContainingFile();
            Language language = file2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            InsightLanguageKit insightLanguageKit = InsightLanguageKit.Companion.get(language);
            if (insightLanguageKit == null) {
                return false;
            }
            InsightLanguageKit languageKit = insightLanguageKit;
            int firstLine = document2.getLineNumber(element2.getTextRange().getStartOffset());
            int beforeFirstLine = RangesKt.coerceAtLeast((int)(firstLine - 1), (int)0);
            int afterFirstLine = RangesKt.coerceAtMost((int)(firstLine + 1), (int)(document2.getLineCount() - 1));
            TextRange firstLineRange = new TextRange(document2.getLineStartOffset(beforeFirstLine), document2.getLineEndOffset(afterFirstLine));
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file2)).onRange(firstLineRange);
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"onRange(...)");
            Iterable iterable = (Iterable)syntaxTraverser;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!languageKit.isCommentOrDocstring(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected abstract int pointsForCurrent(@NotNull PsiElement var1);

    protected abstract boolean canBeTerminal(@NotNull PsiElement var1);

    static {
        Companion $this$thisInsightLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisInsightLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new InsightEventReporter(logger);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/daemon/insight/kit/InsightLogBlockRangeHeuristicsBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/daemon/insight/InsightEventReporter;", "intellij.ml.llm.daemon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

