/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.rating;

import com.intellij.ml.llm.daemon.insight.InsightEventListener;
import com.intellij.ml.llm.daemon.insight.InsightEventReporter;
import com.intellij.ml.llm.daemon.insight.InsightsBundle;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000  2\u00020\u0001:\u0004\u001d\u001e\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000bJ5\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "ratings", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$Rating;", "getRating", "insight", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "addRating", "", "rating", "rateFinished", "editor", "Lcom/intellij/openapi/editor/Editor;", "likeReason", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$LikeReason;", "dislikeReason", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$DislikeReason;", "textFeedback", "", "rateFinished$intellij_ml_llm_daemon", "getLastCommitHash", "Rating", "LikeReason", "DislikeReason", "Companion", "intellij.ml.llm.daemon"})
public final class InsightRating {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ConcurrentHashMap<Long, Rating> ratings;

    public InsightRating(@NotNull Project project2, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project2;
        this.cs = cs;
        this.ratings = new ConcurrentHashMap();
    }

    @Nullable
    public final Rating getRating(@NotNull InsightModel insight) {
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        return this.ratings.get(insight.getId());
    }

    public final void addRating(@NotNull InsightModel insight, @NotNull Rating rating) {
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        ((Map)this.ratings).put(insight.getId(), rating);
    }

    public final void rateFinished$intellij_ml_llm_daemon(@NotNull Editor editor2, @NotNull InsightModel insight, @NotNull LikeReason likeReason, @NotNull DislikeReason dislikeReason, @NotNull String textFeedback) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        Intrinsics.checkNotNullParameter((Object)((Object)likeReason), (String)"likeReason");
        Intrinsics.checkNotNullParameter((Object)((Object)dislikeReason), (String)"dislikeReason");
        Intrinsics.checkNotNullParameter((Object)textFeedback, (String)"textFeedback");
        String string = editor2.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text2 = string;
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editor2, insight, text2, likeReason, dislikeReason, textFeedback, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ InsightRating this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ InsightModel $insight;
            final /* synthetic */ String $text;
            final /* synthetic */ LikeReason $likeReason;
            final /* synthetic */ DislikeReason $dislikeReason;
            final /* synthetic */ String $textFeedback;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$insight = $insight;
                this.$text = $text;
                this.$likeReason = $likeReason;
                this.$dislikeReason = $dislikeReason;
                this.$textFeedback = $textFeedback;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        String string = InsightRating.access$getLastCommitHash(this.this$0, InsightRating.access$getProject$p(this.this$0), this.$editor);
                        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(this.$editor.getDocument());
                        String string2 = virtualFile2 != null ? virtualFile2.getPath() : null;
                        Rating rating = this.this$0.getRating(this.$insight);
                        Intrinsics.checkNotNull((Object)((Object)rating));
                        InsightEventListener.Rated rated = new InsightEventListener.Rated(string, this.$insight, string2, this.$text, rating, this.$likeReason, this.$dislikeReason, this.$textFeedback);
                        void $this$thisInsightLogger$iv = $this$launch;
                        boolean $i$f$thisInsightLogger = false;
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(CoroutineScope.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        new InsightEventReporter(logger).fire(rated);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final String getLastCommitHash(Project project2, Editor editor2) {
        VirtualFile virtualFile2 = editor2.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager((Project)project2).getRepositoryForFileQuick(virtualFile3);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository = gitRepository;
        return repository.getCurrentRevision();
    }

    public static final /* synthetic */ String access$getLastCommitHash(InsightRating $this, Project project2, Editor editor2) {
        return $this.getLastCommitHash(project2, editor2);
    }

    public static final /* synthetic */ Project access$getProject$p(InsightRating $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightRating.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightRating.kt\ncom/intellij/ml/llm/daemon/insight/rating/InsightRating$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,78:1\n30#2,2:79\n*S KotlinDebug\n*F\n+ 1 InsightRating.kt\ncom/intellij/ml/llm/daemon/insight/rating/InsightRating$Companion\n*L\n76#1:79,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InsightRating getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<InsightRating> serviceClass$iv = InsightRating.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (InsightRating)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$DislikeReason;", "", "text", "", "show", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getText", "()Ljava/lang/String;", "getShow", "()Z", "UNKNOWN", "TRIVIAL_OBVIOUS", "PARAPHRASES_CODE", "OTHER", "intellij.ml.llm.daemon"})
    public static final class DislikeReason
    extends Enum<DislikeReason> {
        @NotNull
        private final String text;
        private final boolean show;
        public static final /* enum */ DislikeReason UNKNOWN = new DislikeReason(InsightsBundle.message("feedback.reason.unknown", new Object[0]), false);
        public static final /* enum */ DislikeReason TRIVIAL_OBVIOUS = new DislikeReason("TRIVIAL_OBVIOUS", 1, InsightsBundle.message("feedback.reason.trivial", new Object[0]), false, 2, null);
        public static final /* enum */ DislikeReason PARAPHRASES_CODE = new DislikeReason("PARAPHRASES_CODE", 2, InsightsBundle.message("feedback.reason.paraphrases.code", new Object[0]), false, 2, null);
        public static final /* enum */ DislikeReason OTHER = new DislikeReason("OTHER", 3, InsightsBundle.message("feedback.reason.other", new Object[0]), false, 2, null);
        private static final /* synthetic */ DislikeReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DislikeReason(String text2, boolean show2) {
            this.text = text2;
            this.show = show2;
        }

        /* synthetic */ DislikeReason(String string, int n, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = true;
            }
            this(string2, bl);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean getShow() {
            return this.show;
        }

        public static DislikeReason[] values() {
            return (DislikeReason[])$VALUES.clone();
        }

        public static DislikeReason valueOf(String value) {
            return Enum.valueOf(DislikeReason.class, value);
        }

        @NotNull
        public static EnumEntries<DislikeReason> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dislikeReasonArray = new DislikeReason[]{DislikeReason.UNKNOWN, DislikeReason.TRIVIAL_OBVIOUS, DislikeReason.PARAPHRASES_CODE, DislikeReason.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$LikeReason;", "", "text", "", "show", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getText", "()Ljava/lang/String;", "getShow", "()Z", "UNKNOWN", "PIN_POINT_ACCURACY", "ACTIONABLE_SUGGESTION", "NON_OBVIOUS_DISCOVERY", "LEARNING_VALUE", "CONCISE_READABLE", "OTHER", "intellij.ml.llm.daemon"})
    public static final class LikeReason
    extends Enum<LikeReason> {
        @NotNull
        private final String text;
        private final boolean show;
        public static final /* enum */ LikeReason UNKNOWN = new LikeReason(InsightsBundle.message("feedback.reason.unknown", new Object[0]), false);
        public static final /* enum */ LikeReason PIN_POINT_ACCURACY = new LikeReason("PIN_POINT_ACCURACY", 1, InsightsBundle.message("feedback.reason.pin.point.accuracy", new Object[0]), false, 2, null);
        public static final /* enum */ LikeReason ACTIONABLE_SUGGESTION = new LikeReason("ACTIONABLE_SUGGESTION", 2, InsightsBundle.message("feedback.reason.actionable.suggestion", new Object[0]), false, 2, null);
        public static final /* enum */ LikeReason NON_OBVIOUS_DISCOVERY = new LikeReason("NON_OBVIOUS_DISCOVERY", 3, InsightsBundle.message("feedback.reason.non.obvious.discovery", new Object[0]), false, 2, null);
        public static final /* enum */ LikeReason LEARNING_VALUE = new LikeReason("LEARNING_VALUE", 4, InsightsBundle.message("feedback.reason.learning.value", new Object[0]), false, 2, null);
        public static final /* enum */ LikeReason CONCISE_READABLE = new LikeReason("CONCISE_READABLE", 5, InsightsBundle.message("feedback.reason.concise.readable", new Object[0]), false, 2, null);
        public static final /* enum */ LikeReason OTHER = new LikeReason("OTHER", 6, InsightsBundle.message("feedback.reason.other", new Object[0]), false, 2, null);
        private static final /* synthetic */ LikeReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private LikeReason(String text2, boolean show2) {
            this.text = text2;
            this.show = show2;
        }

        /* synthetic */ LikeReason(String string, int n, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = true;
            }
            this(string2, bl);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean getShow() {
            return this.show;
        }

        public static LikeReason[] values() {
            return (LikeReason[])$VALUES.clone();
        }

        public static LikeReason valueOf(String value) {
            return Enum.valueOf(LikeReason.class, value);
        }

        @NotNull
        public static EnumEntries<LikeReason> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = likeReasonArray = new LikeReason[]{LikeReason.UNKNOWN, LikeReason.PIN_POINT_ACCURACY, LikeReason.ACTIONABLE_SUGGESTION, LikeReason.NON_OBVIOUS_DISCOVERY, LikeReason.LEARNING_VALUE, LikeReason.CONCISE_READABLE, LikeReason.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$Rating;", "", "<init>", "(Ljava/lang/String;I)V", "LIKE", "DISLIKE", "intellij.ml.llm.daemon"})
    public static final class Rating
    extends Enum<Rating> {
        public static final /* enum */ Rating LIKE = new Rating();
        public static final /* enum */ Rating DISLIKE = new Rating();
        private static final /* synthetic */ Rating[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Rating[] values() {
            return (Rating[])$VALUES.clone();
        }

        public static Rating valueOf(String value) {
            return Enum.valueOf(Rating.class, value);
        }

        @NotNull
        public static EnumEntries<Rating> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = ratingArray = new Rating[]{Rating.LIKE, Rating.DISLIKE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

