/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.settings;

import com.intellij.ml.llm.core.settings.LLMAIWorkflowsConfigurableKt;
import com.intellij.ml.llm.core.settings.SettingsSources;
import com.intellij.ml.llm.daemon.insight.InsightsBundle;
import com.intellij.ml.llm.daemon.insight.handler.provider.InsightsProvider;
import com.intellij.ml.llm.daemon.insight.handler.provider.LogBlockRangesService;
import com.intellij.ml.llm.daemon.insight.kit.InsightLanguageKit;
import com.intellij.ml.llm.daemon.insight.logs.InsightsFUSCollector;
import com.intellij.ml.llm.daemon.insight.settings.InsightSettingsManager;
import com.intellij.ml.llm.daemon.insight.settings.InsightsFrequency;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/daemon/insight/settings/InsightConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "createPanel", "logEnabledChanged", "", "enabled", "", "logFrequencyChanged", "frequency", "Lcom/intellij/ml/llm/daemon/insight/settings/InsightsFrequency;", "notAvailable", "Lcom/intellij/ui/dsl/builder/Row;", "Lcom/intellij/ui/dsl/builder/Panel;", "cause", "", "clearCache", "isModified", "apply", "disposeUIResources", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightConfigurable.kt\ncom/intellij/ml/llm/daemon/insight/settings/InsightConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n1#2:119\n13#3:120\n*S KotlinDebug\n*F\n+ 1 InsightConfigurable.kt\ncom/intellij/ml/llm/daemon/insight/settings/InsightConfigurable\n*L\n115#1:120\n*E\n"})
final class InsightConfigurable
extends BoundConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private DialogPanel panel;
    @NotNull
    private static final Logger LOG;

    public InsightConfigurable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(InsightsBundle.message("insight.settings.display.name", new Object[0]), null, 2, null);
        this.project = project2;
    }

    @NotNull
    public DialogPanel createPanel() {
        DialogPanel newPanel2;
        InsightSettingsManager insightSettings = InsightSettingsManager.Companion.getInstance();
        Ref.ObjectRef checkbox = new Ref.ObjectRef();
        this.panel = newPanel2 = com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> InsightConfigurable.createPanel$lambda$0(this, checkbox, insightSettings, arg_0));
        return newPanel2;
    }

    private final void logEnabledChanged(boolean enabled) {
        SettingsSources settingsSources = (SettingsSources)this.project.getUserData(LLMAIWorkflowsConfigurableKt.getSETTINGS_NAVIGATION_SOURCE());
        if (settingsSources == null) {
            settingsSources = SettingsSources.REGULAR_SETTINGS;
        }
        SettingsSources source = settingsSources;
        InsightsFUSCollector.INSTANCE.logEnabledChanged(enabled, source);
    }

    private final void logFrequencyChanged(InsightsFrequency frequency) {
        SettingsSources settingsSources = (SettingsSources)this.project.getUserData(LLMAIWorkflowsConfigurableKt.getSETTINGS_NAVIGATION_SOURCE());
        if (settingsSources == null) {
            settingsSources = SettingsSources.REGULAR_SETTINGS;
        }
        SettingsSources source = settingsSources;
        InsightsFUSCollector.INSTANCE.logFrequencyChanged(frequency, source);
    }

    private final Row notAvailable(Panel $this$notAvailable, String cause) {
        return Panel.row$default((Panel)$this$notAvailable, null, arg_0 -> InsightConfigurable.notAvailable$lambda$0(cause, arg_0), (int)1, null);
    }

    private final void clearCache() {
        LogBlockRangesService.Companion.getInstance(this.project).resetCaches();
        InsightsProvider.Companion.getInstance(this.project).clearCaches$intellij_ml_llm_daemon();
    }

    public boolean isModified() {
        DialogPanel dialogPanel = this.panel;
        return dialogPanel != null ? dialogPanel.isModified() : false;
    }

    public void apply() {
        block0: {
            DialogPanel dialogPanel = this.panel;
            if (dialogPanel == null) break block0;
            dialogPanel.apply();
        }
    }

    public void disposeUIResources() {
        this.panel = null;
    }

    private static final Unit createPanel$lambda$0(InsightConfigurable this$0, Ref.ObjectRef $checkbox, InsightSettingsManager $insightSettings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)InsightsBundle.message("insight.settings.display.name", new Object[0]), (boolean)false, arg_0 -> InsightConfigurable.createPanel$lambda$0$0(this$0, $checkbox, $insightSettings, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(InsightConfigurable this$0, Ref.ObjectRef $checkbox, InsightSettingsManager $insightSettings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        List<InsightLanguageKit> langs = InsightLanguageKit.Companion.all();
        if (langs.isEmpty()) {
            this$0.notAvailable($this$group, "No supported languages installed");
            return Unit.INSTANCE;
        }
        Panel.row$default((Panel)$this$group, null, arg_0 -> InsightConfigurable.createPanel$lambda$0$0$0($checkbox, $insightSettings, this$0, arg_0), (int)1, null).topGap(TopGap.SMALL);
        $this$group.indent(arg_0 -> InsightConfigurable.createPanel$lambda$0$0$1($checkbox, $insightSettings, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$0(Ref.ObjectRef $checkbox, InsightSettingsManager $insightSettings, InsightConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $checkbox.element = Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(InsightsBundle.message("insight.settings.enabled", new Object[0])), (Function0)((Function0)new Function0<Boolean>((Object)$insightSettings){

            public final Boolean invoke() {
                return ((InsightSettingsManager)this.receiver).isEnabled();
            }
        }), arg_0 -> InsightConfigurable.createPanel$lambda$0$0$0$0($insightSettings, this$0, arg_0)), (String)InsightsBundle.message("insight.settings.comment", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$0$0(InsightSettingsManager $insightSettings, InsightConfigurable this$0, boolean enabled) {
        boolean oldValue = $insightSettings.isEnabled();
        $insightSettings.setEnabled(enabled);
        if (oldValue != enabled) {
            this$0.logEnabledChanged(enabled);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$1(Ref.ObjectRef $checkbox, InsightSettingsManager $insightSettings, InsightConfigurable this$0, Panel $this$indent) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Row row = $this$indent.row(InsightsBundle.message("insight.settings.frequency.comment", new Object[0]), arg_0 -> InsightConfigurable.createPanel$lambda$0$0$1$0($insightSettings, this$0, arg_0));
        if ($checkbox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkbox");
            cell = null;
        } else {
            cell = (Cell)$checkbox.element;
        }
        row.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$1$0(InsightSettingsManager $insightSettings, InsightConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)InsightsFrequency.getEntries(), BuilderKt.textListCellRenderer(InsightConfigurable::createPanel$lambda$0$0$1$0$0)), () -> InsightConfigurable.createPanel$lambda$0$0$1$0$1($insightSettings), arg_0 -> InsightConfigurable.createPanel$lambda$0$0$1$0$2($insightSettings, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$0$0$1$0$0(InsightsFrequency frequency) {
        InsightsFrequency insightsFrequency = frequency;
        return insightsFrequency != null ? insightsFrequency.getDisplayName() : null;
    }

    private static final InsightsFrequency createPanel$lambda$0$0$1$0$1(InsightSettingsManager $insightSettings) {
        return $insightSettings.getFrequency();
    }

    private static final Unit createPanel$lambda$0$0$1$0$2(InsightSettingsManager $insightSettings, InsightConfigurable this$0, InsightsFrequency frequency) {
        if (frequency == null) {
            return Unit.INSTANCE;
        }
        InsightsFrequency oldValue = $insightSettings.getFrequency();
        $insightSettings.setFrequency(frequency);
        if (oldValue != frequency) {
            this$0.logFrequencyChanged(frequency);
            this$0.clearCache();
        }
        return Unit.INSTANCE;
    }

    private static final Unit notAvailable$lambda$0(String $cause, Row $this$row) {
        Object object;
        Logger logger;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                logger = LOG;
                object = $cause;
                if (object == null) break block2;
                String string = object;
                Logger logger2 = logger;
                boolean bl = false;
                String string2 = ", cause: " + $cause + ".";
                logger = logger2;
                object = string2;
                if (string2 != null) break block3;
            }
            object = "";
        }
        logger.info("Settings are not available" + (String)object);
        Row.comment$default((Row)$this$row, (String)InsightsBundle.message("insight.settings.not.available", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InsightConfigurable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/daemon/insight/settings/InsightConfigurable$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.daemon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

