/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.ml.llm.core.settings.LLMAIWorkflowsConfigurable;
import com.intellij.ml.llm.core.settings.LLMAIWorkflowsConfigurableKt;
import com.intellij.ml.llm.core.settings.SettingsSources;
import com.intellij.ml.llm.daemon.MLLlmDaemonIcons;
import com.intellij.ml.llm.daemon.insight.InsightEventListener;
import com.intellij.ml.llm.daemon.insight.InsightEventReporter;
import com.intellij.ml.llm.daemon.insight.InsightsBundle;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.handler.provider.postprocessing.InsightsHiddenCache;
import com.intellij.ml.llm.daemon.insight.kit.InsightLanguageKit;
import com.intellij.ml.llm.daemon.insight.ui.HeaderListPopup;
import com.intellij.ml.llm.daemon.insight.ui.InsightMenu;
import com.intellij.ml.llm.daemon.insight.ui.InsightMenuScopeService;
import com.intellij.ml.llm.daemon.insight.ui.InsightRenderer;
import com.intellij.ml.llm.feedbackForm.AIAssistantFeedbackDialogKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\u000e\u0010\u0012\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u0010\u0013J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightMenu;", "", "position", "Ljava/awt/Point;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "insight", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Ljava/awt/Point;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;Lcom/intellij/openapi/Disposable;)V", "show", "", "hideInsight", "copyInsightToClipboard", "openFeedbackForm", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertInsightToComment", "insertInsightAsDocstring", "psiFile", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "elemToAttachDocstring", "Lcom/intellij/psi/PsiElement;", "insertInsightAsRegularComment", "navigateToInsightSettings", "findFunctionInRange", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightMenu.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightMenu\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 InsightEventDispatcher.kt\ncom/intellij/ml/llm/daemon/insight/InsightEventDispatcherKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,198:1\n648#2,5:199\n648#2,5:204\n123#3:209\n112#3,5:210\n295#4,2:215\n29#5:217\n13#6:218\n*S KotlinDebug\n*F\n+ 1 InsightMenu.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightMenu\n*L\n119#1:199,5\n138#1:204,5\n140#1:209\n140#1:210,5\n178#1:215,2\n189#1:217\n189#1:218\n*E\n"})
public final class InsightMenu {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Point position;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final InsightModel insight;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private static final InsightEventReporter LOG;

    public InsightMenu(@NotNull Point position, @NotNull Editor editor2, @NotNull Project project2, @NotNull InsightModel insight, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.position = position;
        this.editor = editor2;
        this.project = project2;
        this.insight = insight;
        this.parentDisposable = parentDisposable;
    }

    @RequiresEdt
    public final void show() {
        Object[] objectArray = new HeaderListPopup.MenuItem[5];
        String string = InsightsBundle.message("insight.settings.display.name", new Object[0]);
        Icon icon2 = AllIcons.General.Beta;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Beta");
        objectArray[0] = new HeaderListPopup.HeaderItem(string, icon2);
        String string2 = InsightsBundle.message("insight.menu.copy.insight", new Object[0]);
        Icon icon3 = MLLlmDaemonIcons.CopyInsight;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"CopyInsight");
        objectArray[1] = new HeaderListPopup.ActionItem(string2, icon3, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>((Object)this){

            public final Object invoke(Continuation<? super Unit> $completion) {
                return InsightMenu.access$show$copyInsightToClipboard((InsightMenu)this.receiver, $completion);
            }
        }));
        String string3 = InsightsBundle.message("insight.menu.convert.to.comment", new Object[0]);
        Icon icon4 = MLLlmDaemonIcons.ConvertToComment;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ConvertToComment");
        objectArray[2] = new HeaderListPopup.ActionItem(string3, icon4, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ InsightMenu this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = InsightMenu.access$convertInsightToComment(this.this$0, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        String string4 = InsightsBundle.message("insight.menu.provide.feedback", new Object[0]);
        Icon icon5 = AllIcons.Ide.Feedback;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Feedback");
        objectArray[3] = new HeaderListPopup.ActionItem(string4, icon5, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>((Object)this){

            public final Object invoke(Continuation<? super Unit> $completion) {
                return InsightMenu.access$openFeedbackForm((InsightMenu)this.receiver, $completion);
            }
        }));
        String string5 = InsightsBundle.message("insight.menu.settings.insight", new Object[0]);
        Icon icon6 = AllIcons.General.GearPlain;
        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"GearPlain");
        objectArray[4] = new HeaderListPopup.ActionItem(string5, icon6, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>((Object)this){

            public final Object invoke(Continuation<? super Unit> $completion) {
                return InsightMenu.access$show$navigateToInsightSettings((InsightMenu)this.receiver, $completion);
            }
        }));
        List items2 = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new Integer[]{-2};
        ListPopup popup2 = HeaderListPopup.INSTANCE.createPopup(this.project, items2, SetsKt.mutableSetOf((Object[])objectArray2), InsightMenuScopeService.Companion.getInstance(this.project).getScope());
        Disposer.register((Disposable)this.parentDisposable, () -> InsightMenu.show$lambda$0(popup2));
        popup2.show(new RelativePoint((Component)this.editor.getContentComponent(), this.position));
    }

    private final void hideInsight() {
        Project project2 = this.editor.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        InsightsHiddenCache insightsHiddenCache = InsightsHiddenCache.Companion.getInstance(project3);
        Document document2 = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        insightsHiddenCache.hide(this.insight, document2);
        InsightRenderer insightRenderer = InsightRenderer.Companion.getOrNull(this.editor);
        if (insightRenderer != null) {
            insightRenderer.hideInsight(this.insight.getId());
        }
        LOG.fire(new InsightEventListener.Hidden(this.insight));
    }

    private final void copyInsightToClipboard() {
        String text2 = this.insight.getText();
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
        LOG.fire(new InsightEventListener.Copied(this.insight));
    }

    private final Object openFeedbackForm(Continuation<? super Unit> $completion) {
        AIAssistantFeedbackDialogKt.showAIAssistantFeedbackDialog$default((Project)this.project, (String)"insight_menu", null, (int)4, null);
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object convertInsightToComment(Continuation<? super Unit> $completion) {
        if (!($completion instanceof convertInsightToComment.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ InsightMenu this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return InsightMenu.access$convertInsightToComment(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.editor.getProject();
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                project = v0;
                v1 = this.editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDocument(...)");
                document = v1;
                v2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                if (v2 == null) {
                    return Unit.INSTANCE;
                }
                psiFile = v2;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = document;
                $continuation.L$2 = psiFile;
                $continuation.label = 1;
                v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PsiElement>, Object>(this, psiFile, document, null){
                    int label;
                    final /* synthetic */ InsightMenu this$0;
                    final /* synthetic */ PsiFile $psiFile;
                    final /* synthetic */ Document $document;
                    {
                        this.this$0 = $receiver;
                        this.$psiFile = $psiFile;
                        this.$document = $document;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = CoroutinesKt.readAction(() -> convertInsightToComment.functionBodyElem.1.invokeSuspend$lambda$0(this.this$0, this.$psiFile, this.$document), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super PsiElement> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final PsiElement invokeSuspend$lambda$0(InsightMenu this$0, PsiFile $psiFile, Document $document) {
                        return InsightMenu.access$findFunctionInRange(this$0, $psiFile, $document, InsightMenu.access$getInsight$p(this$0));
                    }
                }), (Continuation)$continuation);
                if (v3 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl37
            }
            case 1: {
                psiFile = (PsiFile)$continuation.L$2;
                document = (Document)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl37:
                // 2 sources

                if ((functionBodyElem = (PsiElement)v3) != null) {
                    this.insertInsightAsDocstring(psiFile, document, functionBodyElem);
                } else {
                    this.insertInsightAsRegularComment(psiFile, document);
                }
                v4 = InsightRenderer.Companion.getOrNull(this.editor);
                if (v4 != null) {
                    v4.hideInsight(this.insight.getId());
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void insertInsightAsDocstring(PsiFile psiFile, Document document2, PsiElement elemToAttachDocstring) {
        String string;
        InsightLanguageKit languageKit;
        block2: {
            Language language = psiFile.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            InsightLanguageKit insightLanguageKit = InsightLanguageKit.Companion.get(language);
            if (insightLanguageKit == null) {
                return;
            }
            languageKit = insightLanguageKit;
            String $this$takeWhile$iv = this.insight.getText();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block2;
            }
            string = $this$takeWhile$iv;
        }
        String insightIndent = string;
        String docstring = languageKit.generateDocstring(((Object)StringsKt.trimStart((CharSequence)this.insight.getText())).toString(), insightIndent, psiFile);
        int insertionLine = document2.getLineNumber(elemToAttachDocstring.getTextRange().getStartOffset());
        int offset = document2.getLineStartOffset(insertionLine);
        WriteCommandAction.writeCommandAction((PsiFile)psiFile, (PsiFile[])new PsiFile[0]).run(() -> InsightMenu.insertInsightAsDocstring$lambda$1(document2, offset, docstring));
        LOG.fire(new InsightEventListener.InsertedAsComment(this.insight, InsightEventListener.InsertedAsComment.CommentType.DOCSTRING));
    }

    /*
     * WARNING - void declaration
     */
    private final void insertInsightAsRegularComment(PsiFile psiFile, Document document2) {
        String string;
        int n;
        String $this$takeWhile$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$insertInsightAsRegularComment_u24lambda_u240;
        StringBuilder stringBuilder2;
        String blockSuffix;
        String blockPrefix;
        String linePrefix;
        block7: {
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(psiFile.getLanguage());
            Commenter commenter2 = commenter;
            String string2 = commenter2 != null ? commenter2.getLineCommentPrefix() : null;
            if (string2 == null) {
                string2 = "";
            }
            linePrefix = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            Commenter commenter3 = commenter;
            String string3 = commenter3 != null ? commenter3.getBlockCommentPrefix() : null;
            if (string3 == null) {
                string3 = "";
            }
            blockPrefix = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            Commenter commenter4 = commenter;
            String string4 = commenter4 != null ? commenter4.getBlockCommentSuffix() : null;
            if (string4 == null) {
                string4 = "";
            }
            blockSuffix = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            $this$insertInsightAsRegularComment_u24lambda_u240 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            String string5 = this.insight.getText();
            stringBuilder = $this$insertInsightAsRegularComment_u24lambda_u240;
            boolean $i$f$takeWhile = false;
            int n2 = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it22 = $this$takeWhile$iv.charAt(index$iv);
                boolean bl2 = false;
                if (CharsKt.isWhitespace((char)it22)) continue;
                void it22 = $this$takeWhile$iv;
                n = 0;
                String string6 = it22.substring(n, index$iv);
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                break block7;
            }
            string = $this$takeWhile$iv;
        }
        stringBuilder.append(string);
        if (!StringsKt.isBlank((CharSequence)linePrefix)) {
            CharSequence charSequence;
            block8: {
                void $this$trimStart$iv;
                $this$takeWhile$iv = this.insight.getText();
                stringBuilder = $this$insertInsightAsRegularComment_u24lambda_u240.append(linePrefix).append(' ');
                boolean $i$f$trimStart = false;
                CharSequence $this$trimStart$iv$iv = (CharSequence)$this$trimStart$iv;
                boolean $i$f$trimStart2 = false;
                n = $this$trimStart$iv$iv.length();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (CharsKt.isWhitespace((char)it)) continue;
                    charSequence = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                    break block8;
                }
                charSequence = "";
            }
            v9 = stringBuilder.append(((Object)charSequence).toString()).append('\n');
        } else {
            v9 = $this$insertInsightAsRegularComment_u24lambda_u240.append(blockPrefix).append(' ').append(this.insight.getText()).append(' ').append(blockSuffix).append('\n');
        }
        String commentedText = stringBuilder2.toString();
        WriteCommandAction.writeCommandAction((PsiFile)psiFile, (PsiFile[])new PsiFile[0]).run(() -> InsightMenu.insertInsightAsRegularComment$lambda$1(document2, this, commentedText));
        LOG.fire(new InsightEventListener.InsertedAsComment(this.insight, InsightEventListener.InsertedAsComment.CommentType.COMMENT));
    }

    private final void navigateToInsightSettings() {
        Project project2 = this.editor.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        ApplicationManager.getApplication().invokeLater(() -> InsightMenu.navigateToInsightSettings$lambda$0(project3));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @RequiresReadLock
    private final PsiElement findFunctionInRange(PsiFile psiFile, Document document2, InsightModel insight) {
        Object v3;
        int insightStartLine;
        InsightLanguageKit languageKit;
        block5: {
            void $this$firstOrNull$iv;
            Language language = psiFile.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            InsightLanguageKit insightLanguageKit = InsightLanguageKit.Companion.get(language);
            if (insightLanguageKit == null) {
                return null;
            }
            languageKit = insightLanguageKit;
            insightStartLine = insight.getRange().getStartLine();
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)psiFile)).onRange(new TextRange(document2.getLineStartOffset(insightStartLine), document2.getLineEndOffset(RangesKt.coerceAtMost((int)(insightStartLine + 1), (int)(document2.getLineCount() - 1)))));
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"onRange(...)");
            Iterable iterable = (Iterable)syntaxTraverser;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!languageKit.isFunction(it)) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        PsiElement psiElement = v3;
        if (psiElement == null) {
            return null;
        }
        PsiElement wholeFunctionElem = psiElement;
        PsiElement psiElement2 = languageKit.getFunctionIdentifier(wholeFunctionElem);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement identifier = psiElement2;
        int functionStartLine = document2.getLineNumber(identifier.getTextRange().getStartOffset());
        if (insightStartLine > functionStartLine) {
            return null;
        }
        return languageKit.getElementToAttachDocstring(wholeFunctionElem);
    }

    private static final /* synthetic */ Object show$copyInsightToClipboard(InsightMenu $this$show_u24copyInsightToClipboard, Continuation $completion) {
        $this$show_u24copyInsightToClipboard.copyInsightToClipboard();
        return Unit.INSTANCE;
    }

    private static final /* synthetic */ Object show$navigateToInsightSettings(InsightMenu $this$show_u24navigateToInsightSettings, Continuation $completion) {
        $this$show_u24navigateToInsightSettings.navigateToInsightSettings();
        return Unit.INSTANCE;
    }

    private static final void show$lambda$0(ListPopup $popup) {
        $popup.cancel();
    }

    private static final void insertInsightAsDocstring$lambda$1(Document $document, int $offset, String $docstring) {
        $document.insertString($offset, (CharSequence)$docstring);
    }

    private static final void insertInsightAsRegularComment$lambda$1(Document $document, InsightMenu this$0, String $commentedText) {
        $document.insertString($document.getLineStartOffset(this$0.insight.getRange().getStartLine()), (CharSequence)$commentedText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void navigateToInsightSettings$lambda$0(Project $project) {
        $project.putUserData(LLMAIWorkflowsConfigurableKt.getSETTINGS_NAVIGATION_SOURCE(), (Object)SettingsSources.POPUP_MENU);
        try {
            ShowSettingsUtil.getInstance().showSettingsDialog($project, LLMAIWorkflowsConfigurable.class);
        }
        finally {
            $project.putUserData(LLMAIWorkflowsConfigurableKt.getSETTINGS_NAVIGATION_SOURCE(), null);
        }
    }

    public static final /* synthetic */ Object access$show$copyInsightToClipboard(InsightMenu $receiver, Continuation $completion) {
        return InsightMenu.show$copyInsightToClipboard($receiver, $completion);
    }

    public static final /* synthetic */ Object access$convertInsightToComment(InsightMenu $this, Continuation $completion) {
        return $this.convertInsightToComment((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$openFeedbackForm(InsightMenu $this, Continuation $completion) {
        return $this.openFeedbackForm((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$show$navigateToInsightSettings(InsightMenu $receiver, Continuation $completion) {
        return InsightMenu.show$navigateToInsightSettings($receiver, $completion);
    }

    public static final /* synthetic */ PsiElement access$findFunctionInRange(InsightMenu $this, PsiFile psiFile, Document document2, InsightModel insight) {
        return $this.findFunctionInRange(psiFile, document2, insight);
    }

    public static final /* synthetic */ InsightModel access$getInsight$p(InsightMenu $this) {
        return $this.insight;
    }

    static {
        Companion $this$thisInsightLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisInsightLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new InsightEventReporter(logger);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightMenu$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/daemon/insight/InsightEventReporter;", "intellij.ml.llm.daemon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

