/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.provenance;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ml.llm.daemon.provenance.AuthorshipInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.annotate.GitAnnotationService;
import git4idea.annotate.GitFileAnnotation;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.repo.GitRepository;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0018\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/daemon/provenance/AnnotationCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/ml/llm/daemon/provenance/AnnotationCache$CacheKey;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lgit4idea/annotate/GitFileAnnotation;", "getAuthorshipInfo", "", "", "Lcom/intellij/ml/llm/daemon/provenance/AuthorshipInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "lines", "", "getAnnotation", "fetchAnnotation", "isFileTrackedInHead", "", "root", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "CacheKey", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightGitBlameService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightGitBlameService.kt\ncom/intellij/ml/llm/daemon/provenance/AnnotationCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,225:1\n1285#2,2:226\n1299#2,4:228\n1285#2,2:232\n1299#2,4:234\n1#3:238\n13#4:239\n*S KotlinDebug\n*F\n+ 1 InsightGitBlameService.kt\ncom/intellij/ml/llm/daemon/provenance/AnnotationCache\n*L\n152#1:226,2\n152#1:228,4\n154#1:232,2\n154#1:234,4\n222#1:239\n*E\n"})
final class AnnotationCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Cache<CacheKey, GitFileAnnotation> cache;
    @NotNull
    private static final Logger LOG;

    public AnnotationCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Cache cache = Caffeine.newBuilder().maximumSize(20L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, AuthorshipInfo> getAuthorshipInfo(@NotNull VirtualFile file2, @NotNull Document document2, @NotNull Set<Integer> lines2) {
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter(lines2, (String)"lines");
        GitFileAnnotation gitFileAnnotation = this.getAnnotation(file2, document2);
        if (gitFileAnnotation == null) {
            void $this$associateWithTo$iv$iv2;
            Iterable $this$associateWith$iv = lines2;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv2;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv2 : $this$associateWithTo$iv$iv2) {
                int n = ((Number)element$iv$iv2).intValue();
                Object t = element$iv$iv2;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Object v = null;
                map2.put(t, v);
            }
            return destination$iv$iv;
        }
        GitFileAnnotation annotation = gitFileAnnotation;
        Iterable $this$associateWith$iv = lines2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable result$iv2 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            AuthorshipInfo authorshipInfo;
            void lineNumber;
            int element$iv$iv2 = ((Number)element$iv$iv).intValue();
            Object t = element$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            if (annotation.getLineInfo((int)lineNumber) != null) {
                GitFileAnnotation.LineInfo lineInfo;
                boolean bl2 = false;
                VcsUser vcsUser = lineInfo.getAuthorUser();
                Intrinsics.checkNotNullExpressionValue((Object)vcsUser, (String)"getAuthorUser(...)");
                Date date = lineInfo.getAuthorDate();
                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getAuthorDate(...)");
                authorshipInfo = new AuthorshipInfo(vcsUser, date);
            } else {
                authorshipInfo = null;
            }
            AuthorshipInfo authorshipInfo2 = authorshipInfo;
            map3.put(t, authorshipInfo2);
        }
        return destination$iv$iv;
    }

    private final GitFileAnnotation getAnnotation(VirtualFile file2, Document document2) {
        GitFileAnnotation annotation;
        GitFileAnnotation gitFileAnnotation;
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        CacheKey key = new CacheKey(string, document2.getModificationStamp());
        GitFileAnnotation gitFileAnnotation2 = (GitFileAnnotation)this.cache.getIfPresent((Object)key);
        if (gitFileAnnotation2 != null) {
            GitFileAnnotation it = gitFileAnnotation2;
            boolean bl = false;
            return it;
        }
        GitFileAnnotation gitFileAnnotation3 = this.fetchAnnotation(file2);
        if (gitFileAnnotation3 == null) {
            return null;
        }
        GitFileAnnotation it = gitFileAnnotation = (annotation = gitFileAnnotation3);
        boolean bl = false;
        this.cache.put((Object)key, (Object)it);
        return gitFileAnnotation;
    }

    private final GitFileAnnotation fetchAnnotation(VirtualFile file2) {
        GitFileAnnotation gitFileAnnotation;
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager((Project)this.project).getRepositoryForFileQuick(file2);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository = gitRepository;
        VirtualFile virtualFile2 = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
        VirtualFile root = virtualFile2;
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath filePath2 = filePath;
        if (!this.isFileTrackedInHead(root, filePath2, file2)) {
            return null;
        }
        try {
            CoroutineScope coroutineScope = repository.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
            gitFileAnnotation = new GitAnnotationService(this.project, coroutineScope).annotate(root, filePath2, null, file2);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Unexpected error getting git annotation for " + file2.getPath(), (Throwable)e);
            gitFileAnnotation = null;
        }
        return gitFileAnnotation;
    }

    private final boolean isFileTrackedInHead(VirtualFile root, FilePath filePath, VirtualFile file2) {
        List list;
        try {
            list = GitIndexStatusUtilKt.getStatus((Project)this.project, (VirtualFile)root, (List)CollectionsKt.listOf((Object)filePath), (boolean)false, (boolean)true, (boolean)false);
        }
        catch (VcsException e) {
            LOG.debug("Could not get git status for " + file2.getPath(), (Throwable)e);
            return false;
        }
        List statusList = list;
        GitFileStatus fileStatus = (GitFileStatus)CollectionsKt.firstOrNull((List)statusList);
        if (fileStatus == null) {
            LOG.debug("File " + file2.getPath() + " has no git status (cleanly tracked), proceeding with annotation");
            return true;
        }
        if (!GitFileStatusKt.has((GitFileStatus)fileStatus, (ContentVersion)ContentVersion.HEAD)) {
            LOG.debug("File " + file2.getPath() + " is not in git HEAD (new/untracked file), skipping annotation");
            return false;
        }
        return true;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AnnotationCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/daemon/provenance/AnnotationCache$CacheKey;", "", "filePath", "", "modificationStamp", "", "<init>", "(Ljava/lang/String;J)V", "getFilePath", "()Ljava/lang/String;", "getModificationStamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.daemon"})
    private static final class CacheKey {
        @NotNull
        private final String filePath;
        private final long modificationStamp;

        public CacheKey(@NotNull String filePath, long modificationStamp) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.filePath = filePath;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        public final long component2() {
            return this.modificationStamp;
        }

        @NotNull
        public final CacheKey copy(@NotNull String filePath, long modificationStamp) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return new CacheKey(filePath, modificationStamp);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = cacheKey.filePath;
            }
            if ((n & 2) != 0) {
                l = cacheKey.modificationStamp;
            }
            return cacheKey.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "CacheKey(filePath=" + this.filePath + ", modificationStamp=" + this.modificationStamp + ")";
        }

        public int hashCode() {
            int result2 = this.filePath.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.modificationStamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)cacheKey.filePath)) {
                return false;
            }
            return this.modificationStamp == cacheKey.modificationStamp;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/daemon/provenance/AnnotationCache$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.daemon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

