/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.provenance;

import com.intellij.ml.llm.daemon.provenance.AnnotationCache;
import com.intellij.ml.llm.daemon.provenance.AuthorshipInfo;
import com.intellij.ml.llm.daemon.provenance.GitContext;
import com.intellij.ml.llm.daemon.provenance.InsightAuthorshipConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsUser;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rJ*\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/daemon/provenance/InsightGitBlameService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "annotationCache", "Lcom/intellij/ml/llm/daemon/provenance/AnnotationCache;", "fetchBlame", "", "", "Lcom/intellij/ml/llm/daemon/provenance/AuthorshipInfo;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "editorLines", "", "computeAuthorshipCutoff", "Ljava/time/Instant;", "getCurrentUser", "Lcom/intellij/vcs/log/VcsUser;", "file", "resolveGitContext", "Lcom/intellij/ml/llm/daemon/provenance/GitContext;", "mapEditorLinesToVcs", "Companion", "intellij.ml.llm.daemon"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInsightGitBlameService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightGitBlameService.kt\ncom/intellij/ml/llm/daemon/provenance/InsightGitBlameService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,225:1\n1285#2,2:226\n1299#2,2:228\n1302#2:231\n1#3:230\n13#4:232\n*S KotlinDebug\n*F\n+ 1 InsightGitBlameService.kt\ncom/intellij/ml/llm/daemon/provenance/InsightGitBlameService\n*L\n78#1:226,2\n78#1:228,2\n78#1:231\n133#1:232\n*E\n"})
public final class InsightGitBlameService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AnnotationCache annotationCache;
    private static final int ABSENT_LINE_NUMBER = -1;
    @NotNull
    private static final Logger LOG;

    public InsightGitBlameService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.annotationCache = new AnnotationCache(this.project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, AuthorshipInfo> fetchBlame(@NotNull VirtualFile virtualFile2, @NotNull Document document2, @NotNull Set<Integer> editorLines) {
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter(editorLines, (String)"editorLines");
        Map<Integer, Integer> editorToVcsLine = this.mapEditorLinesToVcs(editorLines, document2);
        Set vcsLines = CollectionsKt.toSet((Iterable)editorToVcsLine.values());
        Map<Integer, AuthorshipInfo> blameByVcsLine = !((Collection)vcsLines).isEmpty() ? this.annotationCache.getAuthorshipInfo(virtualFile2, document2, vcsLines) : MapsKt.emptyMap();
        Iterable $this$associateWith$iv = editorLines;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            AuthorshipInfo authorshipInfo;
            void editorLine;
            int n = ((Number)element$iv$iv).intValue();
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Integer n2 = editorToVcsLine.get((int)editorLine);
            if (n2 != null) {
                int vcsLine = ((Number)n2).intValue();
                boolean bl2 = false;
                authorshipInfo = blameByVcsLine.get(vcsLine);
            } else {
                authorshipInfo = null;
            }
            AuthorshipInfo authorshipInfo2 = authorshipInfo;
            map2.put(t, authorshipInfo2);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final Instant computeAuthorshipCutoff() {
        Instant instant = ZonedDateTime.now().minusDays(InsightAuthorshipConfig.INSTANCE.getThresholdDays()).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return instant;
    }

    @Nullable
    public final VcsUser getCurrentUser(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager((Project)this.project).getRepositoryForFileQuick(file2);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository = gitRepository;
        return GitUserRegistry.getInstance((Project)this.project).getOrReadUser(repository.getRoot());
    }

    @NotNull
    public final GitContext resolveGitContext(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)this.project).getRepositoryForFileQuick(virtualFile2);
        if (repository == null) {
            LOG.debug("File " + virtualFile2.getPath() + " is not in a git repository");
            return new GitContext(false, null);
        }
        VcsUser currentUser = this.getCurrentUser(virtualFile2);
        if (currentUser == null) {
            LOG.debug("Could not determine current git user for " + virtualFile2.getPath());
        }
        return new GitContext(true, currentUser);
    }

    private final Map<Integer, Integer> mapEditorLinesToVcs(Set<Integer> editorLines, Document document2) {
        UpToDateLineNumberProviderImpl lineNumberProvider = new UpToDateLineNumberProviderImpl(document2, this.project);
        Map editorToVcsLine = new LinkedHashMap();
        Iterator<Integer> iterator = editorLines.iterator();
        while (iterator.hasNext()) {
            int vcsLine;
            int line = ((Number)iterator.next()).intValue();
            if (lineNumberProvider.isLineChanged(line) || (vcsLine = lineNumberProvider.getLineNumber(line)) == -1) continue;
            editorToVcsLine.put(line, vcsLine);
        }
        return editorToVcsLine;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InsightGitBlameService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/daemon/provenance/InsightGitBlameService$Companion;", "", "<init>", "()V", "ABSENT_LINE_NUMBER", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ml/llm/daemon/provenance/InsightGitBlameService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightGitBlameService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightGitBlameService.kt\ncom/intellij/ml/llm/daemon/provenance/InsightGitBlameService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,225:1\n30#2,2:226\n*S KotlinDebug\n*F\n+ 1 InsightGitBlameService.kt\ncom/intellij/ml/llm/daemon/provenance/InsightGitBlameService$Companion\n*L\n135#1:226,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InsightGitBlameService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<InsightGitBlameService> serviceClass$iv = InsightGitBlameService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (InsightGitBlameService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

