/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.domains.ide.mappers;

import com.intellij.ml.llm.domains.DomainContext;
import com.intellij.ml.llm.domains.DomainProvider;
import com.intellij.ml.llm.domains.DomainSearchScope;
import com.intellij.ml.llm.domains.context.DomainItemContext;
import com.intellij.ml.llm.domains.ide.DomainContextElementsVisitor;
import com.intellij.ml.llm.domains.ide.DomainsBundle;
import com.intellij.ml.llm.domains.ide.mappers.DomainItemContextMapper;
import com.intellij.ml.llm.domains.ide.mappers.PromptDomainContextMapperKt;
import com.intellij.ml.llm.domains.ide.mappers.YAMLText;
import com.intellij.ml.llm.domains.ide.mappers.YamlDomainContextMapper;
import com.intellij.ml.llm.domains.ide.utils.PsiDomainContext;
import com.intellij.ml.llm.domains.ide.utils.ScopeUtilsKt;
import com.intellij.ml.llm.domains.mapper.DomainContextMapper;
import com.intellij.ml.llm.domains.mapper.LLMDomainMapper;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ml/llm/domains/ide/mappers/PromptDomainContextMapper;", "", "<init>", "()V", "Companion", "intellij.ml.llm.domains.ide"})
public final class PromptDomainContextMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u0002H\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00152\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006J$\u0010%\u001a\u0004\u0018\u00010\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\u0016\u001a\u00020&J$\u0010'\u001a\u0004\u0018\u00010\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\u0016\u001a\u00020&J$\u0010(\u001a\u0004\u0018\u00010\u000f\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\u0016\u001a\u00020&\u00a8\u0006)"}, d2={"Lcom/intellij/ml/llm/domains/ide/mappers/PromptDomainContextMapper$Companion;", "", "<init>", "()V", "map", "", "", "T", "provider", "Lcom/intellij/ml/llm/domains/DomainProvider;", "t", "scope", "Lcom/intellij/ml/llm/domains/DomainSearchScope;", "(Lcom/intellij/ml/llm/domains/DomainProvider;Ljava/lang/Object;Lcom/intellij/ml/llm/domains/DomainSearchScope;)Ljava/util/List;", "itemContext", "Lcom/intellij/ml/llm/domains/context/DomainItemContext;", "message", "exportPropertiesAsString", "psiFile", "Lcom/intellij/psi/PsiFile;", "domainContextsPrompt", "Lcom/intellij/ml/llm/privacy/PSString;", "context", "Lcom/intellij/ml/llm/domains/ide/utils/PsiDomainContext;", "filesContextPrompt", "promptWithDomainContextsYaml", "yaml", "addContextYaml", "", "prompts", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "addContextYamlDescription", "addContextYamlExample", "addAnalysisGuidelinesPrompts", "addUpdateGuidelinesPrompts", "addChainUpdateExample", "promptWithFilesContextsYaml", "getDomainContextsYaml", "Lcom/intellij/ml/llm/domains/DomainContext;", "getFilesContextsYaml", "findAndMapToContext", "intellij.ml.llm.domains.ide"})
    @SourceDebugExtension(value={"SMAP\nPromptDomainContextMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptDomainContextMapper.kt\ncom/intellij/ml/llm/domains/ide/mappers/PromptDomainContextMapper$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n19#2:194\n19#2:195\n1#3:196\n*S KotlinDebug\n*F\n+ 1 PromptDomainContextMapper.kt\ncom/intellij/ml/llm/domains/ide/mappers/PromptDomainContextMapper$Companion\n*L\n26#1:194\n29#1:195\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> List<String> map(@NotNull DomainProvider<T> provider, @NotNull T t, @NotNull DomainSearchScope scope) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            Intrinsics.checkNotNullParameter(t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            if (provider instanceof LLMDomainMapper) {
                DomainProvider<T> $this$asSafely$iv = provider;
                boolean $i$f$asSafely = false;
                DomainProvider<T> domainProvider = $this$asSafely$iv;
                if (!(domainProvider instanceof LLMDomainMapper)) {
                    domainProvider = null;
                }
                LLMDomainMapper lLMDomainMapper = (LLMDomainMapper)((Object)domainProvider);
                List list = lLMDomainMapper != null ? lLMDomainMapper.asPrompt(t, scope) : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
            if (provider instanceof DomainContextMapper) {
                String prompt2;
                DomainProvider<T> $this$asSafely$iv = provider;
                boolean $i$f$asSafely = false;
                DomainProvider<T> domainProvider = $this$asSafely$iv;
                if (!(domainProvider instanceof DomainContextMapper)) {
                    domainProvider = null;
                }
                DomainContextMapper domainContextMapper = (DomainContextMapper)((Object)domainProvider);
                if (domainContextMapper != null) {
                    DomainContextMapper it = domainContextMapper;
                    boolean bl = false;
                    v5 = com.intellij.ml.llm.domains.ide.mappers.PromptDomainContextMapper$Companion.map$default(Companion, it.asContext(t, scope), null, 2, null);
                } else {
                    v5 = prompt2 = null;
                }
                if (prompt2 != null) {
                    return CollectionsKt.listOf(prompt2);
                }
            }
            return CollectionsKt.emptyList();
        }

        @NotNull
        public final String map(@NotNull DomainItemContext itemContext, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)itemContext, (String)"itemContext");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            ArrayList<Object> prompts = new ArrayList<Object>();
            String exportPropertiesAsString = this.exportPropertiesAsString(itemContext);
            prompts.add(message + " " + itemContext.getType() + " described with the following properties: " + exportPropertiesAsString);
            for (DomainItemContext associatedContext : itemContext.getAssociatedContexts()) {
                if (Intrinsics.areEqual((Object)associatedContext, (Object)DomainItemContext.EMPTY)) continue;
                prompts.add(com.intellij.ml.llm.domains.ide.mappers.PromptDomainContextMapper$Companion.map$default(this, associatedContext, null, 2, null));
            }
            for (DomainItemContext usedByContext : itemContext.getDependentContexts()) {
                if (Intrinsics.areEqual((Object)usedByContext, (Object)DomainItemContext.EMPTY)) continue;
                prompts.add(this.map(usedByContext, DomainsBundle.INSTANCE.message("directives.you.must.consider", new Object[0])));
            }
            return CollectionsKt.joinToString$default((Iterable)prompts, (CharSequence)".\n", null, null, (int)0, null, null, (int)62, null);
        }

        public static /* synthetic */ String map$default(Companion companion, DomainItemContext domainItemContext, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = DomainsBundle.INSTANCE.message("directives.you.must.use", new Object[0]);
            }
            return companion.map(domainItemContext, string);
        }

        @NotNull
        public final String exportPropertiesAsString(@NotNull DomainItemContext itemContext) {
            Intrinsics.checkNotNullParameter((Object)itemContext, (String)"itemContext");
            return CollectionsKt.joinToString$default((Iterable)DomainItemContextMapper.Companion.exportPropertiesMap$default(DomainItemContextMapper.Companion, itemContext, false, 2, null).entrySet(), (CharSequence)",", null, null, (int)0, null, Companion::exportPropertiesAsString$lambda$0, (int)30, null);
        }

        @RequiresReadLock
        @NotNull
        public final List<String> map(@NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            if (!psiFile.isValid()) {
                return CollectionsKt.emptyList();
            }
            ArrayList items2 = new ArrayList();
            DomainSearchScope scope = ScopeUtilsKt.createScope((PsiElement)psiFile);
            DomainContextElementsVisitor.Companion.visitContextElements(psiFile, (Function1<? super PsiElement, Unit>)((Function1)arg_0 -> Companion.map$lambda$1(scope, items2, arg_0)));
            return items2;
        }

        private final PSString domainContextsPrompt(DomainProvider<?> provider, PsiDomainContext context2) {
            String yamlContext = this.getDomainContextsYaml(provider, context2);
            return this.promptWithDomainContextsYaml(yamlContext);
        }

        private final PSString filesContextPrompt(DomainProvider<?> provider, PsiDomainContext context2) {
            String yamlContext = this.getFilesContextsYaml(provider, context2);
            return this.promptWithFilesContextsYaml(yamlContext);
        }

        @Nullable
        public final PSString promptWithDomainContextsYaml(@Nullable String yaml) {
            if (yaml == null) {
                return null;
            }
            ConcatenateBuilder prompts = new ConcatenateBuilder(null, 1, null);
            PSString yamlText = PromptDomainContextMapperKt.getPrivacySafe(new YAMLText(yaml)).getText();
            this.addContextYaml(prompts, yamlText);
            this.addContextYamlDescription(prompts);
            this.addContextYamlExample(prompts);
            this.addAnalysisGuidelinesPrompts(prompts);
            this.addUpdateGuidelinesPrompts(prompts);
            this.addChainUpdateExample(prompts);
            return prompts.toPSString();
        }

        private final void addContextYaml(ConcatenateBuilder prompts, PSString yaml) {
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"*Environment(Domain) contexts:*"));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"```yaml"));
            prompts.appendLine(yaml);
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"```"));
        }

        private final void addContextYamlDescription(ConcatenateBuilder prompts) {
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"*Description:*"));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"The current file represents an object within a specific environment (such as a domain, application, module, etc.)."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"An example of an environment could be an MVC application, which includes components like the Database, Persistence, Controller, and Views."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)" - The environment is a collection of interrelated contexts."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)" - 'all-contexts' section: This contains all the context definitions."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)" - 'dependencies' section: This shows the dependencies between contexts."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"Each context is a brief, logical description of a domain object (e.g., a Spring service, persistence entity, database table, security role, etc.)."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"These descriptions provide details about the object's type and its properties."));
        }

        private final void addContextYamlExample(ConcatenateBuilder prompts) {
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"*Example Context Description:*"));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"This YAML fragment describes a Jakarta Persistence entity. The entity has an idType of Long, a class name of my.app.Vet, and is located at '../foo/src/main/java/my/app/Vet.java', among other details."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"\n                     ```yaml\n                              persistence-entity:\n                                path: \"../foo//src/main/java/my/app/Vet.java\"\n                                idType: \"Long\"\n                                class: \"my.app.Vet\"\n                                attributes:\n                                - name: \"specialties\"\n                                  type: \"java.util.Set<my.app.Specialty>\"\n                       ``` "));
        }

        private final void addAnalysisGuidelinesPrompts(ConcatenateBuilder prompts) {
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"*Analysis Guidelines:*"));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"- Use all contexts: You must use all context definitions in the environment to generate your answer."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"- Analyze contexts: Thoroughly analyze all the environment contexts."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"- Build dependencies graph: Map out the dependencies between contexts."));
        }

        private final void addUpdateGuidelinesPrompts(ConcatenateBuilder prompts) {
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"*Code Generation Guidelines:*"));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"- Smart Functions: Invoke smart functions to get the full content of files or classes if needed."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"- Avoid Displaying Technical Descriptions: Do not show the 'yaml' descriptions to users."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"- Consistent Updates: If you generate or update fields or methods in a context (class or file), try to update related contexts to reflect these changes."));
        }

        private final void addChainUpdateExample(ConcatenateBuilder prompts) {
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"*Dependency Chain Update Example:"));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"Initial Dependencies: MyClassA depends on MyClassB. MyClassB depends on MyClassC."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"Updates: You decide to add a new field, foo, to MyClassC."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"Because MyClassB depends on MyClassC, you decide to update MyClassB. So, you create a new method in MyClassB called findByFoo(Foo foo) that utilizes the foo field."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"Cascading Updates: Since MyClassA depends on MyClassB, you also decide to update MyClassA. Therefore, you add a new method in MyClassA called useFindByFoo(Foo foo) to work with the findByFoo method in MyClassB."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"Summary of Changes: Add a new field foo in MyClassC. Add a new method findByFoo(Foo foo) in MyClassB. Add a new method useFindByFoo(Foo foo) in MyClassA.inal update set is: 1. new 'Foo' field in MyClassC, 2. new method 'findByFoo(Foo foo)' in MyClassB 3. new method 'useFindByFoo(Foo foo)' in MyClassA"));
        }

        @Nullable
        public final PSString promptWithFilesContextsYaml(@Nullable String yaml) {
            if (yaml == null) {
                return null;
            }
            PSString yamlText = PromptDomainContextMapperKt.getPrivacySafe(new YAMLText(yaml)).getText();
            ConcatenateBuilder prompts = new ConcatenateBuilder(null, 1, null);
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"Current file is related to other environment files."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"You MUST consider all files of this environment to generate answer."));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"File dependencies are described in this yaml: "));
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"```yaml"));
            prompts.appendLine(yamlText);
            prompts.appendLine(ConstantsKt.getPrivacyConst((String)"```"));
            return prompts.toPSString();
        }

        @Nullable
        public final <T> String getDomainContextsYaml(@NotNull DomainProvider<T> provider, @NotNull DomainContext context2) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            T t = provider.findItem(context2);
            if (t == null) {
                return null;
            }
            DomainSearchScope domainSearchScope = context2.getScope();
            Intrinsics.checkNotNull((Object)domainSearchScope);
            return YamlDomainContextMapper.Companion.mapDomainContexts(provider, domainSearchScope, t);
        }

        @Nullable
        public final <T> String getFilesContextsYaml(@NotNull DomainProvider<T> provider, @NotNull DomainContext context2) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            T t = provider.findItem(context2);
            if (t == null) {
                return null;
            }
            DomainSearchScope domainSearchScope = context2.getScope();
            Intrinsics.checkNotNull((Object)domainSearchScope);
            return YamlDomainContextMapper.Companion.mapFiles(provider, domainSearchScope, t);
        }

        @Nullable
        public final <T> DomainItemContext findAndMapToContext(@NotNull DomainProvider<T> provider, @NotNull DomainContext context2) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            T t = provider.findItem(context2);
            DomainSearchScope domainSearchScope = context2.getScope();
            Intrinsics.checkNotNull((Object)domainSearchScope);
            DomainItemContext itemContext = DomainItemContextMapper.Companion.mapWithAssociations(provider, t, domainSearchScope);
            return Intrinsics.areEqual((Object)itemContext, (Object)DomainItemContext.EMPTY) ? null : itemContext;
        }

        private static final CharSequence exportPropertiesAsString$lambda$0(Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            return "\"" + key + "\" = \"" + value + "\"";
        }

        private static final Unit map$lambda$1(DomainSearchScope $scope, ArrayList $items, PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            PsiDomainContext context2 = new PsiDomainContext(psiElement, $scope);
            for (DomainProvider<?> provider : DomainProvider.Companion.getProviders()) {
                PSString pSString = Companion.domainContextsPrompt(provider, context2);
                UtilKt.addIfNotNull((List)$items, (Object)(pSString != null ? pSString.toString() : null));
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

