/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.domains.ide.mappers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.ml.llm.domains.DomainProvider;
import com.intellij.ml.llm.domains.DomainSearchScope;
import com.intellij.ml.llm.domains.context.DomainItemContext;
import com.intellij.ml.llm.domains.ide.associations.DomainContextAssociations;
import com.intellij.ml.llm.domains.ide.associations.DomainItem;
import com.intellij.ml.llm.domains.ide.utils.PsiDomainContext;
import com.intellij.ml.llm.domains.ide.utils.ScopeUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ml/llm/domains/ide/mappers/YamlDomainContextMapper;", "", "<init>", "()V", "Companion", "intellij.ml.llm.domains.ide"})
public final class YamlDomainContextMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CONTEXT_GUIDELINES = "\n      *Additional Guideline:*\n      1. You MUST consider `ide-contexts`\n      2. You CAN get related files from `all-files` in `ide-contexts`\n      3. You MUST get content for related files with `read_file` function for `path` attribute in `all-files`.\n      4. You CAN provide changes for required related files from `all-files` in `ide-contexts`.    \n    ";

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0006\u001a\u0004\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u0013J.\u0010\u0010\u001a\u0004\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00052\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/domains/ide/mappers/YamlDomainContextMapper$Companion;", "", "<init>", "()V", "CONTEXT_GUIDELINES", "", "mapDomainContexts", "T", "provider", "Lcom/intellij/ml/llm/domains/DomainProvider;", "scope", "Lcom/intellij/ml/llm/domains/DomainSearchScope;", "item", "(Lcom/intellij/ml/llm/domains/DomainProvider;Lcom/intellij/ml/llm/domains/DomainSearchScope;Ljava/lang/Object;)Ljava/lang/String;", "llmItem", "Lcom/intellij/ml/llm/domains/ide/associations/DomainItem;", "mapFiles", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "toYaml", "value", "", "intellij.ml.llm.domains.ide"})
    @SourceDebugExtension(value={"SMAP\nYamlDomainContextMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlDomainContextMapper.kt\ncom/intellij/ml/llm/domains/ide/mappers/YamlDomainContextMapper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1617#2,9:77\n1869#2:86\n1870#2:88\n1626#2:89\n1#3:87\n*S KotlinDebug\n*F\n+ 1 YamlDomainContextMapper.kt\ncom/intellij/ml/llm/domains/ide/mappers/YamlDomainContextMapper$Companion\n*L\n46#1:77,9\n46#1:86\n46#1:88\n46#1:89\n46#1:87\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final <T> String mapDomainContexts(@NotNull DomainProvider<T> provider, @NotNull DomainSearchScope scope, T item) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            return this.mapDomainContexts(new DomainItem<T>(provider, scope, item));
        }

        @Nullable
        public final String mapDomainContexts(@NotNull DomainItem<?> llmItem) {
            Intrinsics.checkNotNullParameter(llmItem, (String)"llmItem");
            try {
                return this.toYaml(llmItem.getAssociations().domainContextsMap());
            }
            catch (JsonProcessingException e) {
                Logger.getInstance(DomainItemContext.class).warn("Unable to dump context as yaml", (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> mapFiles(@NotNull PsiElement psiElement) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            DomainSearchScope scope = ScopeUtilsKt.createScope(psiElement);
            PsiDomainContext context2 = new PsiDomainContext(psiElement, scope);
            Iterable iterable = DomainProvider.Companion.getProviders();
            boolean $i$f$mapNotNull = false;
            void var6_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                DomainProvider provider = (DomainProvider)element$iv$iv;
                boolean bl2 = false;
                if (Companion.mapFiles(provider, scope, provider.findItem(context2)) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        }

        @Nullable
        public final <T> String mapFiles(@NotNull DomainProvider<T> provider, @NotNull DomainSearchScope scope, @Nullable Object item) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            return this.mapFiles(new DomainItem<Object>(provider, scope, item));
        }

        @Nullable
        public final String mapFiles(@NotNull DomainItem<?> llmItem) {
            Intrinsics.checkNotNullParameter(llmItem, (String)"llmItem");
            try {
                DomainContextAssociations associations = llmItem.getAssociations();
                return "\n      *Additional Guideline:*\n      1. You MUST consider `ide-contexts`\n      2. You CAN get related files from `all-files` in `ide-contexts`\n      3. You MUST get content for related files with `read_file` function for `path` attribute in `all-files`.\n      4. You CAN provide changes for required related files from `all-files` in `ide-contexts`.    \n    \n\n" + new ObjectMapper((JsonFactory)new YAMLFactory()).writerWithDefaultPrettyPrinter().writeValueAsString(associations.filesMap());
            }
            catch (JsonProcessingException e) {
                Logger.getInstance(DomainItemContext.class).warn("Unable to dump context as yaml", (Throwable)e);
                return null;
            }
        }

        @Nullable
        public final String toYaml(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new ObjectMapper((JsonFactory)new YAMLFactory()).writerWithDefaultPrettyPrinter().writeValueAsString(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

