/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.next.agents.impl.executors.data.tools;

import ai.koog.agents.core.tools.ToolArgs;
import ai.koog.agents.core.tools.ToolDescriptor;
import ai.koog.agents.core.tools.ToolParameterDescriptor;
import ai.koog.agents.core.tools.ToolParameterType;
import com.intellij.dataspell.llm.DataSpellWorkspaceContextLlmFacade;
import com.intellij.ml.llm.ds.next.agents.ProjectFileUtilsKt;
import com.intellij.ml.llm.ds.next.agents.impl.DataSpellNextAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.base.tools.DataSpellNextTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.data.DataAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.executors.data.operations.DataOperation;
import com.intellij.ml.llm.ds.next.agents.impl.executors.data.tools.AddFileByPathTool$Args$;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/data/tools/AddFileByPathTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/base/tools/DataSpellNextTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/data/DataAgentContext;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/data/tools/AddFileByPathTool$Args;", "context", "<init>", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/data/DataAgentContext;)V", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "description", "", "getDescription", "()Ljava/lang/String;", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "doExecuteImpl", "args", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/data/tools/AddFileByPathTool$Args;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Args", "intellij.ml.llm.ds.next"})
@SourceDebugExtension(value={"SMAP\nAddFileByPathTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddFileByPathTool.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/data/tools/AddFileByPathTool\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,68:1\n30#2,2:69\n*S KotlinDebug\n*F\n+ 1 AddFileByPathTool.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/data/tools/AddFileByPathTool\n*L\n39#1:69,2\n*E\n"})
public final class AddFileByPathTool
extends DataSpellNextTool<DataAgentContext, Args> {
    @NotNull
    private final KSerializer<Args> argsSerializer;
    @NotNull
    private final String description;

    public AddFileByPathTool(@NotNull DataAgentContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((DataSpellNextAgentContext)context2);
        this.argsSerializer = Args.Companion.serializer();
        this.description = "Add a file to the Data Tool Window by its full path or name.";
    }

    @NotNull
    public KSerializer<Args> getArgsSerializer() {
        return this.argsSerializer;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public ToolDescriptor getDescriptor() {
        return new ToolDescriptor("add_file_by_path_or_name", this.getDescription(), CollectionsKt.listOf((Object)new ToolParameterDescriptor("file_path_or_name", "The full path or name of the file to add to the Data Tool Window", (ToolParameterType)ToolParameterType.String.INSTANCE)), null, 8, null);
    }

    @Override
    @Nullable
    public Object doExecuteImpl(@NotNull Args args, @NotNull Continuation<? super String> $completion) {
        ComponentManager $this$service$iv = (ComponentManager)((DataAgentContext)this.getContext()).getProject();
        boolean $i$f$service = false;
        Class<DataSpellWorkspaceContextLlmFacade> serviceClass$iv = DataSpellWorkspaceContextLlmFacade.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DataSpellWorkspaceContextLlmFacade facade = (DataSpellWorkspaceContextLlmFacade)object;
        String filePathOrName = args.getFilePathOrName();
        List files = facade.resolve(args.getFilePathOrName());
        if (files.isEmpty()) {
            return "Failure: Can't add file " + filePathOrName + " because it doesn't exist.";
        }
        if (files.size() > 1) {
            String filesInfos = CollectionsKt.joinToString$default((Iterable)files, (CharSequence)"\n", null, null, (int)0, null, AddFileByPathTool::doExecuteImpl$lambda$0, (int)30, null);
            return "Multiple files were found:\n" + filesInfos + "\n\n Response with the information about the files and ask to repeat the request with a more specific parameters.";
        }
        VirtualFile file2 = (VirtualFile)CollectionsKt.single((List)files);
        Path path = Path.of(file2.getPath(), new String[0]);
        Intrinsics.checkNotNull((Object)path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return "Failure: Can't add file " + filePathOrName + " because it's not a regular file.";
        }
        ((DataAgentContext)this.getContext()).addOperation(new DataOperation.AddFile(path, ProjectFileUtilsKt.relativePathTo(file2, ((DataAgentContext)this.getContext()).getProject())));
        return "Success";
    }

    private static final CharSequence doExecuteImpl$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "- Path: " + it.getPath();
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/data/tools/AddFileByPathTool$Args;", "Lai/koog/agents/core/tools/ToolArgs;", "filePathOrName", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getFilePathOrName$annotations", "()V", "getFilePathOrName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_ds_next", "$serializer", "Companion", "intellij.ml.llm.ds.next"})
    public static final class Args
    implements ToolArgs {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String filePathOrName;

        public Args(@NotNull String filePathOrName) {
            Intrinsics.checkNotNullParameter((Object)filePathOrName, (String)"filePathOrName");
            this.filePathOrName = filePathOrName;
        }

        @NotNull
        public final String getFilePathOrName() {
            return this.filePathOrName;
        }

        @SerialName(value="file_path_or_name")
        public static /* synthetic */ void getFilePathOrName$annotations() {
        }

        @NotNull
        public final String component1() {
            return this.filePathOrName;
        }

        @NotNull
        public final Args copy(@NotNull String filePathOrName) {
            Intrinsics.checkNotNullParameter((Object)filePathOrName, (String)"filePathOrName");
            return new Args(filePathOrName);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.filePathOrName;
            }
            return args.copy(string);
        }

        @NotNull
        public String toString() {
            return "Args(filePathOrName=" + this.filePathOrName + ")";
        }

        public int hashCode() {
            return this.filePathOrName.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual((Object)this.filePathOrName, (Object)args.filePathOrName);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_ds_next(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.filePathOrName);
        }

        public /* synthetic */ Args(int seen0, String filePathOrName, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.filePathOrName = filePathOrName;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/data/tools/AddFileByPathTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/data/tools/AddFileByPathTool$Args;", "intellij.ml.llm.ds.next"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

