/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.service;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.dataspell.llm.DatabaseLlmFacade;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.model.ConnectionTypeModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.model.DbConnectionSolutionModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.model.DbConnectivityModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.model.DbConnectivitySolutionModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.model.DriverModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.model.ParameterModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.model.ParameterSolutionModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.model.ValueModel;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\u00020\t*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0086@\u00a2\u0006\u0002\u0010 J\u001a\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020#H\u0002J\"\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\u0007*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010(\u001a\u0004\u0018\u00010\u0014*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/service/DbConnectivityService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isAvailable", "", "getDbConnectivityModel", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/model/DbConnectivityModel;", "buildDbConnectivityModel", "Lcom/intellij/database/dataSource/DatabaseDriverManager;", "buildDriverModel", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/model/DriverModel;", "Lcom/intellij/database/dataSource/DatabaseDriver;", "buildConnectionTypeModel", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/model/ConnectionTypeModel;", "", "Lcom/intellij/database/dataSource/url/StatelessJdbcUrlParser;", "name", "", "buildParameterModel", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/model/ParameterModel;", "Lcom/intellij/database/dataSource/url/template/StatelessParametersHolder$ParameterInfo;", "adjustedDrivers", "getAdjustedDrivers", "(Lcom/intellij/database/dataSource/DatabaseDriverManager;)Ljava/util/List;", "isActual", "(Lcom/intellij/database/dataSource/DatabaseDriver;)Z", "applyDbConnectivitySolution", "solution", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/model/DbConnectivitySolutionModel;", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/model/DbConnectivitySolutionModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createDataSourceURL", "driver", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/model/DbConnectionSolutionModel;", "createDataSource", "Ljava/lang/Object;", "Lcom/intellij/database/dataSource/DatabaseDriverImpl;", "url", "nonDefaultName", "getNonDefaultName", "(Lcom/intellij/database/dataSource/url/StatelessJdbcUrlParser;)Ljava/lang/String;", "DataSourceConfig", "intellij.ml.llm.ds.next"})
@SourceDebugExtension(value={"SMAP\nDbConnectivityService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbConnectivityService.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/service/DbConnectivityService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n50#2:111\n1563#3:112\n1634#3,3:113\n1491#3:116\n1516#3,3:117\n1519#3,3:127\n1563#3:130\n1634#3,3:131\n1617#3,9:134\n1869#3:143\n1870#3:145\n1626#3:146\n1193#3,2:148\n1267#3,4:150\n1740#3,3:154\n1563#3:157\n1634#3,3:158\n1491#3:161\n1516#3,3:162\n1519#3,3:172\n382#4,7:120\n382#4,7:165\n1#5:144\n1#5:147\n*S KotlinDebug\n*F\n+ 1 DbConnectivityService.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/service/DbConnectivityService\n*L\n22#1:111\n33#1:112\n33#1:113,3\n38#1:116\n38#1:117,3\n38#1:127,3\n38#1:130\n38#1:131,3\n44#1:134,9\n44#1:143\n44#1:145\n44#1:146\n51#1:148,2\n51#1:150,4\n69#1:154,3\n84#1:157\n84#1:158,3\n89#1:161\n89#1:162,3\n89#1:172,3\n38#1:120,7\n89#1:165,7\n44#1:144\n*E\n"})
public final class DbConnectivityService {
    @NotNull
    private final Project project;

    public DbConnectivityService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public final boolean isAvailable() {
        ComponentManager $this$serviceOrNull$iv = (ComponentManager)this.project;
        boolean $i$f$serviceOrNull = false;
        return $this$serviceOrNull$iv.getService(DatabaseLlmFacade.class) != null;
    }

    @NotNull
    public final DbConnectivityModel getDbConnectivityModel() {
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        Intrinsics.checkNotNull((Object)driverManager);
        return this.buildDbConnectivityModel(driverManager);
    }

    /*
     * WARNING - void declaration
     */
    private final DbConnectivityModel buildDbConnectivityModel(DatabaseDriverManager $this$buildDbConnectivityModel) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getAdjustedDrivers($this$buildDbConnectivityModel);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DatabaseDriver databaseDriver = (DatabaseDriver)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.buildDriverModel((DatabaseDriver)it));
        }
        List drivers = (List)destination$iv$iv;
        return new DbConnectivityModel(drivers);
    }

    /*
     * WARNING - void declaration
     */
    private final DriverModel buildDriverModel(DatabaseDriver $this$buildDriverModel) {
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$groupByTo$iv$iv;
        List list = $this$buildDriverModel.getJDBCUrlParsers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJDBCUrlParsers(...)");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            it = (StatelessJdbcUrlParser)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String key$iv$iv = this.getNonDefaultName((StatelessJdbcUrlParser)it);
            Map map2 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = destination$iv$iv.entrySet();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(this.buildConnectionTypeModel((List)it.getValue(), (String)it.getKey()));
        }
        List connectionTypes = (List)destination$iv$iv;
        String string = $this$buildDriverModel.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $this$buildDriverModel.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return new DriverModel(string, string2, connectionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final ConnectionTypeModel buildConnectionTypeModel(List<? extends StatelessJdbcUrlParser> $this$buildConnectionTypeModel, String name) {
        void $this$mapNotNullTo$iv$iv;
        StatelessJdbcUrlParser parser = (StatelessJdbcUrlParser)CollectionsKt.first($this$buildConnectionTypeModel);
        Collection collection = parser.getParameterNames();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getParameterNames(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ParameterModel parameterModel;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            StatelessParametersHolder.ParameterInfo parameterInfo = parser.getParameterInfo(it);
            if (parameterInfo != null) {
                Intrinsics.checkNotNull((Object)it);
                parameterModel = this.buildParameterModel(parameterInfo, it);
            } else {
                parameterModel = null;
            }
            if (parameterModel == null) continue;
            ParameterModel it$iv$iv = parameterModel;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List parameters = (List)destination$iv$iv;
        return new ConnectionTypeModel(name, parameters);
    }

    /*
     * Unable to fully structure code
     */
    private final ParameterModel buildParameterModel(StatelessParametersHolder.ParameterInfo $this$buildParameterModel, String name) {
        var4_3 = $this$buildParameterModel.getConfiguration();
        if (var4_3 == null) ** GOTO lbl-1000
        it = var4_3;
        $i$a$-let-DbConnectivityService$buildParameterModel$possibleValues$1 = false;
        var5_7 = TypesRegistry.parseConfiguration((String)it);
        if (var5_7 != null) {
            var6_8 = var5_7;
            $i$f$associate = false;
            capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            var9_9 = $this$associate$iv;
            destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
            $i$f$associateTo = false;
            for (T element$iv$iv : $this$associateTo$iv$iv) {
                var14_14 = destination$iv$iv;
                it = (Pair)element$iv$iv;
                $i$a$-associate-DbConnectivityService$buildParameterModel$possibleValues$2 = false;
                v0 = it.second;
                v1 = it.second;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"second");
                var15_15 = TuplesKt.to((Object)v0, (Object)new ValueModel((String)v1, (String)it.first));
                var14_14.put(var15_15.getFirst(), var15_15.getSecond());
            }
            v2 = destination$iv$iv;
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        possibleValues = v2;
        defaultValue = $this$buildParameterModel.getDefValue();
        return new ParameterModel(name, possibleValues, defaultValue);
    }

    private final List<DatabaseDriver> getAdjustedDrivers(DatabaseDriverManager $this$adjustedDrivers) {
        Collection collection = $this$adjustedDrivers.getDrivers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDrivers(...)");
        Sequence drivers = CollectionsKt.asSequence((Iterable)collection);
        Sequence uniqueDrivers = SequencesKt.distinctBy((Sequence)drivers, DbConnectivityService::_get_adjustedDrivers_$lambda$0);
        Sequence actualDrivers = SequencesKt.filter((Sequence)uniqueDrivers, arg_0 -> DbConnectivityService._get_adjustedDrivers_$lambda$1(this, arg_0));
        return SequencesKt.toList((Sequence)actualDrivers);
    }

    private final boolean isActual(DatabaseDriver $this$isActual) {
        boolean bl;
        block3: {
            Set set = $this$isActual.getConstraints();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getConstraints(...)");
            Iterable $this$all$iv = set;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    DatabaseDriver.Constraint it = (DatabaseDriver.Constraint)element$iv;
                    boolean bl2 = false;
                    if (it.to == null) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object applyDbConnectivitySolution(@NotNull DbConnectivitySolutionModel solution, @NotNull Continuation<? super Boolean> $completion) {
        void $this$mapTo$iv$iv;
        Iterable url;
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        List dataSourceConfigurations = new ArrayList();
        for (DbConnectionSolutionModel configuration : solution.getDbConnections()) {
            DatabaseDriver databaseDriver = driverManager.getDriver(configuration.getDriverId());
            DatabaseDriverImpl databaseDriverImpl = databaseDriver instanceof DatabaseDriverImpl ? (DatabaseDriverImpl)databaseDriver : null;
            if (databaseDriverImpl == null) {
                return Boxing.boxBoolean((boolean)false);
            }
            DatabaseDriverImpl driver = databaseDriverImpl;
            if (this.createDataSourceURL((DatabaseDriver)driver, configuration) == null) {
                return Boxing.boxBoolean((boolean)false);
            }
            dataSourceConfigurations.add(new DataSourceConfig(driver, (String)((Object)url), configuration.getConnectionName()));
        }
        Iterable $this$map$iv = dataSourceConfigurations;
        boolean $i$f$map = false;
        url = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataSourceConfig dataSourceConfig = (DataSourceConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createDataSource(it.getDriver(), it.getUrl(), it.getName()));
        }
        List dataSources = (List)destination$iv$iv;
        return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, (List<? extends Object>)dataSources, null){
            int label;
            final /* synthetic */ DbConnectivityService this$0;
            final /* synthetic */ List<Object> $dataSources;
            {
                this.this$0 = $receiver;
                this.$dataSources = $dataSources;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ComponentManager $this$service$iv = (ComponentManager)DbConnectivityService.access$getProject$p(this.this$0);
                        boolean $i$f$service = false;
                        Class<DatabaseLlmFacade> serviceClass$iv = DatabaseLlmFacade.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        return Boxing.boxBoolean((boolean)((DatabaseLlmFacade)object).addDataSourceAndSelectTables(DbConnectivityService.access$getProject$p(this.this$0), this.$dataSources));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - void declaration
     */
    private final String createDataSourceURL(DatabaseDriver driver, DbConnectionSolutionModel solution) {
        void $this$groupByTo$iv$iv;
        List list = driver.getJDBCUrlParsers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJDBCUrlParsers(...)");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            StatelessJdbcUrlParser it = (StatelessJdbcUrlParser)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String key$iv$iv = this.getNonDefaultName(it);
            Map map2 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        List statelessJdbcUrlParsers = (List)destination$iv$iv.get(solution.getConnectionTypeName());
        List list2 = statelessJdbcUrlParsers;
        if (list2 == null || (list2 = (StatelessJdbcUrlParser)CollectionsKt.firstOrNull((List)list2)) == null) {
            return null;
        }
        List statelessJdbcUrlParser = list2;
        JdbcUrlParser jdbcUrlParser = statelessJdbcUrlParser.createStateful();
        Intrinsics.checkNotNullExpressionValue((Object)jdbcUrlParser, (String)"createStateful(...)");
        JdbcUrlParser jdbcUrlParser2 = jdbcUrlParser;
        for (ParameterSolutionModel parameter : solution.getParameters()) {
            jdbcUrlParser2.setParameter(parameter.getName(), parameter.getValue().getValue());
        }
        return jdbcUrlParser2.getUrlText();
    }

    private final Object createDataSource(DatabaseDriverImpl driver, String url, String name) {
        LocalDataSource dataSource = driver.createDataSource(name);
        dataSource.setUrl(url);
        driver.setDefaultProperties(dataSource, true);
        Intrinsics.checkNotNull((Object)dataSource, (String)"null cannot be cast to non-null type java.lang.Object");
        return dataSource;
    }

    private final String getNonDefaultName(StatelessJdbcUrlParser $this$nonDefaultName) {
        String string;
        String it = string = $this$nonDefaultName.getName();
        boolean bl = false;
        return !Intrinsics.areEqual((Object)it, (Object)"default") ? string : null;
    }

    private static final String _get_adjustedDrivers_$lambda$0(DatabaseDriver it) {
        return it.getName();
    }

    private static final boolean _get_adjustedDrivers_$lambda$1(DbConnectivityService this$0, DatabaseDriver it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.isActual(it);
    }

    public static final /* synthetic */ Project access$getProject$p(DbConnectivityService $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/service/DbConnectivityService$DataSourceConfig;", "", "driver", "Lcom/intellij/database/dataSource/DatabaseDriverImpl;", "url", "", "name", "<init>", "(Lcom/intellij/database/dataSource/DatabaseDriverImpl;Ljava/lang/String;Ljava/lang/String;)V", "getDriver", "()Lcom/intellij/database/dataSource/DatabaseDriverImpl;", "getUrl", "()Ljava/lang/String;", "getName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.ds.next"})
    private static final class DataSourceConfig {
        @NotNull
        private final DatabaseDriverImpl driver;
        @NotNull
        private final String url;
        @Nullable
        private final String name;

        public DataSourceConfig(@NotNull DatabaseDriverImpl driver, @NotNull String url, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.driver = driver;
            this.url = url;
            this.name = name;
        }

        @NotNull
        public final DatabaseDriverImpl getDriver() {
            return this.driver;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final DatabaseDriverImpl component1() {
            return this.driver;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @Nullable
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final DataSourceConfig copy(@NotNull DatabaseDriverImpl driver, @NotNull String url, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new DataSourceConfig(driver, url, name);
        }

        public static /* synthetic */ DataSourceConfig copy$default(DataSourceConfig dataSourceConfig, DatabaseDriverImpl databaseDriverImpl, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                databaseDriverImpl = dataSourceConfig.driver;
            }
            if ((n & 2) != 0) {
                string = dataSourceConfig.url;
            }
            if ((n & 4) != 0) {
                string2 = dataSourceConfig.name;
            }
            return dataSourceConfig.copy(databaseDriverImpl, string, string2);
        }

        @NotNull
        public String toString() {
            return "DataSourceConfig(driver=" + this.driver + ", url=" + this.url + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result2 = this.driver.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataSourceConfig)) {
                return false;
            }
            DataSourceConfig dataSourceConfig = (DataSourceConfig)other;
            if (!Intrinsics.areEqual((Object)this.driver, (Object)dataSourceConfig.driver)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)dataSourceConfig.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)dataSourceConfig.name);
        }
    }
}

