/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.tools;

import ai.koog.agents.core.tools.ToolArgs;
import ai.koog.agents.core.tools.ToolDescriptor;
import ai.koog.agents.core.tools.ToolParameterDescriptor;
import ai.koog.agents.core.tools.ToolParameterType;
import com.intellij.ml.llm.ds.next.agents.impl.DataSpellNextAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.base.tools.DataSpellNextTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.DbConnectionAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.model.DriverModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.dbConnection.tools.SelectDriverTool$Args$;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001c2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u001b\u001cB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010\u001aR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/tools/SelectDriverTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/base/tools/DataSpellNextTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/DbConnectionAgentContext;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/tools/SelectDriverTool$Args;", "context", "driverModels", "", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/model/DriverModel;", "<init>", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/DbConnectionAgentContext;Ljava/util/List;)V", "driverNameToIdMap", "", "", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "description", "getDescription", "()Ljava/lang/String;", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "doExecuteImpl", "args", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/tools/SelectDriverTool$Args;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Args", "Companion", "intellij.ml.llm.ds.next"})
@SourceDebugExtension(value={"SMAP\nSelectDriverTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectDriverTool.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/tools/SelectDriverTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,60:1\n1193#2,2:61\n1267#2,4:63\n37#3,2:67\n*S KotlinDebug\n*F\n+ 1 SelectDriverTool.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/tools/SelectDriverTool\n*L\n19#1:61,2\n19#1:63,4\n36#1:67,2\n*E\n"})
public final class SelectDriverTool
extends DataSpellNextTool<DbConnectionAgentContext, Args> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> driverNameToIdMap;
    @NotNull
    private final KSerializer<Args> argsSerializer;
    @NotNull
    private final String description;
    @NotNull
    public static final String NAME = "select_database_driver";

    /*
     * WARNING - void declaration
     */
    public SelectDriverTool(@NotNull DbConnectionAgentContext context2, @NotNull List<DriverModel> driverModels) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(driverModels, (String)"driverModels");
        super((DataSpellNextAgentContext)context2);
        Iterable iterable = driverModels;
        SelectDriverTool selectDriverTool = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            DriverModel it = (DriverModel)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getId());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        selectDriverTool.driverNameToIdMap = destination$iv$iv;
        this.argsSerializer = Args.Companion.serializer();
        this.description = "Select the database driver to be used for creating the database connection.";
    }

    @NotNull
    public KSerializer<Args> getArgsSerializer() {
        return this.argsSerializer;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public ToolDescriptor getDescriptor() {
        Collection $this$toTypedArray$iv = this.driverNameToIdMap.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new ToolDescriptor(NAME, this.getDescription(), CollectionsKt.listOf((Object)new ToolParameterDescriptor("driver_name", "The database driver name", (ToolParameterType)new ToolParameterType.Enum(thisCollection$iv.toArray(new String[0])))), null, 8, null);
    }

    @Override
    @Nullable
    public Object doExecuteImpl(@NotNull Args args, @NotNull Continuation<? super String> $completion) {
        String driverName = args.getDriverName();
        String driverId = this.driverNameToIdMap.get(driverName);
        if (driverId == null) {
            return StringsKt.trimIndent((String)("\n        Failure: Driver named \\\"" + driverName + "\\\" not found.\"\n        Tools for creating a database connection are unavailable because no driver has been selected.\n      "));
        }
        return StringsKt.trimIndent((String)("\n      " + driverId + ";\n      Success: Driver named \\\"" + driverName + "\\\" has been selected. \n      Tools for creating a database connection using this driver are now available.\n      "));
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/tools/SelectDriverTool$Args;", "Lai/koog/agents/core/tools/ToolArgs;", "driverName", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getDriverName$annotations", "()V", "getDriverName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_ds_next", "$serializer", "Companion", "intellij.ml.llm.ds.next"})
    public static final class Args
    implements ToolArgs {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String driverName;

        public Args(@NotNull String driverName) {
            Intrinsics.checkNotNullParameter((Object)driverName, (String)"driverName");
            this.driverName = driverName;
        }

        @NotNull
        public final String getDriverName() {
            return this.driverName;
        }

        @SerialName(value="driver_name")
        public static /* synthetic */ void getDriverName$annotations() {
        }

        @NotNull
        public final String component1() {
            return this.driverName;
        }

        @NotNull
        public final Args copy(@NotNull String driverName) {
            Intrinsics.checkNotNullParameter((Object)driverName, (String)"driverName");
            return new Args(driverName);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.driverName;
            }
            return args.copy(string);
        }

        @NotNull
        public String toString() {
            return "Args(driverName=" + this.driverName + ")";
        }

        public int hashCode() {
            return this.driverName.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual((Object)this.driverName, (Object)args.driverName);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_ds_next(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.driverName);
        }

        public /* synthetic */ Args(int seen0, String driverName, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.driverName = driverName;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/tools/SelectDriverTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/tools/SelectDriverTool$Args;", "intellij.ml.llm.ds.next"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/dbConnection/tools/SelectDriverTool$Companion;", "", "<init>", "()V", "NAME", "", "intellij.ml.llm.ds.next"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

