/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.next.agents.impl.executors.export;

import com.intellij.ml.llm.ds.next.agents.impl.DataSpellNextAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.base.DataSpellNextAgentModuleBase;
import com.intellij.ml.llm.ds.next.agents.impl.base.tools.DataSpellNextTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.ExportAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.model.SelectedFileModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools.ConvertJupyterToFormatTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools.ConvertJupyterToPythonTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools.ConvertPythonToJupyterTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools.ExportDataTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools.ExportTableByInfoTool;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00100\u000fH\u0014R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/ExportAgentModule;", "Lcom/intellij/ml/llm/ds/next/agents/impl/base/DataSpellNextAgentModuleBase;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/ExportAgentContext;", "context", "<init>", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/ExportAgentContext;)V", "name", "", "getName", "()Ljava/lang/String;", "defSystemPrompt", "getDefSystemPrompt", "systemPromptBase", "getSystemPromptBase", "createTools", "", "Lcom/intellij/ml/llm/ds/next/agents/impl/base/tools/DataSpellNextTool;", "intellij.ml.llm.ds.next"})
public final class ExportAgentModule
extends DataSpellNextAgentModuleBase<ExportAgentContext> {
    public ExportAgentModule(@NotNull ExportAgentContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((DataSpellNextAgentContext)context2);
    }

    @Override
    @NotNull
    public String getName() {
        return "export";
    }

    @Override
    @NotNull
    public String getDefSystemPrompt() {
        return "The agent who helps users use export functionality.\n\nActions this agent can perform:\n- export Jupyter Notebook to a specific format\n- export Jupyter Notebook to a Python Script\n- export Python Script to a Jupyter Notebook\n- export SQL table to a specific format\n- export data to a specific format\n\nThis agent should only be used for its defined actions. \nTasks that require other types of actions are out of scope and should not be handled by this agent.";
    }

    @Override
    @NotNull
    protected String getSystemPromptBase() {
        String string;
        SelectedFileModel selectedFileModel = ((ExportAgentContext)this.getContext()).getExportModel().getSelectedFile();
        if (selectedFileModel != null) {
            SelectedFileModel it = selectedFileModel;
            boolean bl = false;
            string = "\n      The user has a currently open file: " + it.getName() + ".\n\n      When handling an export operation, do not include filePath in the export tool if any of the following is true:\n      - The user did not specify a source file,\n      - The user indicated they want to use the current file as the source,\n      - The user explicitly mentioned " + it.getName() + " (with or without its extension).\n\n      In this case, the currently open file will be used for an export operation.\n      ";
        } else {
            string = null;
        }
        return StringsKt.trimIndent((String)("\n      You are an agent who helps users export data.\n      There are several tools that allow exporting jupyter notebooks, SQL tables or data into different formats.\n      \n      You will receive a user request and, using the tools, must perform actions that best fulfill the user's request.\n      \n      You MUST operate with tools, not offer text solutions in the result.\n      You MUST perform the user's task with maximum accuracy.\n      \n      " + string + "\n      \n      If you have not applied any actions, include an explanation in your response to the user, stating why you cannot generate a non-empty sequence of actions for their request.\n    "));
    }

    @Override
    @NotNull
    protected List<DataSpellNextTool<ExportAgentContext, ?>> createTools() {
        DataSpellNextTool[] dataSpellNextToolArray = new DataSpellNextTool[]{new ConvertJupyterToPythonTool((ExportAgentContext)this.getContext()), new ConvertJupyterToFormatTool((ExportAgentContext)this.getContext()), new ConvertPythonToJupyterTool((ExportAgentContext)this.getContext()), new ExportTableByInfoTool((ExportAgentContext)this.getContext()), new ExportDataTool((ExportAgentContext)this.getContext())};
        return CollectionsKt.listOf((Object[])dataSpellNextToolArray);
    }
}

