/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.next.agents.impl.executors.letsPlotEda.tools;

import ai.koog.agents.core.tools.ToolArgs;
import ai.koog.agents.core.tools.ToolDescriptor;
import ai.koog.agents.core.tools.ToolParameterDescriptor;
import ai.koog.agents.core.tools.ToolParameterType;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.dataspell.jupyter.customCells.visualization.letsPlot.PlotSpecsUtil;
import com.intellij.ml.llm.ds.next.agents.impl.DataSpellNextAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.base.tools.DataSpellNextTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.letsPlotEda.LetsPlotEDAAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.executors.letsPlotEda.models.LetsPlotEDAModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.letsPlotEda.operations.LetsPlotEDAOperation;
import com.intellij.ml.llm.ds.next.agents.impl.executors.letsPlotEda.tools.VisualizationTool$Args$;
import com.intellij.ml.llm.ds.next.agents.impl.executors.letsPlotEda.vegaSpec.VegaSpecFix;
import com.intellij.ml.llm.ds.next.agents.impl.executors.letsPlotEda.vegaSpec.VegaSpecFixes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/tools/VisualizationTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/base/tools/DataSpellNextTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/LetsPlotEDAAgentContext;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/tools/VisualizationTool$Args;", "context", "<init>", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/LetsPlotEDAAgentContext;)V", "description", "", "getDescription", "()Ljava/lang/String;", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "doExecuteImpl", "args", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/tools/VisualizationTool$Args;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Args", "Companion", "intellij.ml.llm.ds.next"})
@SourceDebugExtension(value={"SMAP\nVisualizationTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualizationTool.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/tools/VisualizationTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 DataColumn.kt\norg/jetbrains/kotlinx/dataframe/DataColumn$Companion\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n1563#2:103\n1634#2,2:104\n1636#2:107\n217#3:106\n13#4:108\n*S KotlinDebug\n*F\n+ 1 VisualizationTool.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/tools/VisualizationTool\n*L\n76#1:103\n76#1:104,2\n76#1:107\n77#1:106\n100#1:108\n*E\n"})
public final class VisualizationTool
extends DataSpellNextTool<LetsPlotEDAAgentContext, Args> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String description;
    @NotNull
    private final ToolDescriptor descriptor;
    @NotNull
    private final KSerializer<Args> argsSerializer;
    @NotNull
    private static final String PLOT_TITLE = "plot_title";
    @NotNull
    private static final String PLOT_DESCRIPTION = "plot_description";
    @NotNull
    private static final String PLOT_SPECIFICATION = "plot_specification";
    @NotNull
    private static final Logger logger;

    public VisualizationTool(@NotNull LetsPlotEDAAgentContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((DataSpellNextAgentContext)context2);
        this.description = "Tool to create a visualization";
        Object[] objectArray = new ToolParameterDescriptor[]{new ToolParameterDescriptor(PLOT_TITLE, "Plot title", (ToolParameterType)ToolParameterType.String.INSTANCE), new ToolParameterDescriptor(PLOT_DESCRIPTION, "Description of what the plot visualizes", (ToolParameterType)ToolParameterType.String.INSTANCE), new ToolParameterDescriptor(PLOT_SPECIFICATION, "The plot specification as a JSON string", (ToolParameterType)ToolParameterType.String.INSTANCE)};
        this.descriptor = new ToolDescriptor("visualize", this.getDescription(), CollectionsKt.listOf((Object[])objectArray), CollectionsKt.emptyList());
        this.argsSerializer = Args.Companion.serializer();
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public ToolDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public KSerializer<Args> getArgsSerializer() {
        return this.argsSerializer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object doExecuteImpl(@NotNull Args args, @NotNull Continuation<? super String> $completion) {
        Collection<DataColumn> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JsonObject specJsonObject;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        Object object;
        LetsPlotEDAModel letsPlotEDAModel = ((LetsPlotEDAAgentContext)this.getContext()).getModel();
        if (letsPlotEDAModel == null) {
            return "Failure: No Visualization Cell or Data File available";
        }
        LetsPlotEDAModel model = letsPlotEDAModel;
        String title = args.getPlotTitle();
        String description = args.getPlotDescription();
        String specification = args.getPlotSpecification();
        try {
            JsonElement jsonElement = Json.Default.parseToJsonElement(specification);
            Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
            object = (JsonObject)jsonElement;
        }
        catch (Exception e) {
            logger.warn("Invalid JSON in plot specs.", (Throwable)e);
            object = null;
        }
        JsonObject jsonObject3 = object;
        if (jsonObject3 != null) {
            JsonObject specsJsonObject = jsonObject3;
            boolean bl = false;
            jsonObject2 = !specsJsonObject.containsKey((Object)"title") ? new JsonObject(UtilKt.with((Map)((Map)specsJsonObject), (Object)"title", (Object)JsonElementKt.JsonPrimitive((String)title))) : specsJsonObject;
        } else {
            jsonObject2 = null;
        }
        if ((jsonObject = (specJsonObject = jsonObject2)) == null) {
            jsonObject = new JsonObject(MapsKt.emptyMap());
        }
        object = model.getDataFrame().getColumns();
        Map map2 = PlotSpecsUtil.INSTANCE.convertJsonObject(jsonObject);
        VegaSpecFixes vegaSpecFixes = VegaSpecFixes.INSTANCE;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void values$iv;
            void name$iv;
            void this_$iv;
            void it;
            Column column = (Column)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            DataColumn.Companion companion = DataColumn.Companion;
            String string = it.getName();
            List list = it.toList();
            Infer infer$iv = Infer.Type;
            boolean $i$f$createByType = false;
            collection.add(this_$iv.createByType((String)name$iv, (List)values$iv, Reflection.nullableTypeOf(Object.class), infer$iv));
        }
        collection = (List)destination$iv$iv;
        VegaSpecFix res2 = vegaSpecFixes.validateAndFix(map2, ToDataFrameKt.toDataFrameAnyColumn((Iterable)collection), CollectionsKt.emptyList());
        if (!res2.isValidSpec()) {
            String string = res2.getReply();
            if (string == null) {
                string = "failed";
            }
            return string;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"description", null), TuplesKt.to((Object)"specification", res2.getSpec())};
        String finalSpec = PlotSpecsUtil.INSTANCE.prettyPrint(PlotSpecsUtil.INSTANCE.dumpToJson((Object)MapsKt.mapOf((Pair[])pairArray)));
        ((LetsPlotEDAAgentContext)this.getContext()).addOperation(new LetsPlotEDAOperation.ApplyVisualization(description, finalSpec));
        return "Success";
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VisualizationTool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VisualizationTool.logger = logger;
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B9\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/tools/VisualizationTool$Args;", "Lai/koog/agents/core/tools/ToolArgs;", "plotTitle", "", "plotDescription", "plotSpecification", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getPlotTitle$annotations", "()V", "getPlotTitle", "()Ljava/lang/String;", "getPlotDescription$annotations", "getPlotDescription", "getPlotSpecification$annotations", "getPlotSpecification", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_ds_next", "$serializer", "Companion", "intellij.ml.llm.ds.next"})
    public static final class Args
    implements ToolArgs {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String plotTitle;
        @NotNull
        private final String plotDescription;
        @NotNull
        private final String plotSpecification;

        public Args(@NotNull String plotTitle, @NotNull String plotDescription, @NotNull String plotSpecification) {
            Intrinsics.checkNotNullParameter((Object)plotTitle, (String)"plotTitle");
            Intrinsics.checkNotNullParameter((Object)plotDescription, (String)"plotDescription");
            Intrinsics.checkNotNullParameter((Object)plotSpecification, (String)"plotSpecification");
            this.plotTitle = plotTitle;
            this.plotDescription = plotDescription;
            this.plotSpecification = plotSpecification;
        }

        @NotNull
        public final String getPlotTitle() {
            return this.plotTitle;
        }

        @SerialName(value="plot_title")
        public static /* synthetic */ void getPlotTitle$annotations() {
        }

        @NotNull
        public final String getPlotDescription() {
            return this.plotDescription;
        }

        @SerialName(value="plot_description")
        public static /* synthetic */ void getPlotDescription$annotations() {
        }

        @NotNull
        public final String getPlotSpecification() {
            return this.plotSpecification;
        }

        @SerialName(value="plot_specification")
        public static /* synthetic */ void getPlotSpecification$annotations() {
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_ds_next(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.plotTitle);
            output.encodeStringElement(serialDesc, 1, self.plotDescription);
            output.encodeStringElement(serialDesc, 2, self.plotSpecification);
        }

        public /* synthetic */ Args(int seen0, String plotTitle, String plotDescription, String plotSpecification, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.plotTitle = plotTitle;
            this.plotDescription = plotDescription;
            this.plotSpecification = plotSpecification;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/tools/VisualizationTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/tools/VisualizationTool$Args;", "intellij.ml.llm.ds.next"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/letsPlotEda/tools/VisualizationTool$Companion;", "", "<init>", "()V", "PLOT_TITLE", "", "PLOT_DESCRIPTION", "PLOT_SPECIFICATION", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.ds.next"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

