/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.java.exception.filters;

import com.intellij.ml.llm.errorExplanation.filters.ExceptionRange;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRangePostprocessor;
import com.intellij.ml.llm.java.exception.filters.JvmExceptionLLMExplainFilterKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/java/exception/filters/JvmExceptionPostprocessor;", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRangePostprocessor;", "<init>", "()V", "postprocess", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRange;", "consoleDocument", "Lcom/intellij/openapi/editor/Document;", "oldExceptionRange", "intellij.ml.llm.java"})
public final class JvmExceptionPostprocessor
extends ExceptionRangePostprocessor {
    @NotNull
    public ExceptionRange postprocess(@NotNull Document consoleDocument, @NotNull ExceptionRange oldExceptionRange) {
        String line;
        Intrinsics.checkNotNullParameter((Object)consoleDocument, (String)"consoleDocument");
        Intrinsics.checkNotNullParameter((Object)oldExceptionRange, (String)"oldExceptionRange");
        int textLength = consoleDocument.getTextLength();
        if (textLength == 0) {
            return oldExceptionRange;
        }
        int firstLine = consoleDocument.getLineNumber(oldExceptionRange.getStartOffset());
        Integer n = oldExceptionRange.getEndOffset();
        int resultEndOffset = n != null ? n : textLength - 1;
        int lastLine = consoleDocument.getLineNumber(resultEndOffset);
        do {
            int lastLineStartOffset = consoleDocument.getLineStartOffset(lastLine);
            resultEndOffset = consoleDocument.getLineEndOffset(lastLine);
            Intrinsics.checkNotNullExpressionValue((Object)consoleDocument.getText(new TextRange(lastLineStartOffset, resultEndOffset)), (String)"getText(...)");
        } while (!JvmExceptionLLMExplainFilterKt.mayBeTheExceptionEnd(line) && --lastLine >= firstLine);
        return new ExceptionRange(oldExceptionRange.getStartOffset(), Integer.valueOf(resultEndOffset - 1));
    }
}

