/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.javaee.jpa.persistence;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DasUtil;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.common.persistence.mapping.Entity;
import com.intellij.ml.llm.domains.DomainProvider;
import com.intellij.ml.llm.domains.DomainSearchScope;
import com.intellij.ml.llm.domains.associations.DomainAssociation;
import com.intellij.ml.llm.domains.associations.DomainAssociationDescriptor;
import com.intellij.ml.llm.domains.associations.DomainAssociationType;
import com.intellij.ml.llm.javaee.jpa.db.DBProvider;
import com.intellij.ml.llm.javaee.jpa.persistence.EntityProvider;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007H\u0016J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/javaee/jpa/persistence/EntityToTableAssociation;", "Lcom/intellij/ml/llm/domains/associations/DomainAssociation;", "Lcom/intellij/jpa/model/common/persistence/mapping/Entity;", "Lcom/intellij/database/model/DasTable;", "<init>", "()V", "getDescriptor", "Lcom/intellij/ml/llm/domains/associations/DomainAssociationDescriptor;", "outs", "", "t", "scope", "Lcom/intellij/ml/llm/domains/DomainSearchScope;", "ins", "r", "intellij.ml.llm.javaee.jpa"})
public final class EntityToTableAssociation
implements DomainAssociation<Entity, DasTable> {
    @Override
    @NotNull
    public DomainAssociationDescriptor<Entity, DasTable> getDescriptor() {
        return new DomainAssociationDescriptor<Entity, DasTable>(DomainProvider.Companion.find(EntityProvider.class), DomainProvider.Companion.find(DBProvider.class), DomainAssociationType.Companion.getMAPS());
    }

    @Override
    @NotNull
    public Set<DasTable> outs(@NotNull Entity t, @NotNull DomainSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (t instanceof EntityImpl) {
            PsiClass psiClass = ((EntityImpl)t).getPsiClass();
            if (psiClass == null) {
                return SetsKt.emptySet();
            }
            PsiClass psiClass2 = psiClass;
            Collection dataSources = ORMReferencesUtil.getDataSources((PsiClass)psiClass2);
            Intrinsics.checkNotNull((Object)dataSources);
            DbDataSource dbDataSource = (DbDataSource)CollectionsKt.firstOrNull((Iterable)dataSources);
            if (dbDataSource == null) {
                return SetsKt.emptySet();
            }
            DbDataSource dataSource = dbDataSource;
            DasObject dasTable = (DasObject)DasUtil.getTables((DasDataSource)((DasDataSource)dataSource)).filter(DasUtil.byName((String)((String)((EntityImpl)t).getTable().getTableName().getValue()))).first();
            if (dasTable instanceof DasTable) {
                Set<DasObject> set = Collections.singleton(dasTable);
                Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
                return set;
            }
        }
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<Entity> ins(@NotNull DasTable r, @NotNull DomainSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return DomainAssociation.super.ins(r, scope);
    }
}

