/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.javaee.spring.data;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.ml.llm.domains.DomainContext;
import com.intellij.ml.llm.domains.DomainSearchScope;
import com.intellij.ml.llm.domains.context.DomainItemContext;
import com.intellij.ml.llm.domains.ide.presentation.DomainItemPresentation;
import com.intellij.ml.llm.domains.ide.presentation.PresentableProvider;
import com.intellij.ml.llm.domains.mapper.DomainProviderContextMapper;
import com.intellij.ml.llm.java.domains.DomainProviderUtils;
import com.intellij.ml.llm.javaee.spring.data.RepositoryItemPresentation;
import com.intellij.ml.llm.javaee.spring.data.SpringRepositoriesProviderKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.utils.model.RepositoriesSearchUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u001c\u001a\u00020\u0011H\u0016R\u000e\u0010\u0018\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/javaee/spring/data/SpringRepositoriesProvider;", "Lcom/intellij/ml/llm/domains/mapper/DomainProviderContextMapper;", "Lcom/intellij/spring/model/SpringBeanPointer;", "Lcom/intellij/ml/llm/domains/ide/presentation/PresentableProvider;", "<init>", "()V", "getItemPresentation", "Lcom/intellij/ml/llm/domains/ide/presentation/DomainItemPresentation;", "item", "getId", "", "getIcon", "Ljavax/swing/Icon;", "unused", "", "isAvailable", "searchScope", "Lcom/intellij/ml/llm/domains/DomainSearchScope;", "getItems", "", "findItem", "domainContext", "Lcom/intellij/ml/llm/domains/DomainContext;", "findRepository", "TYPE_ID", "asContext", "Lcom/intellij/ml/llm/domains/context/DomainItemContext;", "t", "scope", "Companion", "intellij.ml.llm.javaee.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringRepositoriesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringRepositoriesProvider.kt\ncom/intellij/ml/llm/javaee/spring/data/SpringRepositoriesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1374#2:116\n1460#2,2:117\n1563#2:119\n1634#2,3:120\n1462#2,3:123\n*S KotlinDebug\n*F\n+ 1 SpringRepositoriesProvider.kt\ncom/intellij/ml/llm/javaee/spring/data/SpringRepositoriesProvider\n*L\n72#1:116\n72#1:117,2\n74#1:119\n74#1:120,3\n72#1:123,3\n*E\n"})
public final class SpringRepositoriesProvider
implements DomainProviderContextMapper<SpringBeanPointer<?>>,
PresentableProvider<SpringBeanPointer<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String TYPE_ID;
    @NotNull
    public static final String ID = "Spring Data Repositories";

    public SpringRepositoriesProvider() {
        this.TYPE_ID = "spring-data-repository";
    }

    @Override
    @NotNull
    public DomainItemPresentation getItemPresentation(@NotNull SpringBeanPointer<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Object object = ReadAction.compute(() -> SpringRepositoriesProvider.getItemPresentation$lambda$0(item));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (DomainItemPresentation)object;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public Icon getIcon(boolean unused) {
        Icon icon2 = SpringApiIcons.SpringBean;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SpringBean");
        return icon2;
    }

    @Override
    public boolean isAvailable(@NotNull DomainSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        return SpringLibraryUtil.hasSpringLibrary((Collection)searchScope.getModules());
    }

    @Override
    @NotNull
    public Set<SpringBeanPointer<?>> getItems(@NotNull DomainSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        List<Module> list = searchScope.getModules();
        if (list == null) {
            return SetsKt.emptySet();
        }
        List<Module> modules = list;
        SearchScope scope = searchScope.getScope();
        if (scope instanceof GlobalSearchScope) {
            Object object = ReadAction.compute(() -> SpringRepositoriesProvider.getItems$lambda$0(modules));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
            return (Set)object;
        }
        return SetsKt.emptySet();
    }

    @Override
    @Nullable
    public SpringBeanPointer<?> findItem(@NotNull DomainContext domainContext) {
        Intrinsics.checkNotNullParameter((Object)domainContext, (String)"domainContext");
        return this.findRepository(domainContext);
    }

    private final SpringBeanPointer<?> findRepository(DomainContext domainContext) {
        PsiClass psiClass = DomainProviderUtils.getContainingClass(domainContext);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        JamMemberMeta[] jamMemberMetaArray = new JamMemberMeta[]{SpringRepositoryDefinition.META};
        SpringRepositoryDefinition repository = (SpringRepositoryDefinition)JamService.getJamService((Project)psiClass2.getProject()).getJamElement((PsiElement)psiClass2, jamMemberMetaArray);
        if (repository != null) {
            return BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)repository);
        }
        if (!SpringDataUtil.isRepository((PsiClass)psiClass2)) {
            return null;
        }
        return BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)new SpringRepository(psiClass2));
    }

    @Override
    @NotNull
    public DomainItemContext asContext(@NotNull SpringBeanPointer<?> t, @NotNull DomainSearchScope scope) {
        Intrinsics.checkNotNullParameter(t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        PsiClass aClass = t.getBeanClass();
        if (aClass == null) {
            return DomainItemContext.EMPTY;
        }
        Pair pair = SpringDataUtil.substituteRepositoryTypes((PsiClass)aClass);
        PsiClass entity = pair != null ? (PsiClass)pair.first : null;
        String string = aClass.getName();
        Intrinsics.checkNotNull((Object)string);
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)aClass));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        PsiClass psiClass = entity;
        return DomainItemContext.Companion.create(this.TYPE_ID, string, smartPsiElementPointer).with("class", aClass.getQualifiedName()).with("path", aClass.getContainingFile().getVirtualFile().getPath()).with("repository-methods", SpringRepositoriesProviderKt.access$getMethodNames(t)).with("entity class", psiClass != null ? psiClass.getQualifiedName() : null);
    }

    private static final RepositoryItemPresentation getItemPresentation$lambda$0(SpringBeanPointer $item) {
        return new RepositoryItemPresentation($item);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set getItems$lambda$0(List $modules) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $modules;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Module it = (Module)element$iv$iv;
            boolean bl = false;
            List list = RepositoriesSearchUtil.getAllRepositories((Module)it, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllRepositories(...)");
            Iterable iterable2 = list;
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void repository;
                CommonSpringBean commonSpringBean = (CommonSpringBean)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)repository));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/javaee/spring/data/SpringRepositoriesProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.ml.llm.javaee.spring.data"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

