/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.javaee.spring.data.commands;

import com.intellij.jpa.model.xml.impl.mapping.EntityImpl;
import com.intellij.jpa.model.xml.persistence.mapping.Entity;
import com.intellij.ml.llm.domains.commands.LLMDomainCommand;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.utils.model.RepositoriesSearchUtil;
import com.intellij.spring.model.CommonSpringBean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0016\u0010\u000b\u001a\u00020\u00068\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0016\u0010\r\u001a\u00020\u00068\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/javaee/spring/data/commands/CreateRepositoryForEntityCommand;", "Lcom/intellij/ml/llm/domains/commands/LLMDomainCommand;", "Lcom/intellij/jpa/model/xml/persistence/mapping/Entity;", "<init>", "()V", "providedBy", "", "getProvidedBy", "()Ljava/lang/String;", "id", "getId", "presentableName", "getPresentableName", "generationPrompt", "getGenerationPrompt", "isAvailable", "", "context", "", "isPackable", "intellij.ml.llm.javaee.spring.data"})
public final class CreateRepositoryForEntityCommand
implements LLMDomainCommand<Entity> {
    @NotNull
    private final String providedBy;
    @NotNull
    private final String id;
    @Nls
    @NotNull
    private final String presentableName;
    @Nls
    @NotNull
    private final String generationPrompt;

    public CreateRepositoryForEntityCommand() {
        this.providedBy = "Entities";
        this.id = "RepositoryByEntity";
        this.presentableName = "Generate Spring Data Repository";
        this.generationPrompt = "You MUST generate Spring Data Repository for entity class entity. This repository MUST have methods to search by entity attributes. Generate it in the package package.";
    }

    @Override
    @NotNull
    public String getProvidedBy() {
        return this.providedBy;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    @Override
    @NotNull
    public String getGenerationPrompt() {
        return this.generationPrompt;
    }

    @Override
    public boolean isAvailable(@NotNull Object context2) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2 instanceof EntityImpl && (module = ((EntityImpl)context2).getModule()) != null) {
            for (CommonSpringBean repository : RepositoriesSearchUtil.getAllRepositories((Module)module, (boolean)false)) {
                Pair pair;
                PsiClass resolve2;
                PsiType aClass = repository.getBeanType();
                if (!(aClass instanceof PsiClassType) || (resolve2 = ((PsiClassType)aClass).resolve()) == null) continue;
                PsiClass psiClass = (PsiClass)((EntityImpl)context2).getClazz().getValue();
                String entityClass = psiClass != null ? psiClass.getQualifiedName() : null;
                if (entityClass == null || !Intrinsics.areEqual((Object)entityClass, (pair = SpringDataUtil.substituteRepositoryTypes((PsiClass)resolve2)) != null && (pair = (PsiClass)pair.first) != null ? pair.getQualifiedName() : null)) continue;
                return false;
            }
        }
        return LLMDomainCommand.super.isAvailable(context2);
    }

    @Override
    public boolean isPackable() {
        return true;
    }
}

