/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.common.diff;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.TextDiffType;
import com.intellij.jupyter.core.jupyter.helper.JupyterMarkdownHelperKt;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIDiffGutterRenderer;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffRenderer;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffRendererKt;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.CodeGenerationDiffRenderer;
import com.intellij.ml.llm.codeGeneration.inplace.AIDiffBasedCodeGenerationInteraction;
import com.intellij.ml.llm.codeGeneration.popup.changeNavigation.ChangeNavigation;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0002#$B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J \u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/jupyter/common/diff/AIInJupyterEditorDiffRenderer;", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "initialDocument", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileTypes/FileType;Lcom/intellij/openapi/editor/Document;)V", "getInitialDocument", "()Lcom/intellij/openapi/editor/Document;", "modifiedCells", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "render", "", "withGutter", "", "addGutterIcons", "change", "Lcom/intellij/diff/fragments/LineFragment;", "doRender", "renderInsertedCodeRange", "splitChangesByCells", "", "changes", "createCellFragment", "originalChange", "startLineOffset", "", "endLineOffset", "dispose", "Companion", "AIInJupyterEditorDiffRendererFactory", "intellij.ml.llm.jupyter.common"})
@SourceDebugExtension(value={"SMAP\nAIInJupyterEditorDiffRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIInJupyterEditorDiffRenderer.kt\ncom/intellij/ml/llm/jupyter/common/diff/AIInJupyterEditorDiffRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1#2:195\n1878#3,3:196\n1869#3,2:199\n*S KotlinDebug\n*F\n+ 1 AIInJupyterEditorDiffRenderer.kt\ncom/intellij/ml/llm/jupyter/common/diff/AIInJupyterEditorDiffRenderer\n*L\n125#1:196,3\n164#1:199,2\n*E\n"})
public final class AIInJupyterEditorDiffRenderer
extends AIInEditorDiffRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document initialDocument;
    @NotNull
    private final List<EditorCell> modifiedCells;

    private AIInJupyterEditorDiffRenderer(Editor editor2, Project project2, FileType fileType2, Document initialDocument) {
        super(editor2, project2, fileType2, initialDocument);
        this.initialDocument = initialDocument;
        this.modifiedCells = new ArrayList();
    }

    @Override
    @NotNull
    public Document getInitialDocument() {
        return this.initialDocument;
    }

    @Override
    public void render(boolean withGutter) {
        this.clear();
        this.doRender(withGutter);
    }

    @Override
    protected void addGutterIcons(@NotNull LineFragment change) {
        DiffGutterOperation.Simple simple;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Document document2 = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        int startLine = document3.getLineNumber(change.getStartOffset2());
        String string = document3.getText(new TextRange(document3.getLineStartOffset(startLine), document3.getLineEndOffset(startLine)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String startLineText = string;
        int nextLineOffset = document3.getLineStartOffset(startLine);
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)startLineText)).toString(), (String)"#%%", (boolean)false, (int)2, null)) {
            nextLineOffset = startLine + 1 < document3.getLineCount() ? document3.getLineStartOffset(startLine + 1) : document3.getTextLength();
        }
        DiffGutterOperation.Simple it = simple = new DiffGutterOperation.Simple(this.getEditor(), nextLineOffset, () -> AIInJupyterEditorDiffRenderer.addGutterIcons$lambda$0(change, this));
        boolean bl = false;
        this.getGutterOperations().add((DiffGutterOperation)it);
        simple.update(true);
    }

    private final void doRender(boolean withGutter) {
        ChangeNavigation.Companion.disposeChangeNavigation(this.getEditor());
        String string = this.getInitialDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        List<LineFragment> originalChanges = AIInEditorDiffRendererKt.calculateChanges(string, string2);
        this.setRenderedChanges(this.splitChangesByCells(originalChanges));
        for (LineFragment change : this.getRenderedChanges()) {
            NotebookCellLines.Interval interval;
            NotebookCellInlayManager notebookCellInlayManager;
            boolean deletedRangeIsEmpty = change.getEndLine1() - change.getStartLine1() == 0;
            boolean insertedRangeIsEmpty = change.getEndLine2() - change.getStartLine2() == 0;
            Document document2 = this.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            if (NotebookCellLines.Companion.get(document2).getCell(change.getStartLine2()) == null || (notebookCellInlayManager = NotebookCellInlayManager.Companion.get(this.getEditor())) == null || (notebookCellInlayManager = notebookCellInlayManager.getCell(interval)) == null) continue;
            NotebookCellInlayManager cell = notebookCellInlayManager;
            JupyterMarkdownHelperKt.setMarkdownRendered((EditorCell)cell, (boolean)false);
            this.modifiedCells.add((EditorCell)cell);
            if (!insertedRangeIsEmpty && !deletedRangeIsEmpty) {
                this.renderSimpleModifiedCodeRange(change, withGutter);
                continue;
            }
            if (!insertedRangeIsEmpty) {
                this.renderInsertedCodeRange(change, withGutter);
                continue;
            }
            if (!deletedRangeIsEmpty) {
                this.renderDeletedCodeInlay(change, withGutter);
                continue;
            }
            throw new IllegalStateException("Unexpected change, both deleted and inserted ranges are empty");
        }
    }

    private final void renderInsertedCodeRange(LineFragment change, boolean withGutter) {
        if (withGutter) {
            this.addGutterIcons(change);
        }
        List it = new DiffDrawUtil.LineHighlighterBuilder(this.getEditor(), change.getStartLine2(), change.getEndLine2(), TextDiffType.INSERTED).withGutterMode(new DiffDrawUtil.PaintMode(DiffDrawUtil.BackgroundType.NONE, DiffDrawUtil.BorderType.NONE)).withEditorMode(new DiffDrawUtil.PaintMode(DiffDrawUtil.BackgroundType.DEFAULT, DiffDrawUtil.BorderType.NONE)).withClearThinLineBetweenGutterAndEditor(false).done();
        boolean bl = false;
        List<RangeHighlighter> list = this.getHighlighters();
        Intrinsics.checkNotNull((Object)it);
        list.addAll(it);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LineFragment> splitChangesByCells(List<? extends LineFragment> changes2) {
        List result2 = new ArrayList();
        for (LineFragment lineFragment : changes2) {
            if (lineFragment.getStartLine2() == lineFragment.getEndLine2()) {
                result2.add(lineFragment);
                continue;
            }
            String string = this.getEditor().getDocument().getText(new TextRange(this.getEditor().getDocument().getLineStartOffset(lineFragment.getStartLine2()), this.getEditor().getDocument().getLineEndOffset(lineFragment.getEndLine2() - 1)));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            List lines2 = StringsKt.lines((CharSequence)string);
            int currentStartLine = 0;
            currentStartLine = lineFragment.getStartLine2();
            int currentStartIndex = 0;
            Iterable $this$forEachIndexed$iv = lines2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void line;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv;
                int index = n;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)((CharSequence)line))).toString(), (String)"#%%", (boolean)false, (int)2, null) || index <= 0) continue;
                if (currentStartIndex < index) {
                    result2.add(this.createCellFragment(lineFragment, currentStartIndex, index));
                }
                currentStartLine = lineFragment.getStartLine2() + index;
                currentStartIndex = index;
            }
            if (currentStartIndex >= lines2.size()) continue;
            result2.add(this.createCellFragment(lineFragment, currentStartIndex, lines2.size()));
        }
        return result2;
    }

    private final LineFragment createCellFragment(LineFragment originalChange, int startLineOffset, int endLineOffset) {
        Document document2 = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        int startOffset2 = document3.getLineStartOffset(originalChange.getStartLine2() + startLineOffset);
        int endOffset2 = document3.getLineEndOffset(originalChange.getStartLine2() + endLineOffset - 1);
        return (LineFragment)new LineFragmentImpl(originalChange.getStartLine1(), originalChange.getEndLine1(), originalChange.getStartLine2() + startLineOffset, originalChange.getStartLine2() + endLineOffset, originalChange.getStartOffset1(), originalChange.getEndOffset1(), startOffset2, endOffset2, originalChange.getInnerFragments());
    }

    @Override
    public void dispose() {
        Iterable $this$forEach$iv = this.modifiedCells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it = (EditorCell)element$iv;
            boolean bl = false;
            JupyterMarkdownHelperKt.setMarkdownRendered((EditorCell)it, (boolean)true);
        }
        this.modifiedCells.clear();
        super.dispose();
    }

    private static final GutterIconRenderer addGutterIcons$lambda$0(LineFragment $change, AIInJupyterEditorDiffRenderer this$0) {
        return (GutterIconRenderer)new AIDiffGutterRenderer($change, this$0);
    }

    public /* synthetic */ AIInJupyterEditorDiffRenderer(Editor editor2, Project project2, FileType fileType2, Document initialDocument, DefaultConstructorMarker $constructor_marker) {
        this(editor2, project2, fileType2, initialDocument);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/jupyter/common/diff/AIInJupyterEditorDiffRenderer$AIInJupyterEditorDiffRendererFactory;", "Lcom/intellij/ml/llm/codeGeneration/inplace/AIDiffBasedCodeGenerationInteraction$RendererFactory;", "<init>", "()V", "create", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/CodeGenerationDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "initialText", "", "intellij.ml.llm.jupyter.common"})
    public static final class AIInJupyterEditorDiffRendererFactory
    implements AIDiffBasedCodeGenerationInteraction.RendererFactory {
        @NotNull
        public static final AIInJupyterEditorDiffRendererFactory INSTANCE = new AIInJupyterEditorDiffRendererFactory();

        private AIInJupyterEditorDiffRendererFactory() {
        }

        @Override
        @NotNull
        public CodeGenerationDiffRenderer create(@NotNull Editor editor2, @NotNull Project project2, @Nullable FileType fileType2, @Nullable CharSequence initialText) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return Companion.create(editor2, project2, fileType2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/jupyter/common/diff/AIInJupyterEditorDiffRenderer$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/ml/llm/jupyter/common/diff/AIInJupyterEditorDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "initialContent", "", "intellij.ml.llm.jupyter.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AIInJupyterEditorDiffRenderer create(@NotNull Editor editor2, @NotNull Project project2, @Nullable FileType fileType2, @Nullable CharSequence initialContent) {
            Document initialDocument;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            VirtualFile virtualFile2 = editor2.getVirtualFile();
            Intrinsics.checkNotNull((Object)virtualFile2);
            String string = "initial-" + virtualFile2.getName();
            CharSequence charSequence = initialContent;
            if (charSequence == null) {
                String string2 = editor2.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                charSequence = string2;
            }
            if ((initialDocument = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)new LightVirtualFile(string, fileType2, charSequence)))) == null) {
                throw new IllegalStateException("Cannot create in memory document for comparison");
            }
            initialDocument.setReadOnly(true);
            return new AIInJupyterEditorDiffRenderer(editor2, project2, fileType2, initialDocument, null);
        }

        public static /* synthetic */ AIInJupyterEditorDiffRenderer create$default(Companion companion, Editor editor2, Project project2, FileType fileType2, CharSequence charSequence, int n, Object object) {
            if ((n & 8) != 0) {
                charSequence = null;
            }
            return companion.create(editor2, project2, fileType2, charSequence);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

