/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client;

import com.intellij.ml.llm.mcp.client.McpClientRegistryException;
import com.intellij.ml.llm.mcp.client.McpClientRegistryImplKt;
import com.intellij.ml.llm.mcp.client.McpClientService;
import com.intellij.ml.llm.mcp.client.McpClientSystemRegistry;
import com.intellij.ml.llm.mcp.client.McpServerDescriptor;
import com.intellij.ml.llm.mcp.client.McpSettingsChangedNotification;
import com.intellij.ml.llm.mcp.client.settings.McpApplicationServerConfigurationService;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeSource;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeType;
import com.intellij.ml.llm.mcp.client.settings.McpProjectServerConfigurationService;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfiguration;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationServiceBase;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationSource;
import com.intellij.ml.llm.mcp.client.settings.McpServerURL;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J*\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\r2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/mcp/client/McpClientRegistryImpl;", "Lcom/intellij/ml/llm/mcp/client/McpClientSystemRegistry;", "<init>", "()V", "isLoaded", "", "project", "Lcom/intellij/openapi/project/Project;", "loadedFlow", "Lkotlinx/coroutines/flow/Flow;", "getConfigurations", "", "", "Lcom/intellij/ml/llm/mcp/client/McpServerDescriptor;", "addConfiguration", "descriptor", "addConfigurationInternal", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "updateConfiguration", "", "id", "removeConfiguration", "getConfigurationService", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationServiceBase;", "validate", "configuration", "registerConfiguration", "allowedToolsNames", "", "", "registerConfigurationWithoutPersistence", "Lcom/intellij/openapi/application/AccessToken;", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpClientRegistryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClientRegistryImpl.kt\ncom/intellij/ml/llm/mcp/client/McpClientRegistryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1208#2,2:162\n1236#2,4:164\n1252#2,4:170\n1761#2,3:174\n463#3:168\n413#3:169\n1#4:177\n*S KotlinDebug\n*F\n+ 1 McpClientRegistryImpl.kt\ncom/intellij/ml/llm/mcp/client/McpClientRegistryImpl\n*L\n27#1:162,2\n27#1:164,4\n28#1:170,4\n46#1:174,3\n28#1:168\n28#1:169\n*E\n"})
public final class McpClientRegistryImpl
implements McpClientSystemRegistry {
    @Override
    public boolean isLoaded(@Nullable Project project2) {
        return this.getConfigurationService(project2).isLoaded();
    }

    @Override
    @NotNull
    public Flow<Boolean> loadedFlow(@Nullable Project project2) {
        return (Flow)this.getConfigurationService(project2).getLoadedFlow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Integer, McpServerDescriptor> getConfigurations(@Nullable Project project2) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map map2;
        void $this$associateByTo$iv$iv;
        McpServerConfigurationServiceBase configurationService = this.getConfigurationService(project2);
        Iterable $this$associateBy$iv = configurationService.getConfigurations();
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo22 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            McpServerConfiguration mcpServerConfiguration = (McpServerConfiguration)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getId(), element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        Map capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $i$f$associateByTo22 = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv2;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map2 = map3;
            boolean bl2 = false;
            McpServerDescriptor mcpServerDescriptor = McpClientRegistryImplKt.toDescriptor((McpServerConfiguration)it.getValue());
            map2.put(k, mcpServerDescriptor);
        }
        return destination$iv$iv$iv;
    }

    @Override
    public int addConfiguration(@NotNull McpServerDescriptor descriptor2, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        McpServerConfiguration configuration = this.addConfigurationInternal(descriptor2, project2);
        McpSettingsChangedNotification.INSTANCE.showSettingsChangedNotification(project2, configuration, McpConfigurationChangeType.ADDED);
        return configuration.getId();
    }

    private final McpServerConfiguration addConfigurationInternal(McpServerDescriptor descriptor2, Project project2) {
        boolean bl;
        List<McpServerConfiguration> existingConfigurations;
        McpServerConfigurationServiceBase configurationService;
        McpServerConfiguration configuration;
        block4: {
            configuration = McpClientRegistryImplKt.toConfiguration(descriptor2);
            configuration.setEnabled(false);
            configuration.setSource(McpServerConfigurationSource.PLUGIN);
            this.validate(configuration);
            configurationService = this.getConfigurationService(project2);
            existingConfigurations = configurationService.getConfigurations();
            Iterable $this$any$iv = existingConfigurations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    McpServerConfiguration it = (McpServerConfiguration)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)configuration.getName())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new McpClientRegistryException("Configuration with name " + configuration.getName() + " already exists");
        }
        McpServerConfigurationServiceBase.setConfigurations$default(configurationService, CollectionsKt.plus((Collection)existingConfigurations, (Object)configuration), CollectionsKt.emptyList(), McpConfigurationChangeSource.PLUGIN_API, false, 8, null);
        McpClientRegistryImplKt.access$getLOG$p().debug("Added configuration: " + configuration);
        McpSettingsChangedNotification.INSTANCE.showSettingsChangedNotification(project2, configuration, McpConfigurationChangeType.ADDED);
        return configuration;
    }

    @Override
    public void updateConfiguration(int id, @NotNull McpServerDescriptor descriptor2, @Nullable Project project2) {
        McpServerConfiguration mcpServerConfiguration;
        Object v0;
        List existingConfigurations;
        McpServerConfigurationServiceBase configurationService;
        McpServerConfiguration configuration;
        block7: {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            configuration = McpClientRegistryImplKt.toConfiguration(descriptor2);
            configuration.setEnabled(false);
            configuration.setSource(McpServerConfigurationSource.PLUGIN);
            this.validate(configuration);
            configurationService = this.getConfigurationService(project2);
            existingConfigurations = CollectionsKt.toMutableList((Collection)configurationService.getConfigurations());
            Iterable iterable = existingConfigurations;
            for (Object t : iterable) {
                McpServerConfiguration it = (McpServerConfiguration)t;
                boolean bl = false;
                if (!(it.getId() == id)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        McpServerConfiguration mcpServerConfiguration2 = v0;
        if (mcpServerConfiguration2 == null) {
            throw new McpClientRegistryException("Configuration with id " + id + " not found");
        }
        McpServerConfiguration existingConfiguration = mcpServerConfiguration2;
        if (!Intrinsics.areEqual(existingConfiguration.getClass(), configuration.getClass())) {
            throw new McpClientRegistryException("Cannot change configuration type");
        }
        McpServerConfiguration mcpServerConfiguration3 = existingConfiguration;
        if (mcpServerConfiguration3 instanceof McpServerCommand) {
            mcpServerConfiguration = new McpServerCommand((McpServerCommand)existingConfiguration);
        } else if (mcpServerConfiguration3 instanceof McpServerURL) {
            mcpServerConfiguration = new McpServerURL(existingConfiguration);
        } else {
            throw new McpClientRegistryException("Unknow configuration type.");
        }
        McpServerConfiguration newConfiguration = mcpServerConfiguration;
        newConfiguration.copyFrom(configuration);
        existingConfigurations.set(existingConfigurations.indexOf(existingConfiguration), newConfiguration);
        McpServerConfigurationServiceBase.setConfigurations$default(configurationService, existingConfigurations, CollectionsKt.emptyList(), McpConfigurationChangeSource.PLUGIN_API, false, 8, null);
        McpClientRegistryImplKt.access$getLOG$p().debug("Updated configuration: " + existingConfiguration);
    }

    @Override
    public void removeConfiguration(int id, @Nullable Project project2) {
        Object v0;
        List<McpServerConfiguration> existingConfigurations;
        McpServerConfigurationServiceBase configurationService;
        block2: {
            configurationService = this.getConfigurationService(project2);
            existingConfigurations = configurationService.getConfigurations();
            Iterable iterable = existingConfigurations;
            for (Object t : iterable) {
                McpServerConfiguration it = (McpServerConfiguration)t;
                boolean bl = false;
                if (!(it.getId() == id)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        McpServerConfiguration mcpServerConfiguration = v0;
        if (mcpServerConfiguration == null) {
            throw new McpClientRegistryException("Configuration with id " + id + " not found");
        }
        McpServerConfiguration existingConfiguration = mcpServerConfiguration;
        McpServerConfigurationServiceBase.setConfigurations$default(configurationService, CollectionsKt.minus((Iterable)existingConfigurations, (Object)existingConfiguration), CollectionsKt.emptyList(), McpConfigurationChangeSource.PLUGIN_API, false, 8, null);
        McpClientRegistryImplKt.access$getLOG$p().debug("Removed configuration: " + existingConfiguration);
    }

    private final McpServerConfigurationServiceBase getConfigurationService(Project project2) {
        return project2 == null ? (McpServerConfigurationServiceBase)McpApplicationServerConfigurationService.Companion.getInstance() : (McpServerConfigurationServiceBase)McpProjectServerConfigurationService.Companion.getInstance(project2);
    }

    private final void validate(McpServerConfiguration configuration) {
        if (StringsKt.isBlank((CharSequence)configuration.getName())) {
            throw new McpClientRegistryException("Name cannot be blank");
        }
    }

    @Override
    public void registerConfiguration(@NotNull McpServerDescriptor descriptor2, @Nullable List<String> allowedToolsNames, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        McpServerConfiguration configuration = McpClientRegistryImplKt.toConfiguration(descriptor2);
        configuration.setEnabled(true);
        configuration.setSource(McpServerConfigurationSource.SYSTEM);
        configuration.setAllowedToolsNames(allowedToolsNames);
        this.validate(configuration);
        McpServerConfigurationServiceBase configurationService = this.getConfigurationService(project2);
        McpServerConfigurationServiceBase.setConfigurations$default(configurationService, CollectionsKt.plus((Collection)configurationService.getConfigurations(), (Object)configuration), CollectionsKt.emptyList(), McpConfigurationChangeSource.INTERNAL, false, 8, null);
        McpClientRegistryImplKt.access$getLOG$p().debug("Registered configuration: " + configuration);
    }

    @Override
    @NotNull
    public AccessToken registerConfigurationWithoutPersistence(@NotNull Project project2, @NotNull McpServerDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        McpServerConfiguration configuration = McpClientRegistryImplKt.toConfiguration(descriptor2);
        configuration.setEnabled(true);
        configuration.setSource(McpServerConfigurationSource.SYSTEM);
        this.validate(configuration);
        AccessToken token = McpClientService.McpProjectClientService.Companion.getInstance(project2).registerClient$intellij_ml_llm_mcp(configuration);
        McpClientRegistryImplKt.access$getLOG$p().debug("Registered configuration without persistence: " + configuration);
        return token;
    }
}

