/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.intellij.util.system.OS;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"ALGORITHM", "", "TRANSFORMATION", "GCM_IV_LENGTH", "", "GCM_TAG_LENGTH", "encryptHash", "hash", "decryptHash", "encryptedHash", "deriveKey", "Ljavax/crypto/SecretKey;", "intellij.ml.llm.mcp"})
public final class McpHashEncryptionKt {
    @NotNull
    private static final String ALGORITHM = "AES";
    @NotNull
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;

    @Nullable
    public static final String encryptHash(@NotNull String hash) {
        String string;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        try {
            SecretKey secretKey = McpHashEncryptionKt.deriveKey();
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            byte[] iv = new byte[12];
            new SecureRandom().nextBytes(iv);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, gcmParameterSpec);
            String string2 = hash;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] encryptedData = cipher.doFinal(byArray);
            byte[] result2 = new byte[iv.length + encryptedData.length];
            System.arraycopy(iv, 0, result2, 0, iv.length);
            System.arraycopy(encryptedData, 0, result2, iv.length, encryptedData.length);
            string = Base64.getEncoder().encodeToString(result2);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String decryptHash(@NotNull String encryptedHash) {
        String string;
        Intrinsics.checkNotNullParameter((Object)encryptedHash, (String)"encryptedHash");
        try {
            SecretKey secretKey = McpHashEncryptionKt.deriveKey();
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            byte[] encryptedData = Base64.getDecoder().decode(encryptedHash);
            byte[] iv = new byte[12];
            byte[] encrypted = new byte[encryptedData.length - 12];
            System.arraycopy(encryptedData, 0, iv, 0, 12);
            System.arraycopy(encryptedData, 12, encrypted, 0, encrypted.length);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secretKey, gcmParameterSpec);
            byte[] decryptedData = cipher.doFinal(encrypted);
            Intrinsics.checkNotNull((Object)decryptedData);
            byte[] byArray = decryptedData;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            string = new String(byArray, charset2);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    private static final SecretKey deriveKey() {
        StringBuilder stringBuilder;
        StringBuilder $this$deriveKey_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$deriveKey_u24lambda_u240.append(OS.CURRENT.name());
        $this$deriveKey_u24lambda_u240.append(System.getProperty("user.name", "unknown"));
        $this$deriveKey_u24lambda_u240.append(System.getProperty("user.home", "unknown"));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String machineInfo = string;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        String string2 = machineInfo;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] keyBytes = digest.digest(byArray);
        return new SecretKeySpec(keyBytes, ALGORITHM);
    }
}

