/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.intellij.ml.llm.mcp.client.settings.ConfigurationStateChangeListener;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeSource;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeType;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfiguration;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationServiceBase;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\u0013\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/NotificationConfigurationStateChangeListener;", "Lcom/intellij/ml/llm/mcp/client/settings/ConfigurationStateChangeListener;", "mcpServerConfigurationServiceBase", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationServiceBase;", "<init>", "(Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationServiceBase;)V", "configurationsModified", "", "modifiedStateChanged", "", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "changesSource", "Lcom/intellij/ml/llm/mcp/client/settings/McpConfigurationChangeSource;", "configurationsAdded", "addedStateChanged", "configurationsMoved", "movedStateChanged", "configurationsRemoved", "removedStateChanged", "notify", "stateChanged", "changeType", "Lcom/intellij/ml/llm/mcp/client/settings/McpConfigurationChangeType;", "intellij.ml.llm.mcp"})
public final class NotificationConfigurationStateChangeListener
implements ConfigurationStateChangeListener {
    @NotNull
    private final McpServerConfigurationServiceBase mcpServerConfigurationServiceBase;

    public NotificationConfigurationStateChangeListener(@NotNull McpServerConfigurationServiceBase mcpServerConfigurationServiceBase) {
        Intrinsics.checkNotNullParameter((Object)mcpServerConfigurationServiceBase, (String)"mcpServerConfigurationServiceBase");
        this.mcpServerConfigurationServiceBase = mcpServerConfigurationServiceBase;
    }

    @Override
    public void configurationsModified(@NotNull Collection<? extends McpServerConfiguration> modifiedStateChanged, @NotNull McpConfigurationChangeSource changesSource) {
        Intrinsics.checkNotNullParameter(modifiedStateChanged, (String)"modifiedStateChanged");
        Intrinsics.checkNotNullParameter((Object)((Object)changesSource), (String)"changesSource");
        this.notify(modifiedStateChanged, changesSource, McpConfigurationChangeType.MODIFIED);
    }

    @Override
    public void configurationsAdded(@NotNull Collection<? extends McpServerConfiguration> addedStateChanged, @NotNull McpConfigurationChangeSource changesSource) {
        Intrinsics.checkNotNullParameter(addedStateChanged, (String)"addedStateChanged");
        Intrinsics.checkNotNullParameter((Object)((Object)changesSource), (String)"changesSource");
        this.notify(addedStateChanged, changesSource, McpConfigurationChangeType.ADDED);
    }

    @Override
    public void configurationsMoved(@NotNull Collection<? extends McpServerConfiguration> movedStateChanged, @NotNull McpConfigurationChangeSource changesSource) {
        Intrinsics.checkNotNullParameter(movedStateChanged, (String)"movedStateChanged");
        Intrinsics.checkNotNullParameter((Object)((Object)changesSource), (String)"changesSource");
        this.notify(movedStateChanged, changesSource, McpConfigurationChangeType.MOVED);
    }

    @Override
    public void configurationsRemoved(@NotNull Collection<? extends McpServerConfiguration> removedStateChanged, @NotNull McpConfigurationChangeSource changesSource) {
        Intrinsics.checkNotNullParameter(removedStateChanged, (String)"removedStateChanged");
        Intrinsics.checkNotNullParameter((Object)((Object)changesSource), (String)"changesSource");
        this.notify(removedStateChanged, changesSource, McpConfigurationChangeType.REMOVED);
    }

    private final void notify(Collection<? extends McpServerConfiguration> stateChanged, McpConfigurationChangeSource changesSource, McpConfigurationChangeType changeType) {
        if (!stateChanged.isEmpty()) {
            if (changesSource == McpConfigurationChangeSource.SETTINGS_UI || changesSource == McpConfigurationChangeSource.JSON_USER || changesSource == McpConfigurationChangeSource.INIT) {
                return;
            }
            this.mcpServerConfigurationServiceBase.showSettingsChangedNotification(stateChanged, changeType);
        }
    }
}

