/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0017J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "changes", "", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore$TimestampedChange;", "getRecentChanges", "", "Lcom/intellij/openapi/editor/RangeMarker;", "track", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "dispose", "addNewChange", "start", "", "end", "clearAll", "addChange", "change", "removeOldestIfFull", "findContainingChange", "removeExpiredEntries", "TimestampedChange", "Companion", "intellij.ml.llm.nextEdits.backend"})
@SourceDebugExtension(value={"SMAP\nNextEditUserRecentChangeStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditUserRecentChangeStore.kt\ncom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1563#2:122\n1634#2,3:123\n1869#2,2:126\n*S KotlinDebug\n*F\n+ 1 NextEditUserRecentChangeStore.kt\ncom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore\n*L\n27#1:122\n27#1:123,3\n56#1:126,2\n*E\n"})
public final class NextEditUserRecentChangeStore
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TimestampedChange> changes = new ArrayList();
    @NotNull
    private static final Key<NextEditUserRecentChangeStore> KEY = new Key("next.edit.recentChangeStore");
    private static final long CHANGE_ITEM_TTL_MS = 60000L;
    private static final int MAX_RECENT_CHANGE_PER_EDITOR = 5;

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public final List<RangeMarker> getRecentChanges() {
        void $this$mapTo$iv$iv;
        ThreadingAssertions.assertEventDispatchThread();
        this.removeExpiredEntries();
        Iterable $this$map$iv = this.changes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TimestampedChange timestampedChange = (TimestampedChange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMarker());
        }
        return (List)destination$iv$iv;
    }

    @RequiresEdt
    public final void track(@NotNull DocumentEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ThreadingAssertions.assertEventDispatchThread();
        if (event2.getNewLength() > 0) {
            int start2 = event2.getOffset();
            int end = start2 + event2.getNewLength();
            TimestampedChange timestampedChange = this.findContainingChange(start2, end);
            if (timestampedChange != null) {
                timestampedChange.resetLastUpdatedAt();
            } else {
                this.addNewChange(event2, start2, end);
            }
        }
    }

    @RequiresEdt
    public void dispose() {
        this.clearAll();
    }

    private final void addNewChange(DocumentEvent event2, int start2, int end) {
        RangeMarker rangeMarker;
        RangeMarker it = rangeMarker = event2.getDocument().createRangeMarker(start2, end);
        boolean bl = false;
        it.setGreedyToLeft(true);
        it.setGreedyToRight(true);
        RangeMarker rangeMarker2 = rangeMarker;
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"also(...)");
        RangeMarker rangeMarker3 = rangeMarker2;
        this.addChange(rangeMarker3);
    }

    private final void clearAll() {
        ThreadingAssertions.assertEventDispatchThread();
        Iterable $this$forEach$iv = this.changes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimestampedChange it = (TimestampedChange)element$iv;
            boolean bl = false;
            it.getMarker().dispose();
        }
        this.changes.clear();
    }

    private final void addChange(RangeMarker change) {
        ThreadingAssertions.assertEventDispatchThread();
        this.removeExpiredEntries();
        this.removeOldestIfFull();
        this.changes.add(new TimestampedChange(change, System.currentTimeMillis()));
    }

    private final void removeOldestIfFull() {
        if (!((Collection)this.changes).isEmpty() && this.changes.size() >= 5) {
            this.changes.removeFirst().getMarker().dispose();
        }
    }

    private final TimestampedChange findContainingChange(int start2, int end) {
        Object v0;
        block1: {
            ThreadingAssertions.assertEventDispatchThread();
            long now = System.currentTimeMillis();
            Iterable iterable = this.changes;
            for (Object t : iterable) {
                TimestampedChange it = (TimestampedChange)t;
                boolean bl = false;
                boolean isExpired = now - it.getLastUpdatedAt() >= 60000L;
                boolean isContained = it.getMarker().getStartOffset() <= start2 && end <= it.getMarker().getEndOffset();
                if (!(!isExpired && it.getMarker().isValid() && isContained)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void removeExpiredEntries() {
        long now = System.currentTimeMillis();
        CollectionsKt.removeAll(this.changes, arg_0 -> NextEditUserRecentChangeStore.removeExpiredEntries$lambda$0(now, arg_0));
    }

    private static final boolean removeExpiredEntries$lambda$0(long $now, TimestampedChange entry) {
        boolean isExpired;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        boolean bl = isExpired = $now - entry.getLastUpdatedAt() > 60000L;
        if (isExpired) {
            entry.getMarker().dispose();
        }
        return isExpired;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore;", "CHANGE_ITEM_TTL_MS", "", "MAX_RECENT_CHANGE_PER_EDITOR", "", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "uninstall", "getInstance", "intellij.ml.llm.nextEdits.backend"})
    @SourceDebugExtension(value={"SMAP\nNextEditUserRecentChangeStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditUserRecentChangeStore.kt\ncom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        public final void install(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditUserRecentChangeStore store = new NextEditUserRecentChangeStore();
            editor2.putUserData(KEY, (Object)store);
            EditorUtil.disposeWithEditor((Editor)editor2, () -> Companion.install$lambda$0(editor2));
        }

        @RequiresEdt
        public final void uninstall(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditUserRecentChangeStore nextEditUserRecentChangeStore = (NextEditUserRecentChangeStore)editor2.getUserData(KEY);
            if (nextEditUserRecentChangeStore != null) {
                NextEditUserRecentChangeStore it = nextEditUserRecentChangeStore;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            editor2.putUserData(KEY, null);
        }

        @Nullable
        public final NextEditUserRecentChangeStore getInstance(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (NextEditUserRecentChangeStore)editor2.getUserData(KEY);
        }

        private static final void install$lambda$0(Editor $editor) {
            Companion.uninstall($editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore$TimestampedChange;", "", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "lastUpdatedAt", "", "<init>", "(Lcom/intellij/openapi/editor/RangeMarker;J)V", "getMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "getLastUpdatedAt", "()J", "setLastUpdatedAt", "(J)V", "resetLastUpdatedAt", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.nextEdits.backend"})
    private static final class TimestampedChange {
        @NotNull
        private final RangeMarker marker;
        private long lastUpdatedAt;

        public TimestampedChange(@NotNull RangeMarker marker, long lastUpdatedAt) {
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            this.marker = marker;
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @NotNull
        public final RangeMarker getMarker() {
            return this.marker;
        }

        public final long getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(long l) {
            this.lastUpdatedAt = l;
        }

        public final void resetLastUpdatedAt() {
            this.lastUpdatedAt = System.currentTimeMillis();
        }

        @NotNull
        public final RangeMarker component1() {
            return this.marker;
        }

        public final long component2() {
            return this.lastUpdatedAt;
        }

        @NotNull
        public final TimestampedChange copy(@NotNull RangeMarker marker, long lastUpdatedAt) {
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            return new TimestampedChange(marker, lastUpdatedAt);
        }

        public static /* synthetic */ TimestampedChange copy$default(TimestampedChange timestampedChange, RangeMarker rangeMarker, long l, int n, Object object) {
            if ((n & 1) != 0) {
                rangeMarker = timestampedChange.marker;
            }
            if ((n & 2) != 0) {
                l = timestampedChange.lastUpdatedAt;
            }
            return timestampedChange.copy(rangeMarker, l);
        }

        @NotNull
        public String toString() {
            return "TimestampedChange(marker=" + this.marker + ", lastUpdatedAt=" + this.lastUpdatedAt + ")";
        }

        public int hashCode() {
            int result2 = this.marker.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.lastUpdatedAt);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimestampedChange)) {
                return false;
            }
            TimestampedChange timestampedChange = (TimestampedChange)other;
            if (!Intrinsics.areEqual((Object)this.marker, (Object)timestampedChange.marker)) {
                return false;
            }
            return this.lastUpdatedAt == timestampedChange.lastUpdatedAt;
        }
    }
}

