/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.provider.caches;

import com.intellij.ml.diagnostics.DiagnosticEventBus;
import com.intellij.ml.diagnostics.DiagnosticsEventListener;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditEvent;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditEventListener;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditEventPayload;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditSessionFinished;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditTargetFile;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditTriggered;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.NextEditCache;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.NextEditTrigramSimilarityMatcher;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.RejectedCacheService;
import com.intellij.ml.llm.nextEdits.common.NextEditSessionFinishType;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditSuggestionSimilarityId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditEventListenerForCaches;", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditEventListener;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "sessionInfo", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditEventListenerForCaches$SessionInfo;", "onEvent", "", "event", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditEvent;", "handleSessionFinished", "payload", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionFinished;", "isFullyAccepted", "", "isRejected", "removeSimilarFromCache", "project", "Lcom/intellij/openapi/project/Project;", "suggestionId", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;", "SessionInfo", "Companion", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditCacheEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditCacheEventHandler.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditEventListenerForCaches\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class NextEditEventListenerForCaches
implements NextEditEventListener,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<SessionInfo> sessionInfo = new AtomicReference();
    public static final long MINIMAL_FOR_REJECTION_SHOW_TIME = 10L;

    public NextEditEventListenerForCaches() {
        DiagnosticEventBus.Companion.getInstance().attach((Disposable)this, (DiagnosticsEventListener)this);
    }

    @Override
    public void onEvent(@NotNull NextEditEvent event2) {
        Intrinsics.checkNotNullParameter((Object)((Object)event2), (String)"event");
        NextEditEventPayload payload = event2.getPayload();
        if (payload instanceof NextEditTriggered) {
            this.sessionInfo.set(null);
        } else if (payload instanceof NextEditTargetFile) {
            this.sessionInfo.set(new SessionInfo(event2.getRequestId(), ((NextEditTargetFile)payload).getSuggestionId()));
        } else if (payload instanceof NextEditSessionFinished) {
            this.handleSessionFinished(event2, (NextEditSessionFinished)payload);
        }
    }

    private final void handleSessionFinished(NextEditEvent event2, NextEditSessionFinished payload) {
        SessionInfo sessionInfo;
        block7: {
            block6: {
                SessionInfo sessionInfo2;
                SessionInfo sessionInfo3 = this.sessionInfo.getAndSet(null);
                if (sessionInfo3 == null) break block6;
                SessionInfo it = sessionInfo2 = sessionInfo3;
                boolean bl = false;
                SessionInfo sessionInfo4 = sessionInfo = it.getRequestId() == event2.getRequestId() ? sessionInfo2 : null;
                if (sessionInfo != null) break block7;
            }
            return;
        }
        SessionInfo info = sessionInfo;
        if (this.isFullyAccepted(payload)) {
            this.removeSimilarFromCache(event2.getProject(), info.getSuggestionId());
        } else if (this.isRejected(payload)) {
            RejectedCacheService.Companion.getInstance(event2.getProject()).addRejection(info.getSuggestionId());
        }
    }

    private final boolean isFullyAccepted(NextEditSessionFinished payload) {
        return payload.getFinishType() == NextEditSessionFinishType.ACCEPTED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRejected(NextEditSessionFinished payload) {
        if (payload.getFinishType() != NextEditSessionFinishType.ESCAPE) return false;
        Long l = payload.getShowTime();
        if (l == null) return false;
        long it = ((Number)l).longValue();
        boolean bl = false;
        if (it <= 10L) return false;
        return true;
    }

    private final void removeSimilarFromCache(Project project2, NextEditSuggestionSimilarityId suggestionId) {
        NextEditTrigramSimilarityMatcher matcher = NextEditTrigramSimilarityMatcher.Companion.forSuggestion$default(NextEditTrigramSimilarityMatcher.Companion, suggestionId, null, 2, null);
        NextEditCache.Companion.getInstance(project2).removeIf((Function1<? super NextEditCache.CacheEntry, Boolean>)((Function1)arg_0 -> NextEditEventListenerForCaches.removeSimilarFromCache$lambda$0(matcher, arg_0)));
    }

    private static final boolean removeSimilarFromCache$lambda$0(NextEditTrigramSimilarityMatcher $matcher, NextEditCache.CacheEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return $matcher.isSimilar(entry.getProposal().getSimilarityId());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditEventListenerForCaches$Companion;", "", "<init>", "()V", "MINIMAL_FOR_REJECTION_SHOW_TIME", "", "initOrDoNothing", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditEventListenerForCaches;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.nextEdits.backend"})
    @SourceDebugExtension(value={"SMAP\nNextEditCacheEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditCacheEventHandler.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditEventListenerForCaches$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,107:1\n30#2,2:108\n*S KotlinDebug\n*F\n+ 1 NextEditCacheEventHandler.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditEventListenerForCaches$Companion\n*L\n104#1:108,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditEventListenerForCaches initOrDoNothing(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<NextEditEventListenerForCaches> serviceClass$iv = NextEditEventListenerForCaches.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NextEditEventListenerForCaches)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditEventListenerForCaches$SessionInfo;", "", "requestId", "", "suggestionId", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;", "<init>", "(JLcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;)V", "getRequestId", "()J", "getSuggestionId", "()Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.nextEdits.backend"})
    private static final class SessionInfo {
        private final long requestId;
        @NotNull
        private final NextEditSuggestionSimilarityId suggestionId;

        public SessionInfo(long requestId, @NotNull NextEditSuggestionSimilarityId suggestionId) {
            Intrinsics.checkNotNullParameter((Object)suggestionId, (String)"suggestionId");
            this.requestId = requestId;
            this.suggestionId = suggestionId;
        }

        public final long getRequestId() {
            return this.requestId;
        }

        @NotNull
        public final NextEditSuggestionSimilarityId getSuggestionId() {
            return this.suggestionId;
        }

        public final long component1() {
            return this.requestId;
        }

        @NotNull
        public final NextEditSuggestionSimilarityId component2() {
            return this.suggestionId;
        }

        @NotNull
        public final SessionInfo copy(long requestId, @NotNull NextEditSuggestionSimilarityId suggestionId) {
            Intrinsics.checkNotNullParameter((Object)suggestionId, (String)"suggestionId");
            return new SessionInfo(requestId, suggestionId);
        }

        public static /* synthetic */ SessionInfo copy$default(SessionInfo sessionInfo, long l, NextEditSuggestionSimilarityId nextEditSuggestionSimilarityId, int n, Object object) {
            if ((n & 1) != 0) {
                l = sessionInfo.requestId;
            }
            if ((n & 2) != 0) {
                nextEditSuggestionSimilarityId = sessionInfo.suggestionId;
            }
            return sessionInfo.copy(l, nextEditSuggestionSimilarityId);
        }

        @NotNull
        public String toString() {
            return "SessionInfo(requestId=" + this.requestId + ", suggestionId=" + this.suggestionId + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.requestId);
            result2 = result2 * 31 + this.suggestionId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionInfo)) {
                return false;
            }
            SessionInfo sessionInfo = (SessionInfo)other;
            if (this.requestId != sessionInfo.requestId) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.suggestionId, (Object)sessionInfo.suggestionId);
        }
    }
}

