/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.provider.caches;

import com.intellij.ml.llm.nextEdits.backend.diagnostics.BackendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.NextEditTrigramSimilarityMatcher;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.RejectionCache;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.RejectionCacheChangeItem;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.RejectionCacheDebugInfo;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.RejectionCacheEntry;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.TrigramSimilarityKt;
import com.intellij.ml.llm.nextEdits.common.diff.Change;
import com.intellij.ml.llm.nextEdits.common.diff.Hunk;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditSuggestionSimilarityId;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0014J;\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132#\b\u0002\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00110\u0017H\u0086@\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0086@\u00a2\u0006\u0002\u0010\u001eJ\b\u0010#\u001a\u00020\u001dH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/RejectionCache;", "", "maxSize", "", "expiryMs", "", "<init>", "(IJ)V", "entries", "Lkotlin/collections/ArrayDeque;", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/RejectionCacheEntry;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "LOG", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "addRejection", "", "suggestionId", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;", "(Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isSimilarToRejected", "matchPredicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "e", "(Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clear", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "size", "getDebugItems", "", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/RejectionCacheDebugInfo;", "removeExpiredEntries", "buildDebugInfo", "Companion", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRejectionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RejectionCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/RejectionCache\n+ 2 BackendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n25#2:157\n13#3:158\n116#4,10:159\n116#4,8:169\n125#4:180\n116#4,11:181\n116#4,11:192\n116#4,8:203\n125#4:224\n1761#5,3:177\n1617#5,9:211\n1869#5:220\n1870#5:222\n1626#5:223\n1374#5:225\n1460#5,2:226\n774#5:228\n865#5,2:229\n1563#5:231\n1634#5,3:232\n1462#5,3:235\n1#6:221\n*S KotlinDebug\n*F\n+ 1 RejectionCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/RejectionCache\n*L\n26#1:157\n26#1:158\n34#1:159,10\n65#1:169,8\n65#1:180\n74#1:181,11\n80#1:192,11\n90#1:203,8\n90#1:224\n67#1:177,3\n92#1:211,9\n92#1:220\n92#1:222\n92#1:223\n108#1:225\n108#1:226,2\n109#1:228\n109#1:229,2\n109#1:231\n109#1:232,3\n108#1:235,3\n92#1:221\n*E\n"})
public final class RejectionCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxSize;
    private final long expiryMs;
    @NotNull
    private final ArrayDeque<RejectionCacheEntry> entries;
    @NotNull
    private final Mutex mutex;
    @NotNull
    private final Logger LOG;
    public static final int DEFAULT_MAX_SIZE = 10;
    private static final long REJECTION_EXPIRY_MS = 600000L;

    public RejectionCache(int maxSize, long expiryMs) {
        this.maxSize = maxSize;
        this.expiryMs = expiryMs;
        this.entries = new ArrayDeque();
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        RejectionCache $this$thisNextEditLogger$iv = this;
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RejectionCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = BackendNextEditDiagnosticsLogger.constructor-impl(logger);
    }

    public /* synthetic */ RejectionCache(int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        if ((n2 & 2) != 0) {
            l = 600000L;
        }
        this(n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object addRejection(@NotNull NextEditSuggestionSimilarityId suggestionId, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof addRejection.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ RejectionCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.addRejection(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                trigrams = TrigramSimilarityKt.extractTrigrams(suggestionId);
                debug = this.buildDebugInfo(suggestionId);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = suggestionId;
                $continuation.L$1 = trigrams;
                $continuation.L$2 = debug;
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl36
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                debug = (RejectionCacheDebugInfo)$continuation.L$2;
                trigrams = (Map)$continuation.L$1;
                suggestionId = (NextEditSuggestionSimilarityId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 2 sources

                try {
                    $i$a$-withLock$default-RejectionCache$addRejection$2 = false;
                    this.removeExpiredEntries();
                    entry = new RejectionCacheEntry(suggestionId.getFilePath(), System.currentTimeMillis(), trigrams, debug);
                    result = this.entries.add((Object)entry);
                    while (this.entries.size() > this.maxSize) {
                        this.entries.removeFirst();
                    }
                    var12_14 = Boxing.boxBoolean((boolean)(result != false));
                    return var12_14;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object isSimilarToRejected(@NotNull NextEditSuggestionSimilarityId suggestionId, @NotNull Function1<? super RejectionCacheEntry, Boolean> matchPredicate, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isSimilarToRejected.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ RejectionCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.isSimilarToRejected(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = suggestionId;
                $continuation.L$1 = matchPredicate;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var19_6) {
                    return var19_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                matchPredicate = (Function1)$continuation.L$1;
                suggestionId = (NextEditSuggestionSimilarityId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                try {
                    $i$a$-withLock$default-RejectionCache$isSimilarToRejected$3 = false;
                    this.removeExpiredEntries();
                    $this$any$iv = (Iterable)this.entries;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl41
                    v1 = false;
                    ** GOTO lbl48
lbl41:
                    // 2 sources

                    for (T element$iv : $this$any$iv) {
                        entry = (RejectionCacheEntry)element$iv;
                        $i$a$-any-RejectionCache$isSimilarToRejected$3$hitFound$1 = false;
                        if (!((Boolean)matchPredicate.invoke((Object)entry)).booleanValue()) continue;
                        v1 = true;
                        ** GOTO lbl48
                    }
                    v1 = hitFound = false;
lbl48:
                    // 3 sources

                    if (hitFound) {
                        BackendNextEditDiagnosticsLogger.box-impl(this.LOG).debug("Rejection cache hit for : " + suggestionId.getFilePath());
                    }
                    var16_18 = Boxing.boxBoolean((boolean)(hitFound != false));
                    return var16_18;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object isSimilarToRejected$default(RejectionCache rejectionCache, NextEditSuggestionSimilarityId nextEditSuggestionSimilarityId, Function1 function1, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = arg_0 -> RejectionCache.isSimilarToRejected$lambda$0(nextEditSuggestionSimilarityId, arg_0);
        }
        return rejectionCache.isSimilarToRejected(nextEditSuggestionSimilarityId, (Function1<? super RejectionCacheEntry, Boolean>)function1, (Continuation<? super Boolean>)continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object clear(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof clear.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ RejectionCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.clear((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-RejectionCache$clear$2 = false;
                    this.entries.clear();
                    var6_11 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object size(@NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof size.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ RejectionCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.size((Continuation<? super Integer>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-RejectionCache$size$2 = false;
                    this.removeExpiredEntries();
                    var6_11 = Boxing.boxInt((int)this.entries.size());
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var6_11;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object getDebugItems(@NotNull Continuation<? super List<RejectionCacheDebugInfo>> $completion) {
        if (!($completion instanceof getDebugItems.1)) ** GOTO lbl-1000
        var23_2 = $completion;
        if ((var23_2.label & -2147483648) != 0) {
            var23_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ RejectionCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getDebugItems((Continuation<? super List<RejectionCacheDebugInfo>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var24_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.mutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var24_4) {
                    return var24_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-RejectionCache$getDebugItems$2 = false;
                    this.removeExpiredEntries();
                    $this$mapNotNull$iv = (Iterable)this.entries;
                    $i$f$mapNotNull = false;
                    var8_12 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var13_17 = $this$forEach$iv$iv$iv.iterator();
                    while (var13_17.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = var13_17.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (RejectionCacheEntry)element$iv$iv;
                        $i$a$-mapNotNull-RejectionCache$getDebugItems$2$1 = false;
                        if (it.getDebug() == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    var21_25 = (List)destination$iv$iv;
                    return var21_25;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void removeExpiredEntries() {
        long now = System.currentTimeMillis();
        this.entries.removeIf(arg_0 -> RejectionCache.removeExpiredEntries$lambda$1(arg_0 -> RejectionCache.removeExpiredEntries$lambda$0(now, this, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final RejectionCacheDebugInfo buildDebugInfo(NextEditSuggestionSimilarityId suggestionId) {
        Collection destination$iv$iv;
        if (suggestionId instanceof NextEditSuggestionSimilarityId.LocationAware) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((NextEditSuggestionSimilarityId.LocationAware)suggestionId).getDiff().getHunks();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Change it;
                void $this$filterTo$iv$iv;
                Hunk hunk = (Hunk)element$iv$iv;
                boolean bl = false;
                Iterable $this$filter$iv = hunk.getChanges();
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    it = (Change)element$iv$iv2;
                    boolean bl2 = false;
                    if (!(it.getType() != Change.Type.Context)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Change)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(new RejectionCacheChangeItem(it.getType().name(), it.getContent()));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List changes2 = (List)destination$iv$iv;
        return new RejectionCacheDebugInfo(((NextEditSuggestionSimilarityId.LocationAware)suggestionId).getFilePath(), ((NextEditSuggestionSimilarityId.LocationAware)suggestionId).getOrigin().getOrigin(), changes2);
    }

    private static final boolean isSimilarToRejected$lambda$0(NextEditSuggestionSimilarityId $suggestionId, RejectionCacheEntry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new NextEditTrigramSimilarityMatcher(e.getFilePath(), e.getTrigrams(), null, 4, null).isSimilar($suggestionId);
    }

    private static final boolean removeExpiredEntries$lambda$0(long $now, RejectionCache this$0, RejectionCacheEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $now - it.getRejectionTimestamp() > this$0.expiryMs;
    }

    private static final boolean removeExpiredEntries$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public RejectionCache() {
        this(0, 0L, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/RejectionCache$Companion;", "", "<init>", "()V", "DEFAULT_MAX_SIZE", "", "REJECTION_EXPIRY_MS", "", "intellij.ml.llm.nextEdits.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

