/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.provider.caches;

import com.intellij.ml.llm.nextEdits.backend.provider.caches.RejectionCacheChangeItem;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/RejectionCacheDebugInfo;", "", "filePath", "", "origin", "changes", "", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/RejectionCacheChangeItem;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getFilePath", "()Ljava/lang/String;", "getOrigin", "getChanges", "()Ljava/util/List;", "toHtml", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
public final class RejectionCacheDebugInfo {
    @NotNull
    private final String filePath;
    @NotNull
    private final String origin;
    @NotNull
    private final List<RejectionCacheChangeItem> changes;

    public RejectionCacheDebugInfo(@NotNull String filePath, @NotNull String origin, @NotNull List<RejectionCacheChangeItem> changes2) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        this.filePath = filePath;
        this.origin = origin;
        this.changes = changes2;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final String getOrigin() {
        return this.origin;
    }

    @NotNull
    public final List<RejectionCacheChangeItem> getChanges() {
        return this.changes;
    }

    @NotNull
    public final String toHtml() {
        StringBuilder stringBuilder;
        StringBuilder $this$toHtml_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toHtml_u24lambda_u240.append("File path: <b>" + StringUtil.escapeXmlEntities((String)this.filePath) + "</b><br>").append('\n');
        $this$toHtml_u24lambda_u240.append("Origin: <b>" + StringUtil.escapeXmlEntities((String)this.origin) + "</b><br>").append('\n');
        $this$toHtml_u24lambda_u240.append("Changes:").append('\n');
        $this$toHtml_u24lambda_u240.append("<ul>").append('\n');
        for (RejectionCacheChangeItem c : this.changes) {
            $this$toHtml_u24lambda_u240.append("<li>" + StringUtil.escapeXmlEntities((String)c.getType()) + ": `<b>" + StringUtil.escapeXmlEntities((String)c.getContent()) + "</b>` </li>").append('\n');
        }
        $this$toHtml_u24lambda_u240.append("</ul>").append('\n');
        return stringBuilder.toString();
    }

    @NotNull
    public final String component1() {
        return this.filePath;
    }

    @NotNull
    public final String component2() {
        return this.origin;
    }

    @NotNull
    public final List<RejectionCacheChangeItem> component3() {
        return this.changes;
    }

    @NotNull
    public final RejectionCacheDebugInfo copy(@NotNull String filePath, @NotNull String origin, @NotNull List<RejectionCacheChangeItem> changes2) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        return new RejectionCacheDebugInfo(filePath, origin, changes2);
    }

    public static /* synthetic */ RejectionCacheDebugInfo copy$default(RejectionCacheDebugInfo rejectionCacheDebugInfo, String string, String string2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = rejectionCacheDebugInfo.filePath;
        }
        if ((n & 2) != 0) {
            string2 = rejectionCacheDebugInfo.origin;
        }
        if ((n & 4) != 0) {
            list = rejectionCacheDebugInfo.changes;
        }
        return rejectionCacheDebugInfo.copy(string, string2, list);
    }

    @NotNull
    public String toString() {
        return "RejectionCacheDebugInfo(filePath=" + this.filePath + ", origin=" + this.origin + ", changes=" + this.changes + ")";
    }

    public int hashCode() {
        int result2 = this.filePath.hashCode();
        result2 = result2 * 31 + this.origin.hashCode();
        result2 = result2 * 31 + ((Object)this.changes).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RejectionCacheDebugInfo)) {
            return false;
        }
        RejectionCacheDebugInfo rejectionCacheDebugInfo = (RejectionCacheDebugInfo)other;
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)rejectionCacheDebugInfo.filePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.origin, (Object)rejectionCacheDebugInfo.origin)) {
            return false;
        }
        return Intrinsics.areEqual(this.changes, rejectionCacheDebugInfo.changes);
    }
}

