/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.provider.suggestion.filter;

import com.intellij.ml.llm.nextEdits.backend.provider.suggestion.BackendNextEditFileIteration;
import com.intellij.ml.llm.nextEdits.backend.provider.suggestion.filter.BackendNextEditFileIterationFilter;
import com.intellij.ml.llm.nextEdits.backend.settings.BackendNextEditSettings;
import com.intellij.ml.llm.nextEdits.common.diff.NextEditDiff;
import com.intellij.ml.llm.nextEdits.common.pipeline.NextEditIterationFilterDescriptor;
import com.intellij.openapi.editor.Editor;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0016\u001a\u00020\t*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0012\u001a\u00020\t*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/suggestion/filter/WhitespaceOnlyChangeFilter;", "Lcom/intellij/ml/llm/nextEdits/backend/provider/suggestion/filter/BackendNextEditFileIterationFilter;", "<init>", "()V", "descriptor", "Lcom/intellij/ml/llm/nextEdits/common/pipeline/NextEditIterationFilterDescriptor;", "getDescriptor", "()Lcom/intellij/ml/llm/nextEdits/common/pipeline/NextEditIterationFilterDescriptor;", "enabled", "", "getEnabled", "()Z", "check", "iteration", "Lcom/intellij/ml/llm/nextEdits/backend/provider/suggestion/BackendNextEditFileIteration;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/ml/llm/nextEdits/backend/provider/suggestion/BackendNextEditFileIteration;Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changesOnlyWhitespaces", "Lcom/intellij/ml/llm/nextEdits/common/diff/NextEditDiff;", "getChangesOnlyWhitespaces", "(Lcom/intellij/ml/llm/nextEdits/common/diff/NextEditDiff;)Z", "isWhitespaceOnlyChange", "Lcom/intellij/ml/llm/nextEdits/common/diff/NextEditDiff$Change;", "origin", "intellij.ml.llm.nextEdits.backend"})
@SourceDebugExtension(value={"SMAP\nWhitespaceOnlyChangeFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhitespaceOnlyChangeFilter.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/suggestion/filter/WhitespaceOnlyChangeFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n2746#2,3:38\n1740#2,3:41\n*S KotlinDebug\n*F\n+ 1 WhitespaceOnlyChangeFilter.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/suggestion/filter/WhitespaceOnlyChangeFilter\n*L\n18#1:38,3\n22#1:41,3\n*E\n"})
public final class WhitespaceOnlyChangeFilter
implements BackendNextEditFileIterationFilter {
    @NotNull
    public static final WhitespaceOnlyChangeFilter INSTANCE = new WhitespaceOnlyChangeFilter();

    private WhitespaceOnlyChangeFilter() {
    }

    @Override
    @NotNull
    public NextEditIterationFilterDescriptor getDescriptor() {
        return NextEditIterationFilterDescriptor.CHANGES_ONLY_WHITESPACES;
    }

    @Override
    public boolean getEnabled() {
        return !BackendNextEditSettings.INSTANCE.isWhitespaceOnlyChangesEnabled();
    }

    @Override
    @Nullable
    public Object check(@NotNull BackendNextEditFileIteration iteration, @NotNull Editor editor2, @NotNull Continuation<? super Boolean> $completion) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = iteration.getDiffs();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    NextEditDiff it = (NextEditDiff)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.getChangesOnlyWhitespaces(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return Boxing.boxBoolean((boolean)bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getChangesOnlyWhitespaces(NextEditDiff $this$changesOnlyWhitespaces) {
        NextEditDiff.Change it;
        if (((Collection)$this$changesOnlyWhitespaces.getContentUpdate().getChanges()).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$all$iv = $this$changesOnlyWhitespaces.getContentUpdate().getChanges();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (NextEditDiff.Change)element$iv;
            boolean bl2 = false;
        } while (INSTANCE.isWhitespaceOnlyChange(it, $this$changesOnlyWhitespaces));
        return false;
    }

    private final boolean isWhitespaceOnlyChange(NextEditDiff.Change $this$isWhitespaceOnlyChange, NextEditDiff origin) {
        boolean bl;
        NextEditDiff.Change change = $this$isWhitespaceOnlyChange;
        if (change instanceof NextEditDiff.Change.Insert) {
            bl = StringsKt.isBlank((CharSequence)((NextEditDiff.Change.Insert)$this$isWhitespaceOnlyChange).getNewContent());
        } else if (change instanceof NextEditDiff.Change.Delete) {
            String string = origin.getContentUpdate().getBefore().substring(((NextEditDiff.Change.Delete)$this$isWhitespaceOnlyChange).getStartOffset(), ((NextEditDiff.Change.Delete)$this$isWhitespaceOnlyChange).getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String oldContent = string;
            bl = StringsKt.isBlank((CharSequence)oldContent);
        } else if (change instanceof NextEditDiff.Change.Replace) {
            String string = origin.getContentUpdate().getBefore().substring(((NextEditDiff.Change.Replace)$this$isWhitespaceOnlyChange).getStartOffset(), ((NextEditDiff.Change.Replace)$this$isWhitespaceOnlyChange).getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String oldContent = string;
            bl = StringsKt.isBlank((CharSequence)oldContent) && StringsKt.isBlank((CharSequence)((NextEditDiff.Change.Replace)$this$isWhitespaceOnlyChange).getNewContent());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

