/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.inline.completion.NightlySupport;
import com.intellij.ml.llm.core.license.AiSubscriptionPlan;
import com.intellij.ml.llm.grazie.auth.GrazieAuthFacade;
import com.intellij.ml.llm.grazie.auth.GrazieAuthState;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.BackendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.backend.settings.BackendNextEditSettings;
import com.intellij.ml.llm.nextEdits.backend.settings.NextEditSettingsControllerKt;
import com.intellij.ml.llm.nextEdits.common.settings.NextEditEnablementSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018J\b\u0010\u0019\u001a\u00020\u0007H\u0002J\f\u0010\u001a\u001a\u00020\u0007*\u00020\u001bH\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\t\u0010\u000bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/settings/NextEditSettingsController;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "isEnabled", "", "()Z", "isLicenseApplicable", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "isLicenseApplicable$delegate", "Lkotlin/Lazy;", "enablementSettings", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditEnablementSettings;", "getEnablementSettings", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "enablementSettings$delegate", "tryEnableOrError", "", "settingsChanged", "receiveEnablementSettings", "Lkotlinx/coroutines/flow/Flow;", "isEnabledWithRequirements", "isApplicableLicense", "Lcom/intellij/ml/llm/grazie/auth/GrazieAuthState$Authenticated;", "Companion", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditSettingsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSettingsController.kt\ncom/intellij/ml/llm/nextEdits/backend/settings/NextEditSettingsController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BackendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n1#2:125\n25#3:126\n13#4:127\n*S KotlinDebug\n*F\n+ 1 NextEditSettingsController.kt\ncom/intellij/ml/llm/nextEdits/backend/settings/NextEditSettingsController\n*L\n119#1:126\n119#1:127\n*E\n"})
public final class NextEditSettingsController {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Lazy isLicenseApplicable$delegate;
    @NotNull
    private final Lazy enablementSettings$delegate;
    @NotNull
    private static final Logger LOG;

    public NextEditSettingsController(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.isLicenseApplicable$delegate = LazyKt.lazy(() -> NextEditSettingsController.isLicenseApplicable_delegate$lambda$0(this));
        this.enablementSettings$delegate = LazyKt.lazy(() -> NextEditSettingsController.enablementSettings_delegate$lambda$0(this));
        this.isEnabledWithRequirements();
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NextEditSettingsController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.isLicenseApplicable()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ NextEditSettingsController this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ NextEditSettingsController this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.this$0.settingsChanged();
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean isEnabled() {
        return !NextEditSettingsControllerKt.isNextEditGloballyDisabled() && this.isEnabledWithRequirements();
    }

    @NotNull
    public final StateFlow<Boolean> isLicenseApplicable() {
        Lazy lazy = this.isLicenseApplicable$delegate;
        return (StateFlow)lazy.getValue();
    }

    private final MutableStateFlow<NextEditEnablementSettings> getEnablementSettings() {
        Lazy lazy = this.enablementSettings$delegate;
        return (MutableStateFlow)lazy.getValue();
    }

    public final void tryEnableOrError() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isEnabled()) {
            return;
        }
        BackendNextEditSettings.INSTANCE.setEnabled(true);
        if (!this.isEnabled()) {
            GrazieAuthState it = (GrazieAuthState)GrazieAuthFacade.Companion.getInstance().getAuthState().getValue();
            BackendNextEditDiagnosticsLogger backendNextEditDiagnosticsLogger = BackendNextEditDiagnosticsLogger.box-impl(LOG);
            boolean bl = false;
            GrazieAuthState.Authenticated authenticated = it instanceof GrazieAuthState.Authenticated ? (GrazieAuthState.Authenticated)it : null;
            DiagnosticsLogger.error$default((DiagnosticsLogger)backendNextEditDiagnosticsLogger, (String)StringsKt.trimIndent((String)("\n          Failed to enable Next Edit Suggestions:\n            License=" + (AiSubscriptionPlan)(authenticated != null ? authenticated.getPlan() : null) + "\n            Disabled globally=" + NextEditSettingsControllerKt.isNextEditGloballyDisabled() + "\n            Settings=" + BackendNextEditSettings.INSTANCE.asDebugString() + "\n        ")), null, (int)2, null);
            BackendNextEditSettings.INSTANCE.setEnabled(false);
        }
    }

    public final void settingsChanged() {
        this.getEnablementSettings().setValue((Object)this.getEnablementSettings());
    }

    @NotNull
    public final Flow<NextEditEnablementSettings> receiveEnablementSettings() {
        return (Flow)this.getEnablementSettings();
    }

    private final boolean isEnabledWithRequirements() {
        return (Boolean)this.isLicenseApplicable().getValue() != false && BackendNextEditSettings.INSTANCE.isEnabled();
    }

    private final boolean isApplicableLicense(GrazieAuthState.Authenticated $this$isApplicableLicense) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$isApplicableLicense.getPlan().ordinal()]) {
            case 1 -> true;
            case 2 -> true;
            case 3 -> true;
            case 4 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final NextEditEnablementSettings getEnablementSettings() {
        return new NextEditEnablementSettings(NextEditSettingsControllerKt.isNextEditEnabled(), NextEditSettingsControllerKt.isNextEditGloballyDisabled(), BackendNextEditSettings.INSTANCE.isEnabled(), NightlySupport.INSTANCE.isNightly());
    }

    private static final StateFlow isLicenseApplicable_delegate$lambda$0(NextEditSettingsController this$0) {
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return (StateFlow)StateFlowKt.MutableStateFlow((Object)true);
        }
        return com.intellij.platform.util.coroutines.flow.FlowKt.mapStateIn$default((StateFlow)GrazieAuthFacade.Companion.getInstance().getAuthState(), (CoroutineScope)this$0.scope, null, arg_0 -> NextEditSettingsController.isLicenseApplicable_delegate$lambda$0$0(this$0, arg_0), (int)2, null);
    }

    private static final boolean isLicenseApplicable_delegate$lambda$0$0(NextEditSettingsController this$0, GrazieAuthState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof GrazieAuthState.Authenticated && this$0.isApplicableLicense((GrazieAuthState.Authenticated)it);
    }

    private static final MutableStateFlow enablementSettings_delegate$lambda$0(NextEditSettingsController this$0) {
        return StateFlowKt.MutableStateFlow((Object)this$0.getEnablementSettings());
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = BackendNextEditDiagnosticsLogger.constructor-impl(logger);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/settings/NextEditSettingsController$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ml/llm/nextEdits/backend/settings/NextEditSettingsController;", "intellij.ml.llm.nextEdits.backend"})
    @SourceDebugExtension(value={"SMAP\nNextEditSettingsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSettingsController.kt\ncom/intellij/ml/llm/nextEdits/backend/settings/NextEditSettingsController$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,124:1\n42#2,3:125\n*S KotlinDebug\n*F\n+ 1 NextEditSettingsController.kt\ncom/intellij/ml/llm/nextEdits/backend/settings/NextEditSettingsController$Companion\n*L\n121#1:125,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditSettingsController getInstance() {
            boolean $i$f$service = false;
            Class<NextEditSettingsController> serviceClass$iv = NextEditSettingsController.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (NextEditSettingsController)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AiSubscriptionPlan.values().length];
            try {
                nArray[AiSubscriptionPlan.LITE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiSubscriptionPlan.PRO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiSubscriptionPlan.ENTERPRISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiSubscriptionPlan.FREE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

