/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.common.install;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/nextEdits/common/install/NextEditInstallUtils;", "", "<init>", "()V", "getEditorIfSupported", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "createDisposableWithEditor", "Lcom/intellij/openapi/Disposable;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "disposeWithEditorIfNeeded", "", "isEditorTypeSupported", "", "intellij.ml.llm.nextEdits.common"})
@ApiStatus.Internal
public final class NextEditInstallUtils {
    @NotNull
    public static final NextEditInstallUtils INSTANCE = new NextEditInstallUtils();

    private NextEditInstallUtils() {
    }

    @Nullable
    public final EditorImpl getEditorIfSupported(@NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!(editor2 instanceof EditorImpl) || ((EditorImpl)editor2).isDisposed() || project2.isDisposed() || project2.isDefault() || !this.isEditorTypeSupported(editor2)) {
            return null;
        }
        return (EditorImpl)editor2;
    }

    @NotNull
    public final Disposable createDisposableWithEditor(@NotNull Editor editor2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Disposable disposable = Disposer.newDisposable((String)("Next Edit: file=" + file2.getName() + ", id=" + EditorIdKt.editorIdOrNull((Editor)editor2) + "}"));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        this.disposeWithEditorIfNeeded(disposable2, editor2);
        return disposable2;
    }

    private final void disposeWithEditorIfNeeded(Disposable $this$disposeWithEditorIfNeeded, Editor editor2) {
        AtomicBoolean isDisposed = new AtomicBoolean(false);
        DisposerUtilKt.whenDisposed((Disposable)$this$disposeWithEditorIfNeeded, () -> NextEditInstallUtils.disposeWithEditorIfNeeded$lambda$0(isDisposed));
        EditorUtil.disposeWithEditor((Editor)editor2, () -> NextEditInstallUtils.disposeWithEditorIfNeeded$lambda$1(isDisposed, $this$disposeWithEditorIfNeeded));
    }

    private final boolean isEditorTypeSupported(Editor editor2) {
        boolean isTest = editor2.getEditorKind() == EditorKind.UNTYPED && ApplicationKt.getApplication().isUnitTestMode();
        return editor2.getEditorKind() == EditorKind.MAIN_EDITOR || isTest;
    }

    private static final Unit disposeWithEditorIfNeeded$lambda$0(AtomicBoolean $isDisposed) {
        $isDisposed.set(true);
        return Unit.INSTANCE;
    }

    private static final void disposeWithEditorIfNeeded$lambda$1(AtomicBoolean $isDisposed, Disposable $this_disposeWithEditorIfNeeded) {
        if ($isDisposed.compareAndSet(false, true)) {
            Disposer.dispose((Disposable)$this_disposeWithEditorIfNeeded);
        }
    }
}

