/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.inlay;

import com.intellij.codeInsight.inline.completion.render.InlineCompletionInlayRenderer;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionLineRenderer;
import com.intellij.codeInsight.inline.completion.render.InlineCompletionRenderTextBlock;
import com.intellij.ml.llm.nextEdits.frontend.editor.NextEditRenderingCustomizer;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditRenderingUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.util.Key;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J0\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/inlay/NextEditInlineAdditionInlayRenderer;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionInlayRenderer;", "<init>", "()V", "renderInlineInlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionLineRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "blocks", "", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionRenderTextBlock;", "renderBlockInlay", "Renderer", "Companion", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditInlineAdditionInlayRenderer
implements InlineCompletionInlayRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Integer> COUNTER_KEY;

    @Nullable
    public Inlay<? extends InlineCompletionLineRenderer> renderInlineInlay(@NotNull Editor editor2, int offset, @NotNull List<InlineCompletionRenderTextBlock> blocks) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        if (!NextEditInlineAdditionInlayRenderer.Companion.isUsed(editor2)) {
            return null;
        }
        return editor2.getInlayModel().addInlineElement(offset, true, (EditorCustomElementRenderer)new Renderer(editor2, blocks));
    }

    @Nullable
    public Inlay<? extends InlineCompletionLineRenderer> renderBlockInlay(@NotNull Editor editor2, int offset, @NotNull List<InlineCompletionRenderTextBlock> blocks) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        if (!NextEditInlineAdditionInlayRenderer.Companion.isUsed(editor2)) {
            return null;
        }
        return editor2.getInlayModel().addBlockElement(offset, true, false, 1, (EditorCustomElementRenderer)new Renderer(editor2, blocks));
    }

    static {
        Key key = Key.create((String)"com.intellij.ml.llm.nextEdits.ui.inlay.renderer.counter");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COUNTER_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/inlay/NextEditInlineAdditionInlayRenderer$Companion;", "", "<init>", "()V", "COUNTER_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isUsed", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "use", "", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUsed(Editor editor2) {
            Integer counter = (Integer)editor2.getUserData(COUNTER_KEY);
            return counter != null && counter > 0;
        }

        @RequiresEdt
        public final void use(@NotNull Editor editor2, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            ThreadingAssertions.assertEventDispatchThread();
            Integer n = (Integer)editor2.getUserData(COUNTER_KEY);
            int currentCount = n != null ? n : 0;
            editor2.putUserData(COUNTER_KEY, (Object)(currentCount + 1));
            DisposerUtilKt.whenDisposed((Disposable)disposable, () -> Companion.use$lambda$0(editor2));
        }

        private static final Unit use$lambda$0(Editor $editor) {
            Integer n = (Integer)$editor.getUserData(COUNTER_KEY);
            int newCount = RangesKt.coerceAtLeast((int)((n != null ? n : 0) - 1), (int)0);
            $editor.putUserData(COUNTER_KEY, (Object)(newCount == 0 ? null : Integer.valueOf(newCount)));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/inlay/NextEditInlineAdditionInlayRenderer$Renderer;", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionLineRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "initialBlocks", "", "Lcom/intellij/codeInsight/inline/completion/render/InlineCompletionRenderTextBlock;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "paint", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "beforePaint", "getActualWidth", "", "getFont", "Ljava/awt/Font;", "attributes", "text", "", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Renderer
    extends InlineCompletionLineRenderer {
        public Renderer(@NotNull Editor editor2, @NotNull List<InlineCompletionRenderTextBlock> initialBlocks) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(initialBlocks, (String)"initialBlocks");
            super(editor2, initialBlocks);
        }

        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            if (this.getBlocks().isEmpty() && (inlay.getPlacement() == Inlay.Placement.ABOVE_LINE || inlay.getPlacement() == Inlay.Placement.BELOW_LINE)) {
                this.beforePaint(inlay, g, targetRegion);
            }
            super.paint(inlay, g, targetRegion, textAttributes);
        }

        protected void beforePaint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Editor editor2 = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            g.setColor(NextEditRenderingUtils.INSTANCE.getGreenInlineAdditionColor(editor2));
            if (g.getColor() != null) {
                Integer greenWidth;
                switch (WhenMappings.$EnumSwitchMapping$0[inlay.getPlacement().ordinal()]) {
                    case 1: {
                        Editor editor3 = inlay.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
                        Integer n = this.getActualWidth(editor3, g);
                        break;
                    }
                    case 2: 
                    case 3: {
                        Editor editor4 = inlay.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"getEditor(...)");
                        NextEditRenderingCustomizer nextEditRenderingCustomizer = NextEditRenderingCustomizer.Companion.getOrDefault(editor4);
                        Editor editor5 = inlay.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor5, (String)"getEditor(...)");
                        Integer n = nextEditRenderingCustomizer.getEditorWidth(editor5);
                        break;
                    }
                    default: {
                        Integer n = greenWidth = null;
                    }
                }
                if (greenWidth != null) {
                    g.fillRect(targetRegion.x, targetRegion.y, greenWidth, targetRegion.height);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int getActualWidth(Editor editor2, Graphics g) {
            int n;
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            try {
                double result2 = 0.0;
                for (InlineCompletionRenderTextBlock block : this.getBlocks()) {
                    if (((CharSequence)block.getText()).length() == 0) continue;
                    g2d.setFont(this.getFont(editor2, block.getAttributes(), block.getText()));
                    TextLayout textLayout = new TextLayout(block.getText(), g2d.getFont(), g2d.getFontRenderContext());
                    result2 += (double)textLayout.getAdvance();
                }
                n = Math.max(PaintUtil.RoundingMode.ROUND.round(result2), 1);
            }
            finally {
                g2d.dispose();
            }
            return n;
        }

        private final Font getFont(Editor editor2, TextAttributes attributes, String text2) {
            Font font = editor2.getColorsScheme().getFont(EditorFontType.forJavaStyle((int)attributes.getFontType()));
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            Font original = font;
            Font font2 = UIUtil.getFontWithFallbackIfNeeded((Font)original, (String)text2);
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"getFontWithFallbackIfNeeded(...)");
            return font2;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Inlay.Placement.values().length];
                try {
                    nArray[Inlay.Placement.INLINE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Inlay.Placement.ABOVE_LINE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Inlay.Placement.BELOW_LINE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

