/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.inlay;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.hints.presentation.InputHandler;
import com.intellij.ml.llm.nextEdits.common.NextEditRating;
import com.intellij.ml.llm.nextEdits.frontend.MLLlmNextEditsFrontendIcons;
import com.intellij.ml.llm.nextEdits.frontend.ui.inlay.NextEditRatingControlListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001f\u001a\u00020\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\nH\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\nH\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0018\u0010(\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0014H\u0002J,\u0010+\u001a\u00020\u00162\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00066"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/inlay/RatingInlayRenderer;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "Lcom/intellij/codeInsight/hints/presentation/InputHandler;", "editor", "Lcom/intellij/openapi/editor/Editor;", "controlListener", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/inlay/NextEditRatingControlListener;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/nextEdits/frontend/ui/inlay/NextEditRatingControlListener;)V", "likeHovered", "", "dislikeHovered", "currentRating", "Lcom/intellij/ml/llm/nextEdits/common/NextEditRating;", "myInlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "", "inlay", "getTargetHeight", "", "mouseMoved", "", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "mouseExited", "toggleRating", "rating", "mousePressed", "initialize", "updateState", "hovered", "updateCursor", "getIconScale", "icon", "Ljavax/swing/Icon;", "targetHeight", "getActualIconWidth", "getActualIconHeight", "ceilToInt", "value", "paint", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "iconGap", "getIconGap", "()I", "Companion", "intellij.ml.llm.nextEdits.frontend"})
public final class RatingInlayRenderer
extends HintRenderer
implements InputHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final NextEditRatingControlListener controlListener;
    private boolean likeHovered;
    private boolean dislikeHovered;
    @NotNull
    private NextEditRating currentRating;
    private Inlay<?> myInlay;
    private static final float ICON_SCALE_FACTOR = 0.8f;
    @NotNull
    private static final Icon likeIcon;
    @NotNull
    private static final Icon likeIconActivated;
    @NotNull
    private static final Icon dislikeIcon;
    @NotNull
    private static final Icon dislikeIconActivated;

    public RatingInlayRenderer(@NotNull Editor editor2, @NotNull NextEditRatingControlListener controlListener) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)controlListener, (String)"controlListener");
        super("");
        this.editor = editor2;
        this.controlListener = controlListener;
        this.currentRating = NextEditRating.NOT_RATED;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        float targetIconHeight = this.getTargetHeight();
        return this.getActualIconWidth(likeIcon, targetIconHeight) + this.getIconGap() + this.getActualIconWidth(dislikeIcon, targetIconHeight) + this.getIconGap();
    }

    private final float getTargetHeight() {
        return this.editor.getLineHeight();
    }

    public void mouseMoved(@NotNull MouseEvent event2, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        float targetIconHeight = this.getTargetHeight();
        int likeIconWidth = this.getActualIconWidth(likeIcon, targetIconHeight);
        this.likeHovered = translated.x <= likeIconWidth;
        this.dislikeHovered = translated.x >= likeIconWidth + this.getIconGap();
        this.updateState(this.likeHovered || this.dislikeHovered);
    }

    public void mouseExited() {
        this.likeHovered = false;
        this.dislikeHovered = false;
        this.updateState(false);
    }

    private final void toggleRating(NextEditRating rating) {
        this.currentRating = this.currentRating == rating ? NextEditRating.NOT_RATED : rating;
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentRating.ordinal()]) {
            case 1: {
                this.controlListener.onLike();
                break;
            }
            case 2: {
                this.controlListener.onDislike();
                break;
            }
            case 3: {
                this.controlListener.reset();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void mousePressed(@NotNull MouseEvent event2, @NotNull Point translated) {
        Inlay<?> inlay;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (event2.isConsumed()) {
            return;
        }
        event2.consume();
        if (this.likeHovered) {
            this.toggleRating(NextEditRating.LIKE);
        } else if (this.dislikeHovered) {
            this.toggleRating(NextEditRating.DISLIKE);
        }
        if ((inlay = this.myInlay) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
            inlay = null;
        }
        inlay.update();
    }

    public final void initialize(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        this.myInlay = inlay;
        DisposerUtilKt.whenDisposed((Disposable)((Disposable)inlay), () -> RatingInlayRenderer.initialize$lambda$0(this));
    }

    private final void updateState(boolean hovered) {
        Inlay<?> inlay = this.myInlay;
        if (inlay == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
            inlay = null;
        }
        if (inlay.isValid()) {
            this.updateCursor(hovered);
            Inlay<?> inlay2 = this.myInlay;
            if (inlay2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
                inlay2 = null;
            }
            inlay2.update();
        }
    }

    private final void updateCursor(boolean hovered) {
        Cursor cursor;
        boolean bl = hovered;
        if (bl) {
            cursor = Cursor.getPredefinedCursor(12);
        } else if (!bl) {
            cursor = Cursor.getPredefinedCursor(0);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Cursor cursor2 = cursor;
        Inlay<?> inlay = this.myInlay;
        if (inlay == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
            inlay = null;
        }
        JComponent jComponent = inlay.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent contentComponent = jComponent;
        if (!Intrinsics.areEqual((Object)contentComponent.getCursor(), (Object)cursor2)) {
            UIUtil.setCursor((Component)contentComponent, (Cursor)cursor2);
        }
    }

    private final float getIconScale(Icon icon2, float targetHeight) {
        return targetHeight / (float)icon2.getIconHeight() * 0.8f;
    }

    private final int getActualIconWidth(Icon icon2, float targetHeight) {
        return this.ceilToInt((float)icon2.getIconHeight() * this.getIconScale(icon2, targetHeight));
    }

    private final int getActualIconHeight(Icon icon2, float targetHeight) {
        return this.ceilToInt((float)icon2.getIconHeight() * this.getIconScale(icon2, targetHeight));
    }

    private final int ceilToInt(float value) {
        return (int)Math.ceil((double)value + 0.01);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Icon likeIconToPaint = this.likeHovered || this.currentRating == NextEditRating.LIKE ? likeIconActivated : likeIcon;
        Icon dislikeIconToPaint = this.dislikeHovered || this.currentRating == NextEditRating.DISLIKE ? dislikeIconActivated : dislikeIcon;
        float targetIconHeight = this.getTargetHeight();
        int likeX = r.x;
        int iconHeight = this.getActualIconHeight(likeIconToPaint, targetIconHeight);
        int iconY = r.y + (r.height - iconHeight) / 2;
        Icon scaledLikeIcon = IconUtil.scale((Icon)likeIconToPaint, (Component)this.editor.getContentComponent(), (float)this.getIconScale(likeIconToPaint, targetIconHeight));
        scaledLikeIcon.paintIcon(this.editor.getContentComponent(), g, likeX, iconY);
        int dislikeX = likeX + this.getActualIconWidth(dislikeIconToPaint, targetIconHeight) + this.getIconGap();
        Icon scaledDislikeIcon = IconUtil.scale((Icon)dislikeIconToPaint, (Component)this.editor.getContentComponent(), (float)this.getIconScale(dislikeIconToPaint, targetIconHeight));
        scaledDislikeIcon.paintIcon(this.editor.getContentComponent(), g, dislikeX, iconY);
    }

    private final int getIconGap() {
        return JBUI.scale((int)5);
    }

    private static final Unit initialize$lambda$0(RatingInlayRenderer this$0) {
        this$0.updateState(false);
        return Unit.INSTANCE;
    }

    static {
        Icon icon2 = MLLlmNextEditsFrontendIcons.Like;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Like");
        likeIcon = icon2;
        Icon icon3 = MLLlmNextEditsFrontendIcons.LikeSelected;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"LikeSelected");
        likeIconActivated = icon3;
        Icon icon4 = MLLlmNextEditsFrontendIcons.Dislike;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Dislike");
        dislikeIcon = icon4;
        Icon icon5 = MLLlmNextEditsFrontendIcons.DislikeSelected;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"DislikeSelected");
        dislikeIconActivated = icon5;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/inlay/RatingInlayRenderer$Companion;", "", "<init>", "()V", "ICON_SCALE_FACTOR", "", "likeIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "likeIconActivated", "dislikeIcon", "dislikeIconActivated", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NextEditRating.values().length];
            try {
                nArray[NextEditRating.LIKE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditRating.DISLIKE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditRating.NOT_RATED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

