/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.util;

import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.HorizontallyCroppablePanel;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.TransparentOverlayPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0007J\"\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0007J\u0016\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\bH\u0002J\b\u0010$\u001a\u00020\bH\u0002J\b\u0010%\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/OverEditorPanelFactory;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/Disposable;)V", "isBatch", "", "currentRequests", "", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/TransparentOverlayPanel;", "toDispose", "isDisposed", "attachPanelToOffset", "", "panel", "Ljavax/swing/JComponent;", "topLeftOffset", "", "layerIndex", "attachPanelToPoint", "pointInEditorContent", "Ljava/awt/Point;", "withinBatch", "block", "Lkotlin/Function0;", "requestPanel", "dispose", "flushRequestsInBatch", "computePanelXY", "bindPanelPositionToComponent", "doPositionFloatingComponent", "croppablePanel", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/HorizontallyCroppablePanel;", "assertPossibleToAdd", "assertInBatch", "assertNotDisposed", "Companion", "intellij.ml.llm.nextEdits.frontend"})
@SourceDebugExtension(value={"SMAP\nOverEditorPanelFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverEditorPanelFactory.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/util/OverEditorPanelFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n*L\n1#1,245:1\n1869#2,2:246\n1#3:248\n125#4:249\n*S KotlinDebug\n*F\n+ 1 OverEditorPanelFactory.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/util/OverEditorPanelFactory\n*L\n76#1:246,2\n202#1:249\n*E\n"})
public final class OverEditorPanelFactory
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Editor editor;
    private boolean isBatch;
    @NotNull
    private final List<TransparentOverlayPanel> currentRequests;
    @NotNull
    private final List<TransparentOverlayPanel> toDispose;
    private boolean isDisposed;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger LOG;
    @NotNull
    private static final String OVERLAY_INTERACTIVE_COMPONENT = "OVERLAY_INTERACTIVE_COMPONENT";

    public OverEditorPanelFactory(@NotNull Editor editor2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.editor = editor2;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.currentRequests = new ArrayList();
        this.toDispose = new ArrayList();
    }

    @RequiresEdt
    public final void attachPanelToOffset(@NotNull JComponent panel2, int topLeftOffset, int layerIndex) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        ThreadingAssertions.assertEventDispatchThread();
        Point pointInEditorContent = this.computePanelXY(this.editor, topLeftOffset);
        this.attachPanelToPoint(panel2, pointInEditorContent, layerIndex);
    }

    public static /* synthetic */ void attachPanelToOffset$default(OverEditorPanelFactory overEditorPanelFactory, JComponent jComponent, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = TransparentOverlayPanel.Companion.getDEFAULT_LAYER_INDEX();
        }
        overEditorPanelFactory.attachPanelToOffset(jComponent, n, n2);
    }

    @RequiresEdt
    public final void attachPanelToPoint(@NotNull JComponent panel2, @NotNull Point pointInEditorContent, int layerIndex) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)pointInEditorContent, (String)"pointInEditorContent");
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.assertPossibleToAdd()) {
            return;
        }
        JComponent boundPanel = this.bindPanelPositionToComponent(panel2, pointInEditorContent);
        TransparentOverlayPanel transparentOverlayPanel = new TransparentOverlayPanel(boundPanel, layerIndex);
        int traversed = 0;
        int maxTraverseDepth = 200;
        JBTreeTraverser jBTreeTraverser = UIUtil.uiTraverser((Component)boundPanel);
        Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"uiTraverser(...)");
        Iterable $this$forEach$iv = (Iterable)jBTreeTraverser;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            if (it instanceof JComponent && ((JComponent)it).getClientProperty(OVERLAY_INTERACTIVE_COMPONENT) != null) {
                transparentOverlayPanel.registerInteractiveComponent((JComponent)it);
            }
            if (++traversed <= maxTraverseDepth) continue;
        }
        this.requestPanel(transparentOverlayPanel);
    }

    public static /* synthetic */ void attachPanelToPoint$default(OverEditorPanelFactory overEditorPanelFactory, JComponent jComponent, Point point, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = TransparentOverlayPanel.Companion.getDEFAULT_LAYER_INDEX();
        }
        overEditorPanelFactory.attachPanelToPoint(jComponent, point, n);
    }

    @RequiresEdt
    public final void withinBatch(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.assertNotDisposed()) {
            return;
        }
        if (this.isBatch) {
            block.invoke();
        } else {
            this.isBatch = true;
            block.invoke();
            this.flushRequestsInBatch();
            this.isBatch = false;
        }
    }

    private final void requestPanel(TransparentOverlayPanel panel2) {
        ((Collection)this.currentRequests).add(panel2);
    }

    public void dispose() {
        Container parent;
        block4: {
            Container container2;
            this.assertNotDisposed();
            this.isDisposed = true;
            this.currentRequests.clear();
            if (this.toDispose.isEmpty()) {
                return;
            }
            for (TransparentOverlayPanel it : (Iterable)this.toDispose) {
                boolean bl = false;
                Container container3 = it.getParent();
                if (container3 == null) continue;
                container2 = container3;
                break block4;
            }
            container2 = parent = null;
        }
        if (parent != null) {
            for (TransparentOverlayPanel panel2 : this.toDispose) {
                parent.remove(panel2);
            }
            parent.revalidate();
            parent.repaint();
        }
        this.toDispose.clear();
    }

    private final void flushRequestsInBatch() {
        Container container2;
        block6: {
            if (!(this.editor instanceof EditorImpl)) {
                FrontendNextEditDiagnosticsLogger.error$default(LOG, "Editor must be `EditorImpl`.", null, 2, null);
                return;
            }
            if (this.currentRequests.isEmpty()) {
                return;
            }
            for (TransparentOverlayPanel panel2 : this.currentRequests) {
                ((EditorImpl)this.editor).addLayer((JComponent)panel2, panel2.getLayerIndex());
            }
            for (TransparentOverlayPanel it : (Iterable)this.currentRequests) {
                boolean bl = false;
                Container container3 = it.getParent();
                if (container3 == null) continue;
                container2 = container3;
                break block6;
            }
            container2 = null;
        }
        if (container2 == null) {
            return;
        }
        Container parent = container2;
        for (TransparentOverlayPanel panel3 : this.currentRequests) {
            panel3.setBounds(0, 0, parent.getWidth(), parent.getHeight());
            ((Collection)this.toDispose).add(panel3);
        }
        parent.revalidate();
        parent.repaint();
        this.currentRequests.clear();
    }

    private final Point computePanelXY(Editor editor2, int topLeftOffset) {
        Point point = editor2.offsetToXY(topLeftOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point point2 = point;
        return point2;
    }

    private final JComponent bindPanelPositionToComponent(JComponent panel2, Point pointInEditorContent) {
        HorizontallyCroppablePanel croppablePanel = new HorizontallyCroppablePanel(panel2);
        Function0 bind = () -> OverEditorPanelFactory.bindPanelPositionToComponent$lambda$0(this, pointInEditorContent, croppablePanel);
        bind.invoke();
        this.editor.getScrollingModel().addVisibleAreaListener(arg_0 -> OverEditorPanelFactory.bindPanelPositionToComponent$lambda$1(bind, arg_0), (Disposable)this);
        return croppablePanel;
    }

    private final void doPositionFloatingComponent(Point pointInEditorContent, HorizontallyCroppablePanel croppablePanel) {
        Object object = pointInEditorContent.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Point");
        Point position = (Point)object;
        croppablePanel.setToCropX(Math.max(this.editor.getContentComponent().getVisibleRect().x - position.x, 0));
        Point positionInEditor = SwingUtilities.convertPoint(this.editor.getContentComponent(), position, this.editor.getComponent());
        JComponent jComponent = this.editor.getHeaderComponent();
        positionInEditor.translate(0, -(jComponent != null ? jComponent.getHeight() : 0));
        croppablePanel.setBounds(new Rectangle(positionInEditor, croppablePanel.getPreferredSize()));
        croppablePanel.revalidate();
    }

    private final boolean assertPossibleToAdd() {
        return this.assertNotDisposed() && this.assertInBatch();
    }

    private final boolean assertInBatch() {
        boolean inBatch = this.isBatch;
        if (!inBatch) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "it's impossible to add a panel outside of a batch.", null, 2, null);
        }
        return inBatch;
    }

    private final boolean assertNotDisposed() {
        boolean isDisposed = this.isDisposed;
        if (isDisposed) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "The factory is already disposed.", null, 2, null);
        }
        return !isDisposed;
    }

    private static final Unit bindPanelPositionToComponent$lambda$0(OverEditorPanelFactory this$0, Point $pointInEditorContent, HorizontallyCroppablePanel $croppablePanel) {
        this$0.doPositionFloatingComponent($pointInEditorContent, $croppablePanel);
        return Unit.INSTANCE;
    }

    private static final void bindPanelPositionToComponent$lambda$1(Function0 $bind, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $bind.invoke();
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        LOG = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(Companion.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/OverEditorPanelFactory$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "OVERLAY_INTERACTIVE_COMPONENT", "", "makeComponentInteractive", "", "component", "Ljavax/swing/JComponent;", "makeComponentInteractive$intellij_ml_llm_nextEdits_frontend", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final void makeComponentInteractive$intellij_ml_llm_nextEdits_frontend(@NotNull JComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            component2.putClientProperty(OverEditorPanelFactory.OVERLAY_INTERACTIVE_COMPONENT, new Object());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

