/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.util;

import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditCornersArc;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditHighlightRange;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterOrder;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eH\u0002J \u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aH\u0002J(\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\nH\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/PaintRectangleUnderComponentHighlighterRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "component", "Ljava/awt/Component;", "color", "Ljava/awt/Color;", "arc", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditCornersArc;", "highlights", "", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditHighlightRange;", "<init>", "(Ljava/awt/Component;Ljava/awt/Color;Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditCornersArc;Ljava/util/List;)V", "getOrder", "Lcom/intellij/openapi/editor/markup/CustomHighlighterOrder;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "getShape", "Ljava/awt/Shape;", "rect", "Ljava/awt/Rectangle;", "arcRectRight", "Ljava/awt/geom/Arc2D;", "xCenter", "", "yCenter", "radius", "startAngle", "drawHighlights", "graphics", "Ljava/awt/Graphics2D;", "outerRectangle", "drawHighlight", "highlight", "rectangleFromCorners", "topLeft", "Ljava/awt/Point;", "bottomRight", "intellij.ml.llm.nextEdits.frontend"})
public final class PaintRectangleUnderComponentHighlighterRenderer
implements CustomHighlighterRenderer {
    @NotNull
    private final Component component;
    @Nullable
    private final Color color;
    @NotNull
    private final NextEditCornersArc arc;
    @NotNull
    private final List<NextEditHighlightRange> highlights;

    public PaintRectangleUnderComponentHighlighterRenderer(@NotNull Component component2, @Nullable Color color, @NotNull NextEditCornersArc arc, @NotNull List<? extends NextEditHighlightRange> highlights) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)arc, (String)"arc");
        Intrinsics.checkNotNullParameter(highlights, (String)"highlights");
        this.component = component2;
        this.color = color;
        this.arc = arc;
        this.highlights = highlights;
    }

    @NotNull
    public CustomHighlighterOrder getOrder() {
        return CustomHighlighterOrder.AFTER_BACKGROUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!(g instanceof Graphics2D) || this.component.getParent() == null) {
            return;
        }
        if (this.color == null && this.highlights.isEmpty()) {
            return;
        }
        Rectangle rectangle = SwingUtilities.convertRectangle(this.component.getParent(), this.component.getBounds(), editor2.getContentComponent());
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            Intrinsics.checkNotNull((Object)rectangle);
            Shape shape = this.getShape(rectangle, this.arc);
            if (this.color != null) {
                g2.setColor(this.color);
                g2.fill(shape);
            }
            g2.clip(shape);
            this.drawHighlights(editor2, g2, rectangle);
        }
        finally {
            g2.dispose();
        }
    }

    private final Shape getShape(Rectangle rect, NextEditCornersArc arc) {
        float x = rect.x;
        float y = rect.y;
        float w = rect.width;
        float h = rect.height;
        Path2D.Float path = new Path2D.Float();
        float aTL = arc.getTopLeft();
        float aTR = arc.getTopRight();
        float aBL = arc.getBottomLeft();
        float aBR = arc.getBottomRight();
        path.moveTo(x + (float)arc.getTopLeft(), y);
        path.lineTo(x + w - aTR, y);
        if (arc.getTopRight() > 0) {
            path.append(this.arcRectRight(x + w - aTR, y + aTR, aTR, 90.0f), true);
        }
        path.lineTo(x + w, y + h - aBR);
        if (arc.getBottomRight() > 0) {
            path.append(this.arcRectRight(x + w - aBR, y + h - aBR, aBR, 0.0f), true);
        }
        path.lineTo(x + aBL, y + h);
        if (arc.getBottomLeft() > 0) {
            path.append(this.arcRectRight(x + aBL, y + h - aBL, aBL, 270.0f), true);
        }
        path.lineTo(x, y + aTL);
        if (arc.getTopLeft() > 0) {
            path.append(this.arcRectRight(x + aTL, y + aTL, aTL, 180.0f), true);
        }
        path.closePath();
        return path;
    }

    private final Arc2D arcRectRight(float xCenter, float yCenter, float radius, float startAngle) {
        return new Arc2D.Float(xCenter - radius, yCenter - radius, (float)2 * radius, (float)2 * radius, startAngle, -90.0f, 0);
    }

    private final void drawHighlights(Editor editor2, Graphics2D graphics, Rectangle outerRectangle) {
        for (NextEditHighlightRange highlight2 : this.highlights) {
            this.drawHighlight(editor2, graphics, outerRectangle, highlight2);
        }
    }

    private final void drawHighlight(Editor editor2, Graphics2D g, Rectangle outerRectangle, NextEditHighlightRange highlight2) {
        Rectangle rectangle;
        Object object = editor2.getColorsScheme().getAttributes(highlight2.getAttributesKey());
        if (object == null || (object = object.getBackgroundColor()) == null) {
            return;
        }
        Object color = object;
        NextEditHighlightRange nextEditHighlightRange = highlight2;
        if (nextEditHighlightRange instanceof NextEditHighlightRange.Range) {
            Point point = editor2.offsetToXY(((NextEditHighlightRange.Range)highlight2).getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
            topLeft = point;
            Point point2 = editor2.offsetToXY(((NextEditHighlightRange.Range)highlight2).getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
            bottomRight = point2;
            bottomRight.translate(0, editor2.getLineHeight());
            rectangle = this.rectangleFromCorners(topLeft, bottomRight);
        } else if (nextEditHighlightRange instanceof NextEditHighlightRange.Line) {
            Point point = editor2.offsetToXY(((NextEditHighlightRange.Line)highlight2).getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
            topLeft = point;
            bottomRight = new Point(outerRectangle.x + outerRectangle.width, topLeft.y + editor2.getLineHeight());
            rectangle = this.rectangleFromCorners(topLeft, bottomRight);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Rectangle highlightRectangle = rectangle;
        if (highlightRectangle != null) {
            g.setColor((Color)color);
            g.fill(highlightRectangle);
        }
    }

    private final Rectangle rectangleFromCorners(Point topLeft, Point bottomRight) {
        if (topLeft.x >= bottomRight.x || topLeft.y >= bottomRight.y) {
            return null;
        }
        return new Rectangle(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
    }
}

