/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.monolith.promotion;

import com.intellij.lang.Language;
import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.license.AiSubscriptionPlan;
import com.intellij.ml.llm.grazie.auth.GrazieAuthFacade;
import com.intellij.ml.llm.grazie.auth.GrazieAuthState;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.BackendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.backend.settings.lang.NextEditLanguageSettings;
import com.intellij.ml.llm.nextEdits.common.settings.CommonNextEditSettingsUtils;
import com.intellij.ml.llm.nextEdits.monolith.MonolithNextEditBundle;
import com.intellij.ml.llm.nextEdits.monolith.promotion.EnableNextEditAction;
import com.intellij.ml.llm.nextEdits.monolith.promotion.NavigateToNextEditSettingsAction;
import com.intellij.ml.llm.nextEdits.monolith.promotion.NextEditPromotionManager;
import com.intellij.ml.llm.nextEdits.monolith.promotion.NextEditPromotionState;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\b\u0010\u000b\u001a\u00020\nH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "showPromotionIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "isAppropriateLanguage", "", "isApplicableLicense", "doShowPromotion", "showInSettings", "actionEvent", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.ml.llm.nextEdits.monolith"})
@SourceDebugExtension(value={"SMAP\nNextEditOptInPromoter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditOptInPromoter.kt\ncom/intellij/ml/llm/nextEdits/monolith/promotion/NextEditOptInPromoterKt\n+ 2 BackendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n25#2:183\n13#3:184\n*S KotlinDebug\n*F\n+ 1 NextEditOptInPromoter.kt\ncom/intellij/ml/llm/nextEdits/monolith/promotion/NextEditOptInPromoterKt\n*L\n39#1:183\n39#1:184\n*E\n"})
public final class NextEditOptInPromoterKt {
    @NotNull
    private static final Logger LOG;

    private static final void showPromotionIfNeeded(Project project2, Language language) {
        ThreadingAssertions.assertEventDispatchThread();
        NextEditPromotionState promotionState = NextEditPromotionState.Companion.getInstance();
        if (promotionState.isPromoted() || !NextEditOptInPromoterKt.isAppropriateLanguage(language) || !NextEditOptInPromoterKt.isApplicableLicense()) {
            return;
        }
        promotionState.firePromoted();
        NextEditOptInPromoterKt.doShowPromotion(project2);
    }

    private static final boolean isAppropriateLanguage(Language language) {
        NextEditLanguageSettings nextEditLanguageSettings = NextEditLanguageSettings.Companion.getOrNull(language);
        return nextEditLanguageSettings != null ? nextEditLanguageSettings.isEnabledByDefault() : false;
    }

    private static final boolean isApplicableLicense() {
        GrazieAuthState authState = (GrazieAuthState)GrazieAuthFacade.Companion.getInstance().getAuthState().getValue();
        if (!(authState instanceof GrazieAuthState.Authenticated)) {
            return false;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[((GrazieAuthState.Authenticated)authState).getPlan().ordinal()]) {
            case 1, 2 -> true;
            case 3, 4 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void doShowPromotion(Project project2) {
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("llm.next.edit");
        if (group == null) {
            DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"Cannot find notification group", null, (int)2, null);
            return;
        }
        String title = MonolithNextEditBundle.message("next.edit.opt.in.promotion.notification.title", new Object[0]);
        String content2 = MonolithNextEditBundle.message("next.edit.opt.in.promotion.notification.content", new Object[0]);
        NotificationType type2 = NotificationType.INFORMATION;
        Icon icon2 = AIAssistantBranding.Logo16Colored;
        String string = group.getDisplayId();
        NotificationFullContent notification2 = new NotificationFullContent(title, content2, type2, string){};
        notification2.setIcon(icon2);
        notification2.addAction((AnAction)new EnableNextEditAction());
        notification2.addAction((AnAction)new NavigateToNextEditSettingsAction());
        notification2.notify(project2);
    }

    private static final void showInSettings(AnActionEvent actionEvent) {
        Project project2 = (Project)actionEvent.getDataContext().getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        CommonNextEditSettingsUtils.INSTANCE.openSettingsDialog(project3);
    }

    public static final /* synthetic */ void access$showPromotionIfNeeded(Project project2, Language language) {
        NextEditOptInPromoterKt.showPromotionIfNeeded(project2, language);
    }

    public static final /* synthetic */ void access$showInSettings(AnActionEvent actionEvent) {
        NextEditOptInPromoterKt.showInSettings(actionEvent);
    }

    static {
        NextEditPromotionManager.Companion $this$thisNextEditLogger$iv = NextEditPromotionManager.Companion;
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NextEditPromotionManager.Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = BackendNextEditDiagnosticsLogger.constructor-impl(logger);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AiSubscriptionPlan.values().length];
            try {
                nArray[AiSubscriptionPlan.LITE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiSubscriptionPlan.PRO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiSubscriptionPlan.FREE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiSubscriptionPlan.ENTERPRISE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

