/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.php.context.symfony;

import com.intellij.ml.llm.grazie.tasks.documentation.DatabaseSection;
import com.intellij.ml.llm.grazie.tasks.documentation.PhpFrameworkContext;
import com.intellij.ml.llm.php.privacy.extensions.ComposerInstalledPackagesPrivacySafeService;
import com.intellij.ml.llm.php.privacy.extensions.InstalledPackagePrivacySafe;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.std.MatchGroupWrapper;
import com.intellij.ml.llm.privacy.extensions.std.RegexKtKt;
import com.intellij.ml.llm.privacy.extensions.vfs.VirtualFileFilteringPrivacyWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"ENTITY_DIR_PATH", "", "SRC_DIR_PATH", "BUNDLES_PATH", "ENV_PATH", "getFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getEntityByName", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "name", "getDescriptionOfTemplates", "controllerContent", "getDescriptionOfRoutes", "getSymfonyVersion", "Lcom/intellij/ml/llm/privacy/PSString;", "getDescriptionOfBundles", "getEnvironmentDescription", "Lcom/intellij/ml/llm/grazie/tasks/documentation/DatabaseSection;", "isSymfonySmartChatEndPointAvailable", "", "symfonyFramework", "Lcom/intellij/ml/llm/grazie/tasks/documentation/PhpFrameworkContext$Symfony;", "intellij.ml.llm.php"})
@SourceDebugExtension(value={"SMAP\nPhpSymfonyContextUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpSymfonyContextUtil.kt\ncom/intellij/ml/llm/php/context/symfony/PhpSymfonyContextUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n295#2,2:90\n1#3:92\n*S KotlinDebug\n*F\n+ 1 PhpSymfonyContextUtil.kt\ncom/intellij/ml/llm/php/context/symfony/PhpSymfonyContextUtilKt\n*L\n39#1:90,2\n*E\n"})
public final class PhpSymfonyContextUtilKt {
    @NotNull
    private static final String ENTITY_DIR_PATH = "Entity";
    @NotNull
    private static final String SRC_DIR_PATH = "src";
    @NotNull
    private static final String BUNDLES_PATH = "config/bundles.php";
    @NotNull
    private static final String ENV_PATH = ".env";

    private static final List<VirtualFile> getFiles(Project project2) {
        List files = new ArrayList();
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project2);
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile projectDir = virtualFile2;
        ProjectFileIndex.getInstance((Project)project2).iterateContentUnderDirectory(projectDir, arg_0 -> PhpSymfonyContextUtilKt.getFiles$lambda$0(files, arg_0), PhpSymfonyContextUtilKt::getFiles$lambda$1);
        return files;
    }

    @Nullable
    public static final PhpClass getEntityByName(@NotNull Project project2, @NotNull String name) {
        Object v4;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = PhpSymfonyContextUtilKt.getFiles(project2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                CharSequence charSequence = string2;
                String string3 = name.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) continue;
                v4 = element$iv;
                break block2;
            }
            v4 = null;
        }
        VirtualFile virtualFile2 = v4;
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        PsiFile it = VirtualFileUtil.findPsiFile((VirtualFile)file2, (Project)project2);
        boolean bl = false;
        return (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)it), PhpClass.class);
    }

    @NotNull
    public static final String getDescriptionOfTemplates(@NotNull String controllerContent) {
        Intrinsics.checkNotNullParameter((Object)controllerContent, (String)"controllerContent");
        Regex regex = new Regex("render\\('(.*)'");
        Sequence matches = Regex.findAll$default((Regex)regex, (CharSequence)controllerContent, (int)0, (int)2, null);
        String views = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)matches, PhpSymfonyContextUtilKt::getDescriptionOfTemplates$lambda$0), null, null, null, (int)0, null, null, (int)63, null);
        if (((CharSequence)views).length() == 0) {
            return "";
        }
        return "has views " + views;
    }

    @NotNull
    public static final String getDescriptionOfRoutes(@NotNull String controllerContent) {
        Intrinsics.checkNotNullParameter((Object)controllerContent, (String)"controllerContent");
        Regex regex = new Regex("Route\\(['\"](.*?)[\"']");
        Sequence matches = Regex.findAll$default((Regex)regex, (CharSequence)controllerContent, (int)0, (int)2, null);
        return "has routes: " + SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)matches, PhpSymfonyContextUtilKt::getDescriptionOfRoutes$lambda$0), null, null, null, (int)0, null, null, (int)63, null) + ".";
    }

    private static final PSString getSymfonyVersion(Project project2) {
        Object v0;
        block2: {
            Iterable iterable = ComposerInstalledPackagesPrivacySafeService.Companion.getAllInstalledPackages(project2);
            for (Object t : iterable) {
                InstalledPackagePrivacySafe it = (InstalledPackagePrivacySafe)t;
                boolean bl = false;
                if (!it.getName().startsWith((CharSequence)"symfony/framework-bundle")) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        InstalledPackagePrivacySafe installedPackagePrivacySafe = v0;
        if (installedPackagePrivacySafe == null) {
            return null;
        }
        InstalledPackagePrivacySafe symfony = installedPackagePrivacySafe;
        return symfony.getVersion();
    }

    @Nullable
    public static final PSString getDescriptionOfBundles(@NotNull Project project2) {
        VirtualFile virtualFile2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project2).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            Object[] objectArray = virtualFileArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile it = (VirtualFile)objectArray[i];
                boolean bl = false;
                virtualFile2 = it.findFileByRelativePath(BUNDLES_PATH);
                if (virtualFile2 == null) {
                    continue;
                }
                break block4;
            }
            virtualFile2 = null;
        }
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile bundles = virtualFile2;
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(bundles);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiBundles = psiFile;
        return ExtensionsKtKt.getPrivacySafe((PsiNamedElement)psiBundles).getText();
    }

    private static final DatabaseSection getEnvironmentDescription(Project project2) {
        VirtualFileFilteringPrivacyWrapper virtualFileFilteringPrivacyWrapper;
        VirtualFileFilteringPrivacyWrapper virtualFileFilteringPrivacyWrapper2;
        block5: {
            VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project2).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            Object[] objectArray = virtualFileArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile it = (VirtualFile)objectArray[i];
                boolean bl = false;
                virtualFileFilteringPrivacyWrapper2 = it.findFileByRelativePath(ENV_PATH);
                if (virtualFileFilteringPrivacyWrapper2 == null) {
                    continue;
                }
                break block5;
            }
            virtualFileFilteringPrivacyWrapper2 = virtualFileFilteringPrivacyWrapper = null;
        }
        if (virtualFileFilteringPrivacyWrapper2 == null || (virtualFileFilteringPrivacyWrapper = ExtensionsKtKt.privacySafe(virtualFileFilteringPrivacyWrapper, project2)) == null || (virtualFileFilteringPrivacyWrapper = virtualFileFilteringPrivacyWrapper.readText()) == null) {
            return null;
        }
        VirtualFileFilteringPrivacyWrapper env = virtualFileFilteringPrivacyWrapper;
        Object object = RegexKtKt.findPrivacySafe((Regex)new Regex("DATABASE_URL=([^:/\n]*)"), (PrivacySafe)((PrivacySafe)env));
        if (object == null || (object = object.getGroups()) == null || (object = (MatchGroupWrapper)object.get(1)) == null || (object = object.getValue()) == null) {
            return null;
        }
        Object dbName = object;
        if (((CharSequence)dbName).length() == 0) {
            return null;
        }
        return new DatabaseSection((PSString)dbName);
    }

    public static final boolean isSymfonySmartChatEndPointAvailable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return PlatformUtils.isPhpStorm() && Registry.Companion.is("llm.smartChat.endpointEnabled.php.framework.context") && PhpSymfonyContextUtilKt.getSymfonyVersion(project2) != null;
    }

    @Nullable
    public static final PhpFrameworkContext.Symfony symfonyFramework(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PSString pSString = PhpSymfonyContextUtilKt.getSymfonyVersion(project2);
        if (pSString == null) {
            return null;
        }
        PSString version = pSString;
        DatabaseSection dataBases = PhpSymfonyContextUtilKt.getEnvironmentDescription(project2);
        return new PhpFrameworkContext.Symfony(version, dataBases);
    }

    private static final boolean getFiles$lambda$0(List $files, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isDirectory()) {
            return true;
        }
        return $files.add(it);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getFiles$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)ENTITY_DIR_PATH, (boolean)false, (int)2, null)) return false;
        String string2 = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)SRC_DIR_PATH, (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final String getDescriptionOfTemplates$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getGroupValues().get(0);
    }

    private static final String getDescriptionOfRoutes$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getGroupValues().get(1);
    }
}

