/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.fileContentReaders;

import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.fileContentReaders.PrivacyReader;
import com.intellij.ml.llm.privacy.fileContentReaders.RedactingPrivacyReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00028\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader;", "T", "R", "", "Lcom/intellij/ml/llm/privacy/fileContentReaders/PrivacyReader;", "<init>", "()V", "getSourceFile", "Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult;", "entity", "(Ljava/lang/Object;)Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult;", "isPrivate", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/Object;Lcom/intellij/openapi/project/Project;)Z", "SourceFileResult", "intellij.ml.llm.privacy"})
public abstract class SourceFileBasedPrivacyReader<T, R extends CharSequence>
implements PrivacyReader<T, R> {
    @NotNull
    public abstract SourceFileResult getSourceFile(T var1);

    public final boolean isPrivate(T entity, @Nullable Project project2) {
        return this.getSourceFile(entity).isPrivate(project2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \t2\u00020\u0001:\u0004\u0006\u0007\b\tJ\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u0082\u0001\u0003\n\u000b\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult;", "", "isPrivate", "", "project", "Lcom/intellij/openapi/project/Project;", "Failure", "NoSourceFile", "Success", "Companion", "Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult$Failure;", "Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult$NoSourceFile;", "Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult$Success;", "intellij.ml.llm.privacy"})
    public static sealed interface SourceFileResult {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        default public boolean isPrivate(@Nullable Project project2) {
            boolean bl;
            SourceFileResult sourceFileResult = this;
            if (sourceFileResult instanceof Failure) {
                return true;
            }
            if (sourceFileResult instanceof NoSourceFile) {
                return false;
            }
            if (!(sourceFileResult instanceof Success)) throw new NoWhenBranchMatchedException();
            if (project2 == null) return false;
            boolean blocked = bl = PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, ((Success)this).getSourceFile());
            boolean bl2 = false;
            String string = ((Success)this).getSourceFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            RedactingPrivacyReader.Companion.logFileAccess(string, !blocked);
            if (!bl) return false;
            return true;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult$Companion;", "", "<init>", "()V", "noSourceFileIfNull", "Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.ml.llm.privacy"})
        @SourceDebugExtension(value={"SMAP\nSourceFileBasedPrivacyReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFileBasedPrivacyReader.kt\ncom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final SourceFileResult noSourceFileIfNull(@Nullable VirtualFile sourceFile) {
                SourceFileResult sourceFileResult;
                VirtualFile virtualFile2 = sourceFile;
                if (virtualFile2 != null) {
                    VirtualFile it = virtualFile2;
                    boolean bl = false;
                    sourceFileResult = new Success(it);
                } else {
                    sourceFileResult = NoSourceFile.INSTANCE;
                }
                return sourceFileResult;
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult$Failure;", "Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.privacy"})
        public static final class Failure
        implements SourceFileResult {
            @NotNull
            public static final Failure INSTANCE = new Failure();

            private Failure() {
            }

            @NotNull
            public String toString() {
                return "Failure";
            }

            public int hashCode() {
                return 815298368;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure cfr_ignored_0 = (Failure)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult$NoSourceFile;", "Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.privacy"})
        public static final class NoSourceFile
        implements SourceFileResult {
            @NotNull
            public static final NoSourceFile INSTANCE = new NoSourceFile();

            private NoSourceFile() {
            }

            @NotNull
            public String toString() {
                return "NoSourceFile";
            }

            public int hashCode() {
                return 253990114;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoSourceFile)) {
                    return false;
                }
                NoSourceFile cfr_ignored_0 = (NoSourceFile)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult$Success;", "Lcom/intellij/ml/llm/privacy/fileContentReaders/SourceFileBasedPrivacyReader$SourceFileResult;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getSourceFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.privacy"})
        public static final class Success
        implements SourceFileResult {
            @NotNull
            private final VirtualFile sourceFile;

            public Success(@NotNull VirtualFile sourceFile) {
                Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
                this.sourceFile = sourceFile;
            }

            @NotNull
            public final VirtualFile getSourceFile() {
                return this.sourceFile;
            }

            @NotNull
            public final VirtualFile component1() {
                return this.sourceFile;
            }

            @NotNull
            public final Success copy(@NotNull VirtualFile sourceFile) {
                Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
                return new Success(sourceFile);
            }

            public static /* synthetic */ Success copy$default(Success success, VirtualFile virtualFile2, int n, Object object) {
                if ((n & 1) != 0) {
                    virtualFile2 = success.sourceFile;
                }
                return success.copy(virtualFile2);
            }

            @NotNull
            public String toString() {
                return "Success(sourceFile=" + this.sourceFile + ")";
            }

            public int hashCode() {
                return this.sourceFile.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.sourceFile, (Object)success.sourceFile);
            }
        }
    }
}

