/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.inlinePromptDetector;

import com.intellij.ml.llm.inlinePromptDetector.InlinePromptCustomDetector;
import com.intellij.ml.llm.python.inlinePromptDetector.PythonInlinePromptInUnresolvedSymbolContextKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\nH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nH\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/python/inlinePromptDetector/PythonInlinePromptDetector;", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptCustomDetector;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "findInlinePrompts", "Lkotlin/sequences/Sequence;", "", "Lcom/intellij/openapi/util/TextRange;", "targetRanges", "findInlinePromptInRange", "range", "isFullLinePrompt", "findContextPrompt", "findPromptFinishOffset", "", "postfixLeafs", "Lcom/intellij/psi/PsiElement;", "(Lkotlin/sequences/Sequence;)Ljava/lang/Integer;", "intellij.ml.llm.python.inlinePromptDetector"})
@SourceDebugExtension(value={"SMAP\nPythonInlinePromptInUnresolvedSymbolContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonInlinePromptInUnresolvedSymbolContext.kt\ncom/intellij/ml/llm/python/inlinePromptDetector/PythonInlinePromptDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,135:1\n183#2,2:136\n183#2,2:138\n*S KotlinDebug\n*F\n+ 1 PythonInlinePromptInUnresolvedSymbolContext.kt\ncom/intellij/ml/llm/python/inlinePromptDetector/PythonInlinePromptDetector\n*L\n97#1:136,2\n121#1:138,2\n*E\n"})
public final class PythonInlinePromptDetector
implements InlinePromptCustomDetector,
DumbAware {
    public boolean isApplicable(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!PythonInlinePromptInUnresolvedSymbolContextKt.getKillSwitchForPython()) {
            return false;
        }
        return Intrinsics.areEqual((Object)file2.getLanguage(), (Object)PythonLanguage.INSTANCE) || Intrinsics.areEqual((Object)file2.getLanguage().getDisplayName(), (Object)"Jupyter");
    }

    @NotNull
    public Sequence<List<TextRange>> findInlinePrompts(@NotNull PsiFile file2, @NotNull Sequence<? extends TextRange> targetRanges) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(targetRanges, (String)"targetRanges");
        return SequencesKt.map(targetRanges, arg_0 -> PythonInlinePromptDetector.findInlinePrompts$lambda$0(this, file2, arg_0));
    }

    private final TextRange findInlinePromptInRange(PsiFile file2, TextRange range) {
        if (range.getLength() > 1000) {
            return null;
        }
        ProgressManager.checkCanceled();
        if (this.isFullLinePrompt(file2, range)) {
            return range;
        }
        return this.findContextPrompt(file2, range);
    }

    private final boolean isFullLinePrompt(PsiFile file2, TextRange range) {
        PsiElement psiElement = file2.findElementAt(range.getStartOffset());
        if (psiElement == null) {
            return false;
        }
        PsiElement firstElement = psiElement;
        return !(firstElement instanceof PsiWhiteSpace) && firstElement.getParent().getNextSibling() instanceof PsiErrorElement;
    }

    /*
     * Unable to fully structure code
     */
    private final TextRange findContextPrompt(PsiFile file, TextRange range) {
        block5: {
            $this$firstOrNull$iv = PythonInlinePromptDetector.findContextPrompt$getInRangeLeafs(file, range, range.getStartOffset());
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                it = (PsiElement)element$iv;
                $i$a$-firstOrNull-PythonInlinePromptDetector$findContextPrompt$promptStartElement$1 = false;
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)PyTokenTypes.BAD_CHARACTER)) ** GOTO lbl-1000
                v0 = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)(v0 != null ? v0.toString() : null), (Object)"Py:DOLLAR")) ** GOTO lbl-1000
                v1 = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)(v1 != null ? v1.toString() : null), (Object)"Py:QUESTION_MARK")) lbl-1000:
                // 3 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        v4 = promptStartElement = (PsiElement)v3;
        if (v4 != null) {
            it = v4;
            $i$a$-let-PythonInlinePromptDetector$findContextPrompt$1 = false;
            promptStartOffset = Math.max(PsiTreeUtilKt.getStartOffset((PsiElement)it), range.getStartOffset());
            postfixLeafs = PythonInlinePromptDetector.findContextPrompt$getInRangeLeafs(file, range, PsiTreeUtilKt.getEndOffset((PsiElement)it));
            v5 = this.findPromptFinishOffset(postfixLeafs);
            promptFinishOffset = v5 != null ? v5.intValue() : range.getEndOffset();
            v6 = new TextRange(promptStartOffset, promptFinishOffset);
        } else {
            v6 = null;
        }
        return v6;
    }

    private final Integer findPromptFinishOffset(Sequence<? extends PsiElement> postfixLeafs) {
        PsiElement terminator;
        Object v5;
        block9: {
            ArrayDeque stack = new ArrayDeque();
            Sequence<? extends PsiElement> $this$firstOrNull$iv = postfixLeafs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.LPAR)) {
                    PyElementType pyElementType = PyTokenTypes.RPAR;
                    Intrinsics.checkNotNullExpressionValue((Object)pyElementType, (String)"RPAR");
                    bl = !stack.add((Object)pyElementType);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.LBRACKET)) {
                    PyElementType pyElementType = PyTokenTypes.RBRACKET;
                    Intrinsics.checkNotNullExpressionValue((Object)pyElementType, (String)"RBRACKET");
                    bl = !stack.add((Object)pyElementType);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.LBRACE)) {
                    PyElementType pyElementType = PyTokenTypes.RBRACE;
                    Intrinsics.checkNotNullExpressionValue((Object)pyElementType, (String)"RBRACE");
                    bl = !stack.add((Object)pyElementType);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_FRAGMENT_START)) {
                    PyElementType pyElementType = PyTokenTypes.FSTRING_FRAGMENT_END;
                    Intrinsics.checkNotNullExpressionValue((Object)pyElementType, (String)"FSTRING_FRAGMENT_END");
                    bl = !stack.add((Object)pyElementType);
                } else {
                    bl = Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.RPAR) || Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.RBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.RBRACE) || Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_FRAGMENT_END) ? !Intrinsics.areEqual((Object)stack.removeLastOrNull(), (Object)PsiTreeUtilKt.getElementType((PsiElement)it)) : (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.LINE_BREAK) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.COMMA) ? stack.isEmpty() : false));
                }
                if (!bl) continue;
                v5 = element$iv;
                break block9;
            }
            v5 = null;
        }
        PsiElement psiElement = terminator = (PsiElement)v5;
        return psiElement != null ? Integer.valueOf(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement)) : null;
    }

    private static final List findInlinePrompts$lambda$0(PythonInlinePromptDetector this$0, PsiFile $file, TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return CollectionsKt.listOfNotNull((Object)this$0.findInlinePromptInRange($file, range));
    }

    private static final Sequence<PsiElement> findContextPrompt$getInRangeLeafs(PsiFile $file, TextRange $range, int startOffset) {
        PsiElement firstElementInRange = $file.findElementAt(startOffset);
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)firstElementInRange, PythonInlinePromptDetector::findContextPrompt$getInRangeLeafs$lambda$0), arg_0 -> PythonInlinePromptDetector.findContextPrompt$getInRangeLeafs$lambda$1($range, arg_0));
    }

    private static final PsiElement findContextPrompt$getInRangeLeafs$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PsiTreeUtilKt.nextLeaf((PsiElement)it, (boolean)true);
    }

    private static final boolean findContextPrompt$getInRangeLeafs$lambda$1(TextRange $range, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $range.intersectsStrict(it.getTextRange());
    }
}

